<?php

class stGiftCardFrontendActions extends stActions
{

   public function executeActivate()
   {
      $gift_card = $this->getRequestParameter('gift_card');

      return $this->redirect($gift_card['return_url']);
   }

   public function executeRemove()
   {
      $id = $this->getRequestParameter('id');

      $object = GiftCardPeer::retrieveByPk($id);

      if (stGiftCardPlugin::has($object))
      {
         stGiftCardPlugin::remove($object);
      }

      return $this->redirect($this->getRequest()->getReferer());
   }

   public function validateActivate()
   {
      $ok = true;

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $i18n = $this->getContext()->getI18N();
         
         $gift_card = $this->getRequestParameter('gift_card');

         if (empty($gift_card['code']))
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Wprowadź kod'));

            return false;
         }

         $object = GiftCardPeer::retrieveByCode($gift_card['code']);

         if (!$object)
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Bon o podanym kodzie nie istnieje'));

            $ok = false;
         }
         elseif (stGiftCardPlugin::has($object))
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Bon o podanym kodzie jest już aktywny'));

            $ok = false;
         }
         elseif ($object->getCurrency()->getShortcut() != stCurrency::getInstance($this->getContext())->get()->getShortcut())
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Bonem o podanym kodzie można płacić wyłącznie w walucie %currency%', array('%currency%' => $object->getCurrency()->getShortcut())));

            $ok = false;
         }
         elseif (count(stGiftCardPlugin::get()) > 1)
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Nie możesz aktywować więcej niż 1 bon'));

            $ok = false;
         }         
         elseif (!$object->isValid())
         {
            $this->setFlash('st_gift_card_error', $i18n->__('Bon o podanym kodzie jest nieważny'));

            $ok = false;
         }
         else
         {
            stGiftCardPlugin::add($object);
         }
      }

      return $ok;
   }

   public function handleErrorActivate()
   {
      return $this->redirect($this->getRequestParameter('gift_card[return_url]'));
   }

}
