<?php

class stGiftCardFrontendComponents extends sfComponents
{

   public function executeShow()
   {
      $config = stConfig::getInstance($this->getContext(), 'stGiftCardBackend');

      if (!$config->get('enabled'))
      {
         return sfView::NONE;
      }

      $this->smarty = new stSmarty('stGiftCardFrontend');

      $this->smarty->assign('form', array(
          'code' => $this->getRequestParameter('gift_card[coupon_code]'),
          'action' => $this->getController()->genUrl(array('module' => 'stGiftCardFrontend', 'action' => 'activate')),
          'error' => $this->getFlash('st_gift_card_error'),
          'return_url' => $this->return_url
      ));


      $gift_cards = stGiftCardPlugin::get();

      if ($gift_cards)
      { 
         $controller = $this->getController();
         
         $results = array();
         
         foreach ($gift_cards as $index => $gift_card)
         {
            $results[$index] = array(
                'instance' => $gift_card, 
                'code' => $gift_card->getCode(), 
                'amount' => $gift_card->getAmount(true),
                'remove_url' => $controller->genUrl('@stGiftCardRemove?id='.$gift_card->getId()));
         }
         
         $this->smarty->assign('gift_cards', $results);
      }
      

   }

}

