<?php
/** 
 * SOTESHOP/stGoogleAnalyticsPlugin
 *
 * Ten plik należy do aplikacji stDelivery opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stGoogleAnalyticsPlugin
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stGoogleAnalyticsFrontendPluginComponents.class.php 1637 2009-06-08 13:13:29Z krzysiek $
 */

/**
 * Akcje stGoogleAnalyticsFrontend
 *
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>, Paweł Byszewski <pawel.byszewski@sote.pl>,
 * @package     stGoogleAnalyticsPlugin
 */
class stGoogleAnalyticsFrontendPluginComponents extends sfComponents
{
    /**
     * Włącza google analytics w sklepie, jeśli konfiguracja na to pozwala
     */
    public function executeStandard()
    {

        $config = stConfig::getInstance(sfContext::getInstance(), 'stGoogleAnalyticsBackend');

        $this->analytics_part2 = $config->get('analytics_part2');
        $this->analytics_part3 = $config->get('analytics_part3');
        $this->analytics = $config->get('analytics');
        $this->ecommerce = $config->get('ecommerce');

        if (!$this->analytics)
        {
            return sfView::NONE;
        }
        if ((sfContext::getInstance()->getActionName()=='summary') && (sfContext::getInstance()->getModuleName()=='stOrder') && ($this->ecommerce==1))
        {
            return sfView::NONE;
        }
        
        $this->smarty = new stSmarty('stGoogleAnalyticsFrontend');

    }

    /**
     * Włącza ecommerce w sklepie, jeśli konfiguracja na to pozwala
     */
    public function executeEcommerce()
    {
        $config = stConfig::getInstance(sfContext::getInstance(), 'stGoogleAnalyticsBackend');
        $this->analytics_part2 = $config->get('analytics_part2');
        $this->analytics_part3 = $config->get('analytics_part3');
        $this->ecommerce = $config->get('ecommerce');
        $this->analytics = $config->get('analytics');

        if (!$this->ecommerce)
        {
            return sfView::NONE;
        }
        
        $this->smarty = new stSmarty('stGoogleAnalyticsFrontend');

        $id = $this->getRequestParameter('id');

        $hash_code = $this->getRequestParameter('hash_code');

        $this->order = OrderPeer::retrieveByIdAndHashCode($id, $hash_code);

        $this->host = $this->getRequest()->getHost();

        $this->order_delivery = OrderDeliveryPeer::retrieveByPK($this->order->getOrderDeliveryId());

        $user_id = $this->order->getSfGuardUserId();

        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $this->user = UserDataPeer::doSelectOne($c);

        $country_id = $this->user->getCountriesId();

        $this->country_name = CountriesPeer::retrieveByPK($country_id);

        $this->google_category = array();

        foreach ($this->order->getOrderProducts() as $order_products)
        {
            $d = new Criteria();
            $d->addJoin(ProductHasCategoryPeer::CATEGORY_ID, CategoryPeer::ID);
            $d->add(ProductHasCategoryPeer::PRODUCT_ID,$order_products->getProductId());
            $d->add(ProductHasCategoryPeer::IS_DEFAULT,1);
            $category_default = CategoryPeer::doSelectOne($d);

            if ($category_default)
            {
                $this->google_category[$order_products->getProductId()] = $category_default->getOptName();
            }
            else
            {
                $c = new Criteria();
                $c->addJoin(ProductHasCategoryPeer::CATEGORY_ID, CategoryPeer::ID);
                $c->add(ProductHasCategoryPeer::PRODUCT_ID,$order_products->getProductId());
                $category = CategoryPeer::doSelectOne($c);
                if ($category)
                {
                    $this->google_category[$order_products->getProductId()] = $category->getOptName();
                }
                else
                {
                    $this->google_category[$order_products->getProductId()] = 'none';
                }
            }
        }
    }

}