<?php
class stIfirmaListener{

	public static $create_invoice_url = 'https://www.ifirma.pl/iapi/fakturakraj.json';

	public static $create_proforma_url = 'https://www.ifirma.pl/iapi/fakturaproformakraj.json';

	public static $download_proforma_url = 'https://www.ifirma.pl/iapi/fakturaproformakraj/';

	public static $download_invoice_url = 'https://www.ifirma.pl/iapi/fakturakraj/';
	
	public static $register_url = 'https://www.ifirma.pl/iapi/abonent/rejestracja.json';
	
	public static $pranter_name = 'SOTE';
	
	public static $pratner_key = '2DEF9E2AFA3C49A7';
	
	public static function generateStProduct(sfEvent $event)
	{
		$event->getSubject()->attachAdminGeneratorFile('stIfirmaPlugin', 'stIfirmaPlugin.yml');
	}
	public static function generateIvoiceProforma(sfEvent $event)
    {
        if (self::isActive()==false) return false;
        $order = $event['order'];
        $invoiceDefault = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');

        $invoiceDataDefault = $invoiceDefault->load();
        $data = json_encode(self::getJSONStruct($invoiceDefault, $order,true));
        $rsp = self::createInvoice($data, self::$create_proforma_url);
        if ($rsp['response']['Kod'] === 0) 
        {
           $event['order']->setIfirmaProformaId($rsp['response']['Identyfikator']);
        }

    }

	public static function generateIvoice(sfEvent $event)
    {
    }

	public static function generateUpdateInvoice(sfEvent $event)
    {
    }

    public static function createInvoice($json, $url)
    {
        $ifirmaConfig = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');
        $key = self::hexToStr($ifirmaConfig->get('ifirma_key_faktura'));

        $curlHandle = curl_init($url);

        $fileType = 'json';
        $keyName = 'faktura';
        $hash = self::hmac($key,$url.$ifirmaConfig->get('ifirma_login').$keyName.$json);

        $headers=array(
            'Accept: application/'.$fileType,
            'Content-type: application/'.$fileType.'; charset=UTF-8',
            'Authentication: IAPIS user='.$ifirmaConfig->get('ifirma_login').', hmac-sha1='.$hash
        );
        
        curl_setopt($curlHandle, CURLOPT_TIMEOUT, 300);
        curl_setopt($curlHandle, CURLOPT_CONNECTTIMEOUT,100);
        curl_setopt($curlHandle, CURLOPT_URL, $url);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curlHandle, CURLOPT_HTTPGET, false);
        curl_setopt($curlHandle, CURLOPT_POST, true);
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $json);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER,0);
            
        $rsp = curl_exec($curlHandle);
        return json_decode($rsp,true);
    }

    
    public static function getJSONStruct($config, $order, $proforma = false)
    {

        $i18n = sfContext::getInstance()->getI18N();
        $pcs = $i18n->__('szt.', null, 'stInvoicePdf');
        $json = new stdClass();

        if (!$proforma) $json->Zaplacono = 0;
        $json->LiczOd = 'BRT';
        $json->NumerKontaBankowego = null;  
        $json->DataWystawienia= date('Y-m-d');
        $json->MiejsceWystawienia= $config->get('town');
        if (!$proforma) $json->DataSprzedazy= $order->getCreatedAt('Y-m-d');
        if (!$proforma) $json->FormatDatySprzedazy= 'DZN';
        $json->TerminPlatnosci = null; 
        $json->SposobZaplaty= 'PRZ';
        if (!$proforma) $json->NazwaSeriiNumeracji= 'default';
        $json->NazwaSzablonu= 'logo';
        $json->RodzajPodpisuOdbiorcy= 'OUP';
        $json->PodpisOdbiorcy = $config->get('customer_signature');
        $json->PodpisWystawcy = $config->get('seller_signature');
        $json->Uwagi = '';
        $json->WidocznyNumerGios = 1;
        $json->Numer= null;

        $json->Pozycje= array();
        foreach ($order->getOrderProducts() as $orderProduct)
        {   
            $discountProduct = $orderProduct->getDiscount();
            $tmp = new stdClass();
            $tmp->StawkaVat = $orderProduct->getVat()/100.0;
            $tmp->Ilosc = $orderProduct->getQuantity();
            $tmp->CenaJednostkowa = $orderProduct->getPrice(true, $config->get('shop_currency'));
            $tmp->NazwaPelna = $orderProduct->getName();
            $tmp->Jednostka = $pcs;
            $tmp->PKWiU = null;
            $tmp->TypStawkiVat = 'PRC';
            if ($discountProduct['percent']>0) $tmp->Rabat = $discountProduct['percent'];
            $json->Pozycje[] = $tmp;
        }
        $json->Kontrahent = new stdClass();
        $json->Kontrahent->Nazwa = $order->getOrderUserDataBilling()->getFullName();
        $json->Kontrahent->Identyfikator = null;
        $json->Kontrahent->PrefiksUE= null;
        $nip = $order->getOrderUserDataBilling()->getVatNumber();
        $json->Kontrahent->NIP= empty($nip)?null:$nip;
        $json->Kontrahent->Ulica= $order->getOrderUserDataBilling()->getAddress();
        $json->Kontrahent->KodPocztowy= $order->getOrderUserDataBilling()->getCode();
        $json->Kontrahent->Kraj= $order->getOrderUserDataBilling()->getCountry()->getName();
        $json->Kontrahent->Miejscowosc= $order->getOrderUserDataBilling()->getTown();
        $json->Kontrahent->Email= 'em@il.pl';
        $json->Kontrahent->Telefon= $order->getOrderUserDataBilling()->getPhone();

        return $json;
    }	

    public static function downloadInvoice($id, $proforma=false, $typ='')
    {
        $url = self::$download_invoice_url.$id.'.pdf.'.$typ;
        if ($proforma) $url = self::$download_proforma_url.$id.'.pdf.'.$typ;
        $ch = curl_init($url);

        $ifirmaConfig = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');
        $key = self::hexToStr($ifirmaConfig->get('ifirma_key_faktura'));

        $curlHandle = curl_init($url);

        $keyName = 'faktura';
        $hash = self::hmac($key,$url.$ifirmaConfig->get('ifirma_login').$keyName);

        $headers=array(
            'Accept: application/pdf',
            'Content-type: application/pdf; charset=UTF-8',
            'Authentication: IAPIS user='.$ifirmaConfig->get('ifirma_login').', hmac-sha1='.$hash
        );
        
        curl_setopt($curlHandle, CURLOPT_TIMEOUT, 300);
        curl_setopt($curlHandle, CURLOPT_CONNECTTIMEOUT,100);
        curl_setopt($curlHandle, CURLOPT_URL, $url);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curlHandle, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curlHandle, CURLOPT_HTTPGET, true);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER,0);
            
        $rsp = curl_exec($curlHandle);
        curl_close($ch);
        return $rsp;
    }

	public static function hmac($key,$data) {
		$blocksize=64;
		$hashfunc='sha1';
		if (strlen($key)>$blocksize)
			$key=pack('H*', $hashfunc($key));
		$key=str_pad($key,$blocksize,chr(0x00));
		$ipad=str_repeat(chr(0x36),$blocksize);
		$opad=str_repeat(chr(0x5c),$blocksize);
		$hmac = pack('H*',$hashfunc(($key^$opad).pack('H*',$hashfunc(($key^$ipad).$data))));
		return bin2hex($hmac);
	} 
	
	public static function hexToStr($hex)
	{
		$string='';
		for ($i=0; $i < strlen($hex)-1; $i+=2)
		{
			$string .= chr(hexdec($hex[$i].$hex[$i+1]));
		}
		return $string;
	}	

    public static function isActive()
    {
        $ifirmaConfig = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');
        if ($ifirmaConfig->get('ifirma_enabled') && strlen(trim($ifirmaConfig->get('ifirma_login'))) && strlen(trim($ifirmaConfig->get('ifirma_key_faktura')))) return true;
        return false; 
    }
	
	
	public static function registerUser($user_data)
	{    

	$newUser = new stdClass();
	$newUser->Email = $user_data['ifirma_register_email'];
	$newUser->NazwaFirmyPelna = $user_data['ifirma_register_fullname'];
	$newUser->NazwaFirmySkrocona = $user_data['ifirma_register_name'];
	$newUser->Telefon = $user_data['ifirma_register_phone'];
	$newUser->Regon = null; 
	$newUser->NIP = $user_data['ifirma_register_nip'];
	$newUser->Wojewodztwo = null;
	$newUser->Gmina = null;
	$newUser->Powiat = null;
	$newUser->Miejscowosc = $user_data['ifirma_register_town'];
	$newUser->Poczta = $user_data['ifirma_register_post'];
	$newUser->KodPocztowy = $user_data['ifirma_register_code'];
	$newUser->Ulica = $user_data['ifirma_register_street'];
	$newUser->NumerDomu = $user_data['ifirma_register_home'];
	$newUser->NumerLokalu = $user_data['ifirma_register_flat'];
	$newUser->PierwszyMiesiacKsiegowania = intval($user_data['ifirma_register_date_start_month']+1);
	$newUser->PierwszyRokKsiegowania = intval($user_data['ifirma_register_date_start_year']);
	$newUser->FormaPrawna = $user_data['ifirma_register_business'];
	$newUser->RozpVatowiec = intval($user_data['ifirma_register_is_vat']);
	$newUser->RokRozpoczeciaVatowiec = null;
	$newUser->MiesiacRozpoczeciaVatowiec = null;
	$newUser->RokRozpoczeciaDzialalnosci = null;
	$newUser->MiesiacRozpoczeciaDzialalnosci = null;

	$newUnserName = new stdClass();
	$newUnserName->ImieWlasciciela = $user_data['ifirma_register_firstname'];
	$newUnserName->NazwiskoWlasciciela = $user_data['ifirma_register_surname'];

	$newUser->Wlasciciele = array($newUnserName);

    $key = self::hexToStr(self::$pratner_key);
    $keyName = 'abonent';
    $requestContent = json_encode($newUser);

    $hash = self::hmac($key,self::$register_url.self::$pranter_name.$keyName.$requestContent);
    $headers=array(
        'Accept: application/json',
        'Content-type: application/json; charset=UTF-8',
        'Authentication: IAPIS user='.self::$pranter_name.', hmac-sha1='.$hash
    );
    $curlHandle = curl_init(self::$register_url);
	curl_setopt($curlHandle, CURLOPT_TIMEOUT, 300);
	curl_setopt($curlHandle, CURLOPT_CONNECTTIMEOUT,100);
	curl_setopt($curlHandle, CURLOPT_URL, self::$register_url);
	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curlHandle, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($curlHandle, CURLOPT_HTTPGET, false);
	curl_setopt($curlHandle, CURLOPT_POST, true);
	curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $requestContent);
	curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST,0);
	curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER,0);
        
    $rsp = curl_exec($curlHandle);

    curl_close($curlHandle);
    return json_decode($rsp,true);
    }
}
