<?php
/** 
 * SOTESHOP/stAllegroPlugin 
 * 
 * Ten plik należy do aplikacji stAllegroPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stAllegroPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stAllegroImageValidator.class.php 10 2009-08-24 09:32:18Z michal $
 * @author      Piotr Halas <piotr.halas@sote.pl>
 */
 
/** 
 * Klasa stAllegroDeliveryValidator
 *
 * @package     stAllegroPlugin
 * @subpackage  libs
 */
class stIfirmaValidator extends sfValidator
{

    /** 
     * Wykonuje sprawdzanie
     *
     * @param        object      $value
     * @param        object      $error
     * @return   boolean
     */
    public function execute (&$value, &$error)
    {
        $config = $this->getContext()->getRequest()->getParameter('config',null);
        $rsp = stIfirmaListener::registerUser($config);
        if ($rsp['response']['Kod']>0) {
            $error = $rsp['response']['Informacja'];
            return false;
        }
        return true;
    }

    /** 
     * Inicjalizacja validatora
     *
     * @param        object      $context
     * @param         array       $parameters
     * @return   boolean
     */
    public function initialize ($context, $parameters = null)
    {
        // Initialize parent
        parent::initialize($context);

        // Set default parameters value
        $this->setParameter('register_error', 'Błąd podczas rejestracji.');

        // Set parameters
        $this->getParameterHolder()->add($parameters);

        return true;
    }
}

?>
