<?php
class stIFirmaPdfActions extends stActions {

    public function executeShowProforma() {
        $pdf = stIfirmaListener::downloadInvoice($this->getRequestParameter('id'),true,'oryg');
        $this->getResponse()->setContentType('application/pdf');
        $this->getResponse()->setHttpHeader('Content-disposition', 'attachment; filename=proforma_'.$this->getRequestParameter('id').'.pdf');
        $this->renderText($pdf);
        return sfView::NONE;
    }

    public function executeShowInvoice() {
        if (SF_APP == 'frontend') $pdf = stIfirmaListener::downloadInvoice($this->getRequestParameter('id'),false,'oryg');
        else $pdf = stIfirmaListener::downloadInvoice($this->getRequestParameter('id'),false,'');
        $this->getResponse()->setContentType('application/pdf');
        $this->getResponse()->setHttpHeader('Content-disposition', 'attachment; filename=invoice_'.$this->getRequestParameter('id').'.pdf');
        $this->renderText($pdf);
        return sfView::NONE;
    }


    public function executeMakeInvoice()
    {
        $order = OrderPeer::retrieveByPk($this->getRequestParameter('id'));
        $invoice = InvoicePeer::retrieveByPk($this->getRequestParameter('invoice_id'));

        $invoiceDefault = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');

        $invoiceDataDefault = $invoiceDefault->load();
        $data = json_encode(stIfirmaListener::getJSONStruct($invoiceDefault, $order));

        $rsp = stIfirmaListener::createInvoice($data, stIfirmaListener::$create_invoice_url);
        if ($rsp['response']['Kod'] === 0) 
        {
            $order->setIfirmaInvoiceId($rsp['response']['Identyfikator']);
            $order->save();
        }
        $this->redirect('stOrder/edit?id='.$this->getRequestParameter('id'));
    }
}

