<?php


abstract class BaseExportProfileHasExportField extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $export_profile_id;


	
	protected $export_field_id;

	
	protected $aExportProfile;

	
	protected $aExportField;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getExportProfileId()
    {

            return $this->export_profile_id;
    }

    
    public function getExportFieldId()
    {

            return $this->export_field_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ExportProfileHasExportFieldPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ExportProfileHasExportFieldPeer::UPDATED_AT;
		}

	} 
	
	public function setExportProfileId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->export_profile_id !== $v) {
          $this->export_profile_id = $v;
          $this->modifiedColumns[] = ExportProfileHasExportFieldPeer::EXPORT_PROFILE_ID;
        }

		if ($this->aExportProfile !== null && $this->aExportProfile->getId() !== $v) {
			$this->aExportProfile = null;
		}

	} 
	
	public function setExportFieldId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->export_field_id !== $v) {
          $this->export_field_id = $v;
          $this->modifiedColumns[] = ExportProfileHasExportFieldPeer::EXPORT_FIELD_ID;
        }

		if ($this->aExportField !== null && $this->aExportField->getId() !== $v) {
			$this->aExportField = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ExportProfileHasExportField.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->export_profile_id = $rs->getInt($startcol + 2);

      $this->export_field_id = $rs->getInt($startcol + 3);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ExportProfileHasExportField.postHydrate', array('resultset' => $rs, 'startcol' => 4)));

            return $startcol + 4; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ExportProfileHasExportField object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseExportProfileHasExportField:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ExportProfileHasExportFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ExportProfileHasExportFieldPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseExportProfileHasExportField:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ExportProfileHasExportField.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseExportProfileHasExportField:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ExportProfileHasExportFieldPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ExportProfileHasExportFieldPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ExportProfileHasExportFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ExportProfileHasExportField.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseExportProfileHasExportField:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aExportProfile !== null) {
				if ($this->aExportProfile->isModified()) {
					$affectedRows += $this->aExportProfile->save($con);
				}
				$this->setExportProfile($this->aExportProfile);
			}

			if ($this->aExportField !== null) {
				if ($this->aExportField->isModified()) {
					$affectedRows += $this->aExportField->save($con);
				}
				$this->setExportField($this->aExportField);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ExportProfileHasExportFieldPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += ExportProfileHasExportFieldPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aExportProfile !== null) {
				if (!$this->aExportProfile->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aExportProfile->getValidationFailures());
				}
			}

			if ($this->aExportField !== null) {
				if (!$this->aExportField->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aExportField->getValidationFailures());
				}
			}


			if (($retval = ExportProfileHasExportFieldPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ExportProfileHasExportFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getExportProfileId();
				break;
			case 3:
				return $this->getExportFieldId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ExportProfileHasExportFieldPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getExportProfileId(),
			$keys[3] => $this->getExportFieldId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ExportProfileHasExportFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setExportProfileId($value);
				break;
			case 3:
				$this->setExportFieldId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ExportProfileHasExportFieldPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setExportProfileId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setExportFieldId($arr[$keys[3]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ExportProfileHasExportFieldPeer::DATABASE_NAME);

		if ($this->isColumnModified(ExportProfileHasExportFieldPeer::CREATED_AT)) $criteria->add(ExportProfileHasExportFieldPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ExportProfileHasExportFieldPeer::UPDATED_AT)) $criteria->add(ExportProfileHasExportFieldPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ExportProfileHasExportFieldPeer::EXPORT_PROFILE_ID)) $criteria->add(ExportProfileHasExportFieldPeer::EXPORT_PROFILE_ID, $this->export_profile_id);
		if ($this->isColumnModified(ExportProfileHasExportFieldPeer::EXPORT_FIELD_ID)) $criteria->add(ExportProfileHasExportFieldPeer::EXPORT_FIELD_ID, $this->export_field_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ExportProfileHasExportFieldPeer::DATABASE_NAME);

		$criteria->add(ExportProfileHasExportFieldPeer::EXPORT_PROFILE_ID, $this->export_profile_id);
		$criteria->add(ExportProfileHasExportFieldPeer::EXPORT_FIELD_ID, $this->export_field_id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getExportProfileId();

		$pks[1] = $this->getExportFieldId();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setExportProfileId($keys[0]);

		$this->setExportFieldId($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);


		$copyObj->setNew(true);

		$copyObj->setExportProfileId(NULL); 
		$copyObj->setExportFieldId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ExportProfileHasExportFieldPeer();
		}
		return self::$peer;
	}

	
	public function setExportProfile($v)
	{


		if ($v === null) {
			$this->setExportProfileId(NULL);
		} else {
			$this->setExportProfileId($v->getId());
		}


		$this->aExportProfile = $v;
	}


	
	public function getExportProfile($con = null)
	{
		if ($this->aExportProfile === null && ($this->export_profile_id !== null)) {
						$this->aExportProfile = ExportProfilePeer::retrieveByPK($this->export_profile_id, $con);

			
		}
		return $this->aExportProfile;
	}

	
	public function setExportField($v)
	{


		if ($v === null) {
			$this->setExportFieldId(NULL);
		} else {
			$this->setExportFieldId($v->getId());
		}


		$this->aExportField = $v;
	}


	
	public function getExportField($con = null)
	{
		if ($this->aExportField === null && ($this->export_field_id !== null)) {
						$this->aExportField = ExportFieldPeer::retrieveByPK($this->export_field_id, $con);

			
		}
		return $this->aExportField;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ExportProfileHasExportField.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseExportProfileHasExportField:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseExportProfileHasExportField::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 