<?php
/**
 * SOTESHOP/stImportExportPlugin
 *
 * Ten plik należy do aplikacji stImportExportPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stImportExportPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stImportExportPropel.class.php 13384 2011-06-02 11:30:57Z piotr $
 * @author      Piotr Halas <piotr.halas@sote.pl>
 */

/**
 * Klasa modulu generator odpowiedzalna za eksport/import danych
 *
 * @package     stImportExportPlugin
 * @subpackage  libs
 */
class stImportExportPropel
{

    /**
     * Nazwa metody, przyjmuje wartosci exsport lub import
     * @var string
     */
    var $method = '';

    /**
     * Glowny model importu/eksportu
     * @var string
     */
    var $model = '';

    /**
     * Nazwa klasy eksportera
     * @var string
     *
     * @package     stImportExportPlugin
     * @subpackage  libs
     */
    var $class_name = '';

    /**
     * Wskaznik do obiektu eksportera importera
     * @var object
     *
     * @package     stImportExportPlugin
     * @subpackage  libs
     */
    var $class_handle = null;

    /**
     * Wskaznik do obiektu kontrolera
     * @var object
     */
    var $controller = null;

    /**
     * Wskaznik do obiektu Context
     * @var object
     */
    var $context = null;

    /**
     * Zmienna zawiera konfiguracje pol do eksportu
     * @var string
     */
    var $fields = array();

    /**
     * Profile id
     * @var integer
     */
    protected $profile = 0;

    /**
     * nazwa pliku tymczasowego
     * @var string
     */
    var $file = '';

    var $export_limit = 20;

    var $import_limit = 5;

    var $auto_detect_line_endings = '';

    /**
     * Konstruktor klasy, parametr method przyjmuje wartosc 'export' lub 'import'
     * class zawiera nazwe klasy eksportera
     * file - nazwe pliku tymczasowego w przypadku importu
     *
     * @param        string      $method
     * @param        string      $class
     * @param        string      $file
     *
     * @package     stImportExportPlugin
     * @subpackage  libs
     */
    public function __construct($method='', $class = '', $file='', $profile = 0)
    {

        $this->auto_detect_line_endings = ini_get('auto_detect_line_endings');
        ini_set('auto_detect_line_endings', true);

        // pobiera instancje clasy contekst oraz cotroller
        $this->context = sfContext::getInstance();
        $this->controller = $this->context->getController();

        // zapamietuje podane parametry
        $this->method =  $method;
        $this->class_name =  $class;
        $this->file = $file;
        $this->profile = $profile;

        // odczytuje i ustawia pola wykorzystywane w imporcie eksporcie
        $this->setFields();

        //tworzy klase importera lub eksportera
        $this->setImporterExporter();
    }

    public function __destruct()
    {
        ini_set('auto_detect_line_endings',$this->auto_detect_line_endings);
    }

    /**
     * Pobiera pola do eksportu z konfiguracji
     *
     * @return   array
     */
    public function getExportFields()
    {
        return $this->export['fields'];
    }

    /**
     * Pobiera pola do importu z konfiguracji
     *
     * @return   array
     */
    public function getImportFields()
    {
        return  $this->import['fields'];
    }

    /**
     * Ustawia odpowiednie pola do importu/eksportu
     */
    protected function setFields()
    {

        // w zaleznosci od metody ustaw odpowiednie pola
        switch ($this->method)
        {
            case "export":
                $this->fields['primary_key'] = $this->export['primary_key'];
                $this->fields['fields'] = $this->getExportFields();
                break;
            case "import":
                $this->fields['primary_key'] = $this->import['primary_key'];
                $this->fields['default_class'] = $this->import['default_class'];
                $this->fields['fields'] = $this->getImportFields();
                break;
        }

        if ($this->profile != 0)
        {
            $profile = ExportProfilePeer::retrieveByPk($this->profile);
            if (is_object($profile))
            {
                $c = new Criteria();
                $c->add(ExportFieldPeer::FIELD, array_keys($this->fields['fields']), Criteria::IN);
                $c->addJoin(ExportFieldPeer::ID,ExportProfileHasExportFieldPeer::EXPORT_FIELD_ID);
                $c->add(ExportProfileHasExportFieldPeer::EXPORT_PROFILE_ID, $profile->getId());

                $tmp =array();
                $tmp[$this->import['primary_key']] = $this->fields['fields'][$this->import['primary_key']];
                foreach (ExportFieldPeer::doSelect($c) as $activeFields)
                {
                    $tmp[$activeFields->getField()] = $this->fields['fields'][$activeFields->getField()];
                }

                //add primary key
                $this->fields['fields'] = $tmp;
            }
        }

    }

    /**
     * Tworzy obiekt importera eksportera
     */
    protected function setImporterExporter()
    {
        if (!class_exists($this->class_name))
        {
            throw new Exception("");
        }
        $this->class_handle = new $this->class_name($this->model,$this->fields, $this->file);
        $this->setLimits();
    }

    public function getImporterExporter()
    {
        return $this->class_handle;
    }
    /**
     * Wykonuje methodye doProcess importera/eksportera, jako parametr przyjmyje
     * numer kroku do wykonan, zwraca numer kolejnego kroku
     *
     * @param       integer     $offset
     * @return   integer
     */
    public function doProcess($offset = 0)
    {
        $offset = $this->class_handle->doProcess($offset);
        return $offset;
    }

    /**
     * Zwraca liczbe krokow do wykonania
     *
     * @return   integer
     */
    public function getDataCount()
    {
        return $this->class_handle->getDataCount();
    }

    public function validateFile()
    {
        return $this->class_handle->validateFile();
    }

    public function sampleFile()
    {
        return $this->class_handle->sampleFile($this->getSampleRow());
    }

    public function setLimits()
    {
        // w zaleznosci od metody ustaw odpowiednie pola

        if ($this->class_handle)
        {
            switch ($this->method)
            {
                case "export":
                    $this->class_handle->setLimit($this->export_limit);
                    break;
                case "import":
                    $this->class_handle->setLimit($this->import_limit);
                    break;
            }
        }
    }

    private function getSampleRow()
    {

        $tmp =array();
        foreach ($this->fields['fields'] as $key => $field)
        {
            if (isset($field['sample']))
            {
                $tmp[$key] = $field['sample'];
            } else
            {
                $tmp[$key] = '';
            }
        }
        return array($tmp);
    }

    public static function getProfiles($model = '')
    {
        $profiles = array(sfContext::getInstance()->getI18n()->__('Profil domyślny', array(), 'stImportExportBackend'));

        $c = new Criteria();
        $c->add(ExportProfilePeer::MODEL, $model);
        $c->addAscendingOrderByColumn(ExportProfilePeer::NAME);

        foreach (ExportProfilePeer::doSelect($c) as $profile)
        {
            $profiles[$profile->getId()] = sfContext::getInstance()->getI18n()->__($profile->getName(), array(), 'stImportExportBackend');
        }

        return $profiles;
    }

    public static function updateExportProfiles($model = '', $fields = array(), $primary_key = '')
    {
        if (is_array($fields) && count($fields))
        {
            $in = array();
            foreach ($fields as $key => $value)
            {
                $in[] = $key;
            }

            //deleting old fields
            $c = new Criteria();
            $c->add(ExportFieldPeer::FIELD, $in, Criteria::NOT_IN );
            $c->add(ExportFieldPeer::MODEL, $model);
            ExportFieldPeer::doDelete($c);

            //inserting new
            $c = new Criteria();
            $c->add(ExportFieldPeer::MODEL, $model);
            $dbFields = ExportFieldPeer::doSelect($c);

            foreach ($dbFields as $dbField)
            {
                $key = array_search($dbField->getField(), $in);
                if ($key!==false)
                {
                    unset($in[$key]);
                }
            }

            foreach ($in as $addField)
            {
                $tmp = new ExportField();
                $tmp->setModel($model);
                $tmp->setField($addField);
                $tmp->setIsKey(strcmp($addField, $primary_key)==0?1:0);
                $tmp->setName($fields[$addField]['name']);
                $tmp->save();
            }
        }
    }
}
