<?php

class stImportExportBackendActions extends autoStImportExportBackendActions
{

   public function executeList()
   {
      parent::executeList();

      $c = $this->pager->getCriteria();

      if (!$this->hasRequestParameter('model') && !isset($this->forward_parameters['model']))
         $this->forward();
      $model = $this->getRequestParameter('model', $this->forward_parameters['model']);

      $c->add(ExportProfilePeer::MODEL, $model);

      $this->pager->init();
   }

   protected function getExportProfileOrCreate($id = 'id')
   {
      $export_profile = parent::getExportProfileOrCreate($id);
      if ($export_profile->isNew())
      {
         $export_profile->setModel($this->getRequestParameter('model'));
      }
      return $export_profile;
   }

   public function validateEdit()
   {

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $ids = $this->getRequestParameter('associated_field', array());

         //No fields selected
         if (!count($ids))
         {
            $this->getRequest()->setError('export_profile{field}', sfContext::getInstance()->getI18n()->__('Proszę wybrać co najmniej jedno pole.'));
            return false;
         }
      }
      return true;
   }

}