<?php

/**
 * SOTESHOP/stBasket
 *
 * Ten plik należy do aplikacji stBasket opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBasket
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stInvoiceListener.class.php 2695 2009-08-20 12:16:15Z bartek $
 */
/**
 * Ładowanie helpera
 */
sfLoader::loadHelpers(array('Helper', 'stOrder'));

/**
 * Klasa sluchacza dla stBasket
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stBasket
 * @subpackage  libs
 */
class stInvoiceListener
{

   public static function postExecuteOrderSave(sfEvent $event)
   {
      $order = $event->getSubject()->order;

      $user_data_billing = $event->getSubject()->getRequestParameter('user_data_billing');

      $invoiceId = stInvoiceListener::crateInvoiceProforma($order);

      if (isset($user_data_billing['invoice']))
      {

         if ($user_data_billing['invoice'] == 1)
         {
            stInvoiceListener::crateInvoiceRequest($order, $invoiceId);
         }
      }
   }

   //generowanie faktury proforma
   public static function crateInvoiceProforma($order)
   {

      //przygotowanie obiektu faktury proforma
      $invoice = new Invoice();

      $invoice->setIsProforma(1);

      stEventDispatcher::getInstance()->notify(new sfEvent($order, 'stInvoiceListener.preCrateInvoiceProforma', array('order'=>$order, 'invoice'=>$invoice)));

      $invoiceUserSeller = new InvoiceUserSeller();

      $invoiceUserCustomer = new InvoiceUserCustomer();

      $context = sfContext::getInstance();

      $i18n = $context->getI18N();

      $invoiceDefault = stConfig::getInstance($context, 'stInvoiceBackend');

      $invoiceDataDefault = $invoiceDefault->load();

      $invoice->save();

      stInvoice::updateOrCreatePayment($invoice, $order);

      $invoiceUserSeller->setCompany($invoiceDataDefault['seller_company']);
      $invoiceUserSeller->setVatNumber($invoiceDataDefault['seller_vat_number']);
      $invoiceUserSeller->setFullName($invoiceDataDefault['seller_full_name']);
      $invoiceUserSeller->setAddress($invoiceDataDefault['seller_address']);
      $invoiceUserSeller->setAddressMore($invoiceDataDefault['seller_address_more']);
      $invoiceUserSeller->setRegion($invoiceDataDefault['seller_region']);
      $invoiceUserSeller->setCode($invoiceDataDefault['seller_code']);
      $invoiceUserSeller->setTown($invoiceDataDefault['seller_town']);
      $invoiceUserSeller->setCountry($invoiceDataDefault['seller_country']);
      $invoiceUserSeller->save();

      //zapis klienta

      $invoiceUserCustomer->setCompany($order->getOrderUserDataBilling()->getCompany());
      $invoiceUserCustomer->setVatNumber($order->getOrderUserDataBilling()->getVatNumber());
      $invoiceUserCustomer->setFullName($order->getOrderUserDataBilling()->getFullName());
      $invoiceUserCustomer->setAddress($order->getOrderUserDataBilling()->getAddress());
      $invoiceUserCustomer->setAddressMore($order->getOrderUserDataBilling()->getAddressMore());
      $invoiceUserCustomer->setRegion($order->getOrderUserDataBilling()->getRegion());
      $invoiceUserCustomer->setCode($order->getOrderUserDataBilling()->getCode());
      $invoiceUserCustomer->setTown($order->getOrderUserDataBilling()->getTown());
      $invoiceUserCustomer->setCountry($order->getOrderUserDataBilling()->getCountry());
      $invoiceUserCustomer->save();


      $shop_currency = $invoiceDataDefault['shop_currency'];

      if ($shop_currency)
      {
         $invoiceCurrency = new InvoiceCurrency();

         $invoiceCurrency->setName($order->getOrderCurrency()->getName());

         $invoiceCurrency->setExchange($order->getOrderCurrency()->getExchange());

         $invoiceCurrency->setShortcut($order->getOrderCurrency()->getShortcut());

         $invoiceCurrency->setFrontSymbol($order->getOrderCurrency()->getFrontSymbol());

         $invoiceCurrency->setBackSymbol($order->getOrderCurrency()->getBackSymbol());

         $invoiceCurrency->save();
      }
      else
      {

         $c = new Criteria();
         $c->add(CurrencyPeer::MAIN, 1);
         $defaultCurrency = CurrencyPeer::doSelectOne($c);

         $invoiceCurrency = new InvoiceCurrency();

         $invoiceCurrency->setName($defaultCurrency->getName());

         $invoiceCurrency->setExchange($defaultCurrency->getExchange());

         $invoiceCurrency->setShortcut($defaultCurrency->getShortcut());

         $invoiceCurrency->setFrontSymbol($defaultCurrency->getFrontSymbol());

         $invoiceCurrency->setBackSymbol($defaultCurrency->getBackSymbol());

         $invoiceCurrency->save();
      }

      $invoice->setInvoiceCurrencyId($invoiceCurrency->getId());

      $invoice->setInvoiceUserSellerId($invoiceUserSeller->getId());

      $invoice->setInvoiceUserCustomerId($invoiceUserCustomer->getId());

      $invoice->setOrderId($order->getId());

      $invoice->setTown($invoiceDataDefault['town']);

      $invoice->setMaxDay($invoiceDataDefault['max_day']);

      $invoice->setPaymentType($invoiceDataDefault['payment_type']);

      $invoice->setCompanyDescription($invoiceDataDefault['company_description']);

      $date = date('Y-M-d');

      if ($invoiceDataDefault['date_create_copy'] == "")
      {
         $invoice->setDateCreateCopy($date);
      }
      else
      {
         $invoice->setDateCreateCopy($invoiceDataDefault['date_create_copy']);
      }


      if ($invoiceDataDefault['date_selle'] == "")
      {
         $invoice->setDateSelle($date);
      }
      else
      {
         $invoice->setDateSelle($invoiceDataDefault['date_selle']);
      }

      $invoice->setNumber(stInvoiceListener::createInvoiceNumber("proforma", 1));

      $invoice->setSignatureCustomer($invoiceDataDefault['customer_signature']);

      $invoice->setSignatureSeller($invoiceDataDefault['seller_signature']);

      $invoice->setOptTotalAmmountBrutto($order->getTotalAmountWithDelivery(true, $shop_currency));

      $pcs = $i18n->__('szt.', null, 'stInvoicePdf');

      $shipping_method = $i18n->__('Dostawa', null, 'stInvoicePdf');

      foreach ($order->getOrderProducts() as $orderProduct)
      {
         $invoiceProduct = new InvoiceProduct();

         $invoiceProduct->setInvoiceId($invoice->getId());

         $invoiceProduct->setProductId($orderProduct->getId());

         if ($orderProduct->hasPriceModifiers())
         {
            $options = st_order_render_product_options($orderProduct);
         }
         else
         {
            $options = "";
         }


         $invoiceProduct->setName($orderProduct->getName() . $options);

         $invoiceProduct->setQuantity($orderProduct->getQuantity());

         $invoiceProduct->setMeasureUnit($pcs);

         $discountProduct = $orderProduct->getDiscount();

         $invoiceProduct->setDiscount($discountProduct['percent']);

         $invoiceProduct->setPriceNetto($orderProduct->getPrice(false, $shop_currency));

         $invoiceProduct->setPriceBrutto($orderProduct->getPrice(true, $shop_currency));

         $totalPriceBrutto = $orderProduct->getTotalAmount(true, $shop_currency);

         $invoiceProduct->setOptTotalPriceBrutto($totalPriceBrutto);

         $totalVatAmount = $totalPriceBrutto * ($orderProduct->getVat() / (100 + $orderProduct->getVat()));

         $invoiceProduct->setVatAmmount($totalVatAmount);

         $invoiceProduct->setTotalPriceNetto($totalPriceBrutto - $totalVatAmount);

         $invoiceProduct->setVat($orderProduct->getVat());

         $invoiceProduct->setVatId($orderProduct->getTaxId());

         $invoiceProduct->save();
      }


      // koszty dostawy

      $delivery = $order->getOrderDelivery();

      $delivery_cost_brutto = $delivery->getCostBrutto($shop_currency);

      if ($delivery_cost_brutto)
      {
         $delivery_cost_netto = $delivery->getCostNetto($shop_currency);

         $invoiceProduct = new InvoiceProduct();

         $invoiceProduct->setInvoiceId($invoice->getId());

         $invoiceProduct->setName($shipping_method . " - " . $delivery->getName());

         $invoiceProduct->setQuantity(1);

         $invoiceProduct->setOptTotalPriceBrutto($delivery_cost_brutto);

         $invoiceProduct->setPkwiu("");

         $invoiceProduct->setMeasureUnit($pcs);

         $invoiceProduct->setPriceNetto($delivery_cost_netto);

         $invoiceProduct->setPriceBrutto($delivery_cost_brutto);

         $invoiceProduct->setTotalPriceNetto($delivery_cost_netto);

         $invoiceProduct->setVatAmmount($delivery_cost_brutto - $delivery_cost_netto);

         $invoiceProduct->setVat($delivery->getOptTax());

         $invoiceProduct->setVatId($delivery->getTaxId());

         $invoiceProduct->save();
      }

      $invoice->save();

      return $invoice->getId();
   }

   //generowanie faktury
   public static function crateInvoiceRequest($order, $invoiceId=null)
   {

      //tworzenie faktury

      $invoice = new Invoice();
      $invoice->setIsProforma(0);

      stEventDispatcher::getInstance()->notify(new sfEvent($order, 'stInvoiceListener.preCrateInvoiceRequest', array('order'=>$order, 'invoice'=>$invoice)));

      $invoice->setInvoiceProformaId($invoiceId);
      $invoice->setIsRequest(1);
      $invoiceUserSeller = new InvoiceUserSeller();
      $invoiceUserCustomer = new InvoiceUserCustomer();

      $context = sfContext::getInstance();
      $i18n = $context->getI18N();
      $invoiceDefault = stConfig::getInstance($context, 'stInvoiceBackend');
      $invoiceDataDefault = $invoiceDefault->load();
      $invoice->save();
      stInvoice::updateOrCreatePayment($invoice, $order);

      //zapis sprzedawcy
      $invoiceUserSeller->setCompany($invoiceDataDefault['seller_company']);
      $invoiceUserSeller->setVatNumber($invoiceDataDefault['seller_vat_number']);
      $invoiceUserSeller->setFullName($invoiceDataDefault['seller_full_name']);
      $invoiceUserSeller->setAddress($invoiceDataDefault['seller_address']);
      $invoiceUserSeller->setAddressMore($invoiceDataDefault['seller_address_more']);
      $invoiceUserSeller->setRegion($invoiceDataDefault['seller_region']);
      $invoiceUserSeller->setCode($invoiceDataDefault['seller_code']);
      $invoiceUserSeller->setTown($invoiceDataDefault['seller_town']);
      $invoiceUserSeller->setCountry($invoiceDataDefault['seller_country']);
      $invoiceUserSeller->save();

      //zapis klienta
      $invoiceUserCustomer->setCompany($order->getOrderUserDataBilling()->getCompany());
      $invoiceUserCustomer->setVatNumber($order->getOrderUserDataBilling()->getVatNumber());
      $invoiceUserCustomer->setFullName($order->getOrderUserDataBilling()->getFullName());
      $invoiceUserCustomer->setAddress($order->getOrderUserDataBilling()->getAddress());
      $invoiceUserCustomer->setAddressMore($order->getOrderUserDataBilling()->getAddressMore());
      $invoiceUserCustomer->setRegion($order->getOrderUserDataBilling()->getRegion());
      $invoiceUserCustomer->setCode($order->getOrderUserDataBilling()->getCode());
      $invoiceUserCustomer->setTown($order->getOrderUserDataBilling()->getTown());
      $invoiceUserCustomer->setCountry($order->getOrderUserDataBilling()->getCountry());
      $invoiceUserCustomer->save();

      $shop_currency = $invoiceDataDefault['shop_currency'];

      //ustawienie waluty faktury
      if ($shop_currency)
      {
         $invoiceCurrency = new InvoiceCurrency();
         $invoiceCurrency->setName($order->getOrderCurrency()->getName());
         $invoiceCurrency->setExchange($order->getOrderCurrency()->getExchange());
         $invoiceCurrency->setShortcut($order->getOrderCurrency()->getShortcut());
         $invoiceCurrency->setFrontSymbol($order->getOrderCurrency()->getFrontSymbol());
         $invoiceCurrency->setBackSymbol($order->getOrderCurrency()->getBackSymbol());
         $invoiceCurrency->save();
      }
      else
      {

         $c = new Criteria();
         $c->add(CurrencyPeer::MAIN, 1);
         $defaultCurrency = CurrencyPeer::doSelectOne($c);

         $invoiceCurrency = new InvoiceCurrency();
         $invoiceCurrency->setName($defaultCurrency->getName());
         $invoiceCurrency->setExchange($defaultCurrency->getExchange());
         $invoiceCurrency->setShortcut($defaultCurrency->getShortcut());
         $invoiceCurrency->setFrontSymbol($defaultCurrency->getFrontSymbol());
         $invoiceCurrency->setBackSymbol($defaultCurrency->getBackSymbol());
         $invoiceCurrency->save();
      }

      $invoice->setInvoiceCurrencyId($invoiceCurrency->getId());

      $invoice->setInvoiceUserSellerId($invoiceUserSeller->getId());
      $invoice->setInvoiceUserCustomerId($invoiceUserCustomer->getId());
      $invoice->setOrderId($order->getId());

      $invoice->setTown($invoiceDataDefault['town']);
      
      $invoice->setMaxDay($invoiceDataDefault['max_day']);

      $invoice->setPaymentType($invoiceDataDefault['payment_type']);

      $invoice->setCompanyDescription($invoiceDataDefault['company_description']);

      $date = date('Y-M-d');

      if ($invoiceDataDefault['date_create_copy'] == "")
      {
         $invoice->setDateCreateCopy($date);
      }
      else
      {
         $invoice->setDateCreateCopy($invoiceDataDefault['date_create_copy']);
      }


      if ($invoiceDataDefault['date_selle'] == "")
      {
         $invoice->setDateSelle($date);
      }
      else
      {
         $invoice->setDateSelle($invoiceDataDefault['date_selle']);
      }

      $invoice->setSignatureCustomer($invoiceDataDefault['customer_signature']);
      $invoice->setSignatureSeller($invoiceDataDefault['seller_signature']);

      $invoice->setOptTotalAmmountBrutto($order->getTotalAmountWithDelivery(true, $shop_currency));

      $pcs = $i18n->__('szt.', null, 'stInvoicePdf');

      $shipping_method = $i18n->__('Dostawa', null, 'stInvoicePdf');

      foreach ($order->getOrderProducts() as $orderProduct)
      {
         $invoiceProduct = new InvoiceProduct();

         $invoiceProduct->setInvoiceId($invoice->getId());

         $invoiceProduct->setProductId($orderProduct->getId());

         if ($orderProduct->hasPriceModifiers())
         {
            $options = st_order_render_product_options($orderProduct);
         }
         else
         {
            $options = "";
         }

         $invoiceProduct->setName($orderProduct->getName() . $options);

         $invoiceProduct->setQuantity($orderProduct->getQuantity());

         $invoiceProduct->setMeasureUnit($pcs);

         $discountProduct = $orderProduct->getDiscount();

         $invoiceProduct->setDiscount($discountProduct['percent']);

         $invoiceProduct->setPriceNetto($orderProduct->getPrice(false, $shop_currency));

         $invoiceProduct->setPriceBrutto($orderProduct->getPrice(true, $shop_currency));

         $totalPriceBrutto = $orderProduct->getTotalAmount(true, $shop_currency);

         $invoiceProduct->setOptTotalPriceBrutto($totalPriceBrutto);

         $totalVatAmount = $totalPriceBrutto * ($orderProduct->getVat() / (100 + $orderProduct->getVat()));

         $invoiceProduct->setVatAmmount($totalVatAmount);

         $invoiceProduct->setTotalPriceNetto($totalPriceBrutto - $totalVatAmount);

         $invoiceProduct->setVat($orderProduct->getVat());

         $invoiceProduct->setVatId($orderProduct->getProduct()->getTax()->getId());

         $invoiceProduct->save();
      }

      $delivery = $order->getOrderDelivery();

      $delivery_cost_brutto = $delivery->getCostBrutto($shop_currency);

      if ($delivery_cost_brutto != 0)
      {

         $delivery_cost_netto = $delivery->getCostNetto($shop_currency);

         $invoiceProduct = new InvoiceProduct();

         $invoiceProduct->setInvoiceId($invoice->getId());

         $invoiceProduct->setName($shipping_method . " - " . $delivery->getName());

         $invoiceProduct->setQuantity(1);

         $invoiceProduct->setOptTotalPriceBrutto($delivery_cost_brutto);

         $invoiceProduct->setPkwiu("");

         $invoiceProduct->setMeasureUnit($pcs);

         $invoiceProduct->setPriceNetto($delivery_cost_netto);

         $invoiceProduct->setPriceBrutto($delivery_cost_brutto);

         $invoiceProduct->setTotalPriceNetto($delivery_cost_netto);

         $invoiceProduct->setVatAmmount($delivery_cost_brutto - $delivery_cost_netto);

         $invoiceProduct->setVat($delivery->getOptTax());

         $invoiceProduct->setVatId($delivery->getTaxId());

         $invoiceProduct->save();
      }

      $invoice->save();
   }

   public static function getInvoiceNumber($type)
   {
      $context = sfContext::getInstance();

      $invoiceDefault = stConfig::getInstance($context, 'stInvoiceBackend');
      $invoice = $invoiceDefault->load();

      if ($type == "proforma")
      {

         return $invoice['number_proforma'];
      }

      if ($type == "confirm")
      {
         return $invoice['number_confirm'];
      }
   }

   public static function incarseInvoiceNumber($type)
   {
      $context = sfContext::getInstance();

      $invoiceDefault = stConfig::getInstance($context, 'stInvoiceBackend');
      $invoice = $invoiceDefault->load();

      if ($type == "proforma")
      {
         $invoiceDefault->set('number_proforma', $invoice['number_proforma'] + 1);
      }

      if ($type == "confirm")
      {
         $invoiceDefault->set('number_confirm', $invoice['number_confirm'] + 1);
      }

      $invoiceDefault->save();
   }

   public static function createInvoiceNumber($type, $inc=0)
   {
      $context = sfContext::getInstance();

      $invoiceDefault = stConfig::getInstance($context, 'stInvoiceBackend');
      $invoice = $invoiceDefault->load();

      $number = "";

      if ($type == "proforma")
      {
         if ($invoice['number_proforma_format_prefix'] != "")
         {
            $number.= $invoice['number_proforma_format_prefix'];
            $number.= $invoice['number_proforma_format_separator'];
         }

         if ($invoice['number_proforma_format'] == 1)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
            $number.= $invoice['number_proforma_format_separator'];
            $number.= date('m');
            $number.= $invoice['number_proforma_format_separator'];
            $number.= date('Y');
         }

         if ($invoice['number_proforma_format'] == 2)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
            $number.= $invoice['number_proforma_format_separator'];
            $number.= date('Y');
         }

         if ($invoice['number_proforma_format'] == 3)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
         }

         if ($invoice['number_proforma_format_sufix'] != "")
         {
            $number.= $invoice['number_proforma_format_separator'];
            $number.= $invoice['number_proforma_format_sufix'];
         }
      }

      if ($type == "confirm")
      {

         if ($invoice['number_format_prefix'] != "")
         {
            $number.= $invoice['number_format_prefix'];
            $number.= $invoice['number_format_separator'];
         }

         if ($invoice['number_format'] == 1)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
            $number.= $invoice['number_format_separator'];
            $number.= date('m');
            $number.= $invoice['number_format_separator'];
            $number.= date('Y');
         }

         if ($invoice['number_format'] == 2)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
            $number.= $invoice['number_format_separator'];
            $number.= date('Y');
         }

         if ($invoice['number_format'] == 3)
         {
            $number.= stInvoiceListener::getInvoiceNumber("proforma");
         }


         if ($invoice['number_format_sufix'] != "")
         {
            $number.= $invoice['number_format_separator'];
            $number.= $invoice['number_format_sufix'];
         }
      }


      if ($inc == 1)
      {
         stInvoiceListener::incarseInvoiceNumber($type);
      }

      return $number;
   }

}

?>
