<?php

/**
 * Subclass for representing a row from the 'st_invoice_user_seller' table.
 *
 *
 *
 * @package plugins.stInvoicePlugin.lib.model
 */
class InvoiceUserSeller extends BaseInvoiceUserSeller
{
   public function getFullName()
   {
      $fullname = parent::getFullName();

      if (null === $fullname)
      {
         if($this->getName()!="" || $this->getSurname()!="")
         {
            $fullname = $this->getName().' '.$this->getSurname();
         }
      }

      return $fullname;
   }

   public function getAddress()
   {
      $address = parent::getAddress();

      if (null === $address)
      {
         if($this->getStreet()!="" || $this->getHouse()!="" || $this->getFlat()!="")
         {
            $old_address = $this->getStreet().' '.$this->getHouse();

            if($this->getFlat()!="")
            {

               $old_address.= '/'.$this->getFlat();
            }

            $address = $old_address;
         }
      }

      return $address;
   }

   public function getName()
   {
      $name = parent::getName();
      if (empty($name))
      {
         $fullname_array = explode(' ', parent::getFullName());
         $name = $fullname_array[0];
      }

      return $name;
   }

   public function getSurname()
   {
      $surname = parent::getSurname();
      if (empty($surname))
      {
         $fullname_array = explode(' ', parent::getFullName());

         foreach ($fullname_array as $key => $array)
         {
            if($key!=0)
            {
               $surname.= $array;
               $surname.= " ";
            }
         }
      $surname = substr($surname,0,strlen($surname)-1);
      }

      return $surname;
   }

      public function getStreet()
      {
         $street = parent::getStreet();
         if (empty($street))
         {
            $aparser = new stAddressParser(parent::getAddress());
            $result  = $aparser->getAddress();
            $street = $result['s1'];
         }

         return $street;
      }

      public function getHouse()
      {
         $house = parent::getHouse();
         if (empty($house))
         {
            $aparser = new stAddressParser(parent::getAddress());
            $result  = $aparser->getAddress();
            $house = $result['n1'];
         }

         return $house;
      }

      public function getFlat()
      {
         $flat = parent::getFlat();
         if (empty($flat))
         {
            $aparser = new stAddressParser(parent::getAddress());
            $result  = $aparser->getAddress();
            $flat = $result['n2'];
         }

         return $flat;
      }
}
