<?php



class InvoiceProductMapBuilder {

	
	const CLASS_NAME = 'plugins.stInvoicePlugin.lib.model.map.InvoiceProductMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_invoice_product');
		$tMap->setPhpName('InvoiceProduct');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('INVOICE_ID', 'InvoiceId', 'int', CreoleTypes::INTEGER, 'st_invoice', 'ID', true, null);

		$tMap->addForeignKey('PRODUCT_ID', 'ProductId', 'int', CreoleTypes::INTEGER, 'st_product', 'ID', false, null);

		$tMap->addColumn('NAME', 'Name', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('PKWIU', 'Pkwiu', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('QUANTITY', 'Quantity', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('MEASURE_UNIT', 'MeasureUnit', 'string', CreoleTypes::VARCHAR, false, 20);

		$tMap->addColumn('DISCOUNT', 'Discount', 'double', CreoleTypes::FLOAT, false, null);

		$tMap->addColumn('PRICE_NETTO', 'PriceNetto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('PRICE_BRUTTO', 'PriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('VAT', 'Vat', 'double', CreoleTypes::FLOAT, false, null);

		$tMap->addColumn('VAT_ID', 'VatId', 'int', CreoleTypes::INTEGER, false, null);

		$tMap->addColumn('TOTAL_PRICE_NETTO', 'TotalPriceNetto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('VAT_AMMOUNT', 'VatAmmount', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('OPT_TOTAL_PRICE_BRUTTO', 'OptTotalPriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

	} 
} 