<?php


abstract class BaseInvoice extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $invoice_user_seller_id;


	
	protected $invoice_user_customer_id;


	
	protected $order_id;


	
	protected $invoice_currency_id;


	
	protected $invoice_proforma_id;


	
	protected $company_description;


	
	protected $date_selle;


	
	protected $date_create_copy;


	
	protected $number;


	
	protected $signature_seller;


	
	protected $signature_customer;


	
	protected $opt_total_ammount_brutto;


	
	protected $town;


	
	protected $curency;


	
	protected $max_day = 'none';


	
	protected $payment_type = 'none';


	
	protected $is_proforma = true;


	
	protected $is_request = false;


	
	protected $is_confirm = false;

	
	protected $aInvoiceUserSeller;

	
	protected $aInvoiceUserCustomer;

	
	protected $aOrder;

	
	protected $aInvoiceCurrency;

	
	protected $collInvoiceStatuss;

	
	protected $lastInvoiceStatusCriteria = null;

	
	protected $collInvoiceProducts;

	
	protected $lastInvoiceProductCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getInvoiceUserSellerId()
    {

            return $this->invoice_user_seller_id;
    }

    
    public function getInvoiceUserCustomerId()
    {

            return $this->invoice_user_customer_id;
    }

    
    public function getOrderId()
    {

            return $this->order_id;
    }

    
    public function getInvoiceCurrencyId()
    {

            return $this->invoice_currency_id;
    }

    
    public function getInvoiceProformaId()
    {

            return $this->invoice_proforma_id;
    }

    
    public function getCompanyDescription()
    {

            return $this->company_description;
    }

	
	public function getDateSelle($format = 'Y-m-d')
	{

		if ($this->date_selle === null || $this->date_selle === '') {
			return null;
		} elseif (!is_int($this->date_selle)) {
						$ts = strtotime($this->date_selle);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [date_selle] as date/time value: " . var_export($this->date_selle, true));
			}
		} else {
			$ts = $this->date_selle;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getDateCreateCopy($format = 'Y-m-d')
	{

		if ($this->date_create_copy === null || $this->date_create_copy === '') {
			return null;
		} elseif (!is_int($this->date_create_copy)) {
						$ts = strtotime($this->date_create_copy);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [date_create_copy] as date/time value: " . var_export($this->date_create_copy, true));
			}
		} else {
			$ts = $this->date_create_copy;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getNumber()
    {

            return $this->number;
    }

    
    public function getSignatureSeller()
    {

            return $this->signature_seller;
    }

    
    public function getSignatureCustomer()
    {

            return $this->signature_customer;
    }

    
    public function getOptTotalAmmountBrutto()
    {

            return null !== $this->opt_total_ammount_brutto ? (string)$this->opt_total_ammount_brutto : null;
    }

    
    public function getTown()
    {

            return $this->town;
    }

    
    public function getCurency()
    {

            return $this->curency;
    }

    
    public function getMaxDay()
    {

            return $this->max_day;
    }

    
    public function getPaymentType()
    {

            return $this->payment_type;
    }

    
    public function getIsProforma()
    {

            return $this->is_proforma;
    }

    
    public function getIsRequest()
    {

            return $this->is_request;
    }

    
    public function getIsConfirm()
    {

            return $this->is_confirm;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = InvoicePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = InvoicePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = InvoicePeer::ID;
        }

	} 
	
	public function setInvoiceUserSellerId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_user_seller_id !== $v) {
          $this->invoice_user_seller_id = $v;
          $this->modifiedColumns[] = InvoicePeer::INVOICE_USER_SELLER_ID;
        }

		if ($this->aInvoiceUserSeller !== null && $this->aInvoiceUserSeller->getId() !== $v) {
			$this->aInvoiceUserSeller = null;
		}

	} 
	
	public function setInvoiceUserCustomerId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_user_customer_id !== $v) {
          $this->invoice_user_customer_id = $v;
          $this->modifiedColumns[] = InvoicePeer::INVOICE_USER_CUSTOMER_ID;
        }

		if ($this->aInvoiceUserCustomer !== null && $this->aInvoiceUserCustomer->getId() !== $v) {
			$this->aInvoiceUserCustomer = null;
		}

	} 
	
	public function setOrderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_id !== $v) {
          $this->order_id = $v;
          $this->modifiedColumns[] = InvoicePeer::ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setInvoiceCurrencyId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_currency_id !== $v) {
          $this->invoice_currency_id = $v;
          $this->modifiedColumns[] = InvoicePeer::INVOICE_CURRENCY_ID;
        }

		if ($this->aInvoiceCurrency !== null && $this->aInvoiceCurrency->getId() !== $v) {
			$this->aInvoiceCurrency = null;
		}

	} 
	
	public function setInvoiceProformaId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_proforma_id !== $v) {
          $this->invoice_proforma_id = $v;
          $this->modifiedColumns[] = InvoicePeer::INVOICE_PROFORMA_ID;
        }

	} 
	
	public function setCompanyDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->company_description !== $v) {
          $this->company_description = $v;
          $this->modifiedColumns[] = InvoicePeer::COMPANY_DESCRIPTION;
        }

	} 
	
	public function setDateSelle($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [date_selle] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->date_selle !== $ts) {
			$this->date_selle = $ts;
			$this->modifiedColumns[] = InvoicePeer::DATE_SELLE;
		}

	} 
	
	public function setDateCreateCopy($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [date_create_copy] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->date_create_copy !== $ts) {
			$this->date_create_copy = $ts;
			$this->modifiedColumns[] = InvoicePeer::DATE_CREATE_COPY;
		}

	} 
	
	public function setNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->number !== $v) {
          $this->number = $v;
          $this->modifiedColumns[] = InvoicePeer::NUMBER;
        }

	} 
	
	public function setSignatureSeller($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->signature_seller !== $v) {
          $this->signature_seller = $v;
          $this->modifiedColumns[] = InvoicePeer::SIGNATURE_SELLER;
        }

	} 
	
	public function setSignatureCustomer($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->signature_customer !== $v) {
          $this->signature_customer = $v;
          $this->modifiedColumns[] = InvoicePeer::SIGNATURE_CUSTOMER;
        }

	} 
	
	public function setOptTotalAmmountBrutto($v)
	{

        if ($this->opt_total_ammount_brutto !== $v) {
          $this->opt_total_ammount_brutto = $v;
          $this->modifiedColumns[] = InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO;
        }

	} 
	
	public function setTown($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->town !== $v) {
          $this->town = $v;
          $this->modifiedColumns[] = InvoicePeer::TOWN;
        }

	} 
	
	public function setCurency($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->curency !== $v) {
          $this->curency = $v;
          $this->modifiedColumns[] = InvoicePeer::CURENCY;
        }

	} 
	
	public function setMaxDay($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->max_day !== $v || $v === 'none') {
          $this->max_day = $v;
          $this->modifiedColumns[] = InvoicePeer::MAX_DAY;
        }

	} 
	
	public function setPaymentType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->payment_type !== $v || $v === 'none') {
          $this->payment_type = $v;
          $this->modifiedColumns[] = InvoicePeer::PAYMENT_TYPE;
        }

	} 
	
	public function setIsProforma($v)
	{

        if ($this->is_proforma !== $v || $v === true) {
          $this->is_proforma = $v;
          $this->modifiedColumns[] = InvoicePeer::IS_PROFORMA;
        }

	} 
	
	public function setIsRequest($v)
	{

        if ($this->is_request !== $v || $v === false) {
          $this->is_request = $v;
          $this->modifiedColumns[] = InvoicePeer::IS_REQUEST;
        }

	} 
	
	public function setIsConfirm($v)
	{

        if ($this->is_confirm !== $v || $v === false) {
          $this->is_confirm = $v;
          $this->modifiedColumns[] = InvoicePeer::IS_CONFIRM;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Invoice.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->invoice_user_seller_id = $rs->getInt($startcol + 3);

      $this->invoice_user_customer_id = $rs->getInt($startcol + 4);

      $this->order_id = $rs->getInt($startcol + 5);

      $this->invoice_currency_id = $rs->getInt($startcol + 6);

      $this->invoice_proforma_id = $rs->getInt($startcol + 7);

      $this->company_description = $rs->getString($startcol + 8);

      $this->date_selle = $rs->getDate($startcol + 9, null);

      $this->date_create_copy = $rs->getDate($startcol + 10, null);

      $this->number = $rs->getString($startcol + 11);

      $this->signature_seller = $rs->getString($startcol + 12);

      $this->signature_customer = $rs->getString($startcol + 13);

      $this->opt_total_ammount_brutto = $rs->getString($startcol + 14, null);

      $this->opt_total_ammount_brutto = $rs->getFloat($startcol + 14);

      $this->town = $rs->getString($startcol + 15);

      $this->curency = $rs->getString($startcol + 16);

      $this->max_day = $rs->getString($startcol + 17);

      $this->payment_type = $rs->getString($startcol + 18);

      $this->is_proforma = $rs->getBoolean($startcol + 19);

      $this->is_request = $rs->getBoolean($startcol + 20);

      $this->is_confirm = $rs->getBoolean($startcol + 21);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Invoice.postHydrate', array('resultset' => $rs, 'startcol' => 22)));

            return $startcol + 22; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Invoice object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoice:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoicePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			InvoicePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseInvoice:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Invoice.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseInvoice:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(InvoicePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(InvoicePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoicePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Invoice.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseInvoice:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aInvoiceUserSeller !== null) {
				if ($this->aInvoiceUserSeller->isModified()) {
					$affectedRows += $this->aInvoiceUserSeller->save($con);
				}
				$this->setInvoiceUserSeller($this->aInvoiceUserSeller);
			}

			if ($this->aInvoiceUserCustomer !== null) {
				if ($this->aInvoiceUserCustomer->isModified()) {
					$affectedRows += $this->aInvoiceUserCustomer->save($con);
				}
				$this->setInvoiceUserCustomer($this->aInvoiceUserCustomer);
			}

			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}

			if ($this->aInvoiceCurrency !== null) {
				if ($this->aInvoiceCurrency->isModified()) {
					$affectedRows += $this->aInvoiceCurrency->save($con);
				}
				$this->setInvoiceCurrency($this->aInvoiceCurrency);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = InvoicePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += InvoicePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collInvoiceStatuss !== null) {
				foreach($this->collInvoiceStatuss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collInvoiceProducts !== null) {
				foreach($this->collInvoiceProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aInvoiceUserSeller !== null) {
				if (!$this->aInvoiceUserSeller->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aInvoiceUserSeller->getValidationFailures());
				}
			}

			if ($this->aInvoiceUserCustomer !== null) {
				if (!$this->aInvoiceUserCustomer->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aInvoiceUserCustomer->getValidationFailures());
				}
			}

			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}

			if ($this->aInvoiceCurrency !== null) {
				if (!$this->aInvoiceCurrency->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aInvoiceCurrency->getValidationFailures());
				}
			}


			if (($retval = InvoicePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collInvoiceStatuss !== null) {
					foreach($this->collInvoiceStatuss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collInvoiceProducts !== null) {
					foreach($this->collInvoiceProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoicePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getInvoiceUserSellerId();
				break;
			case 4:
				return $this->getInvoiceUserCustomerId();
				break;
			case 5:
				return $this->getOrderId();
				break;
			case 6:
				return $this->getInvoiceCurrencyId();
				break;
			case 7:
				return $this->getInvoiceProformaId();
				break;
			case 8:
				return $this->getCompanyDescription();
				break;
			case 9:
				return $this->getDateSelle();
				break;
			case 10:
				return $this->getDateCreateCopy();
				break;
			case 11:
				return $this->getNumber();
				break;
			case 12:
				return $this->getSignatureSeller();
				break;
			case 13:
				return $this->getSignatureCustomer();
				break;
			case 14:
				return $this->getOptTotalAmmountBrutto();
				break;
			case 15:
				return $this->getTown();
				break;
			case 16:
				return $this->getCurency();
				break;
			case 17:
				return $this->getMaxDay();
				break;
			case 18:
				return $this->getPaymentType();
				break;
			case 19:
				return $this->getIsProforma();
				break;
			case 20:
				return $this->getIsRequest();
				break;
			case 21:
				return $this->getIsConfirm();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoicePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getInvoiceUserSellerId(),
			$keys[4] => $this->getInvoiceUserCustomerId(),
			$keys[5] => $this->getOrderId(),
			$keys[6] => $this->getInvoiceCurrencyId(),
			$keys[7] => $this->getInvoiceProformaId(),
			$keys[8] => $this->getCompanyDescription(),
			$keys[9] => $this->getDateSelle(),
			$keys[10] => $this->getDateCreateCopy(),
			$keys[11] => $this->getNumber(),
			$keys[12] => $this->getSignatureSeller(),
			$keys[13] => $this->getSignatureCustomer(),
			$keys[14] => $this->getOptTotalAmmountBrutto(),
			$keys[15] => $this->getTown(),
			$keys[16] => $this->getCurency(),
			$keys[17] => $this->getMaxDay(),
			$keys[18] => $this->getPaymentType(),
			$keys[19] => $this->getIsProforma(),
			$keys[20] => $this->getIsRequest(),
			$keys[21] => $this->getIsConfirm(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoicePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setInvoiceUserSellerId($value);
				break;
			case 4:
				$this->setInvoiceUserCustomerId($value);
				break;
			case 5:
				$this->setOrderId($value);
				break;
			case 6:
				$this->setInvoiceCurrencyId($value);
				break;
			case 7:
				$this->setInvoiceProformaId($value);
				break;
			case 8:
				$this->setCompanyDescription($value);
				break;
			case 9:
				$this->setDateSelle($value);
				break;
			case 10:
				$this->setDateCreateCopy($value);
				break;
			case 11:
				$this->setNumber($value);
				break;
			case 12:
				$this->setSignatureSeller($value);
				break;
			case 13:
				$this->setSignatureCustomer($value);
				break;
			case 14:
				$this->setOptTotalAmmountBrutto($value);
				break;
			case 15:
				$this->setTown($value);
				break;
			case 16:
				$this->setCurency($value);
				break;
			case 17:
				$this->setMaxDay($value);
				break;
			case 18:
				$this->setPaymentType($value);
				break;
			case 19:
				$this->setIsProforma($value);
				break;
			case 20:
				$this->setIsRequest($value);
				break;
			case 21:
				$this->setIsConfirm($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoicePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setInvoiceUserSellerId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setInvoiceUserCustomerId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOrderId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setInvoiceCurrencyId($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setInvoiceProformaId($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setCompanyDescription($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setDateSelle($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setDateCreateCopy($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setNumber($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setSignatureSeller($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setSignatureCustomer($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setOptTotalAmmountBrutto($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setTown($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setCurency($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setMaxDay($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setPaymentType($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setIsProforma($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setIsRequest($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setIsConfirm($arr[$keys[21]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(InvoicePeer::DATABASE_NAME);

		if ($this->isColumnModified(InvoicePeer::CREATED_AT)) $criteria->add(InvoicePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(InvoicePeer::UPDATED_AT)) $criteria->add(InvoicePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(InvoicePeer::ID)) $criteria->add(InvoicePeer::ID, $this->id);
		if ($this->isColumnModified(InvoicePeer::INVOICE_USER_SELLER_ID)) $criteria->add(InvoicePeer::INVOICE_USER_SELLER_ID, $this->invoice_user_seller_id);
		if ($this->isColumnModified(InvoicePeer::INVOICE_USER_CUSTOMER_ID)) $criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->invoice_user_customer_id);
		if ($this->isColumnModified(InvoicePeer::ORDER_ID)) $criteria->add(InvoicePeer::ORDER_ID, $this->order_id);
		if ($this->isColumnModified(InvoicePeer::INVOICE_CURRENCY_ID)) $criteria->add(InvoicePeer::INVOICE_CURRENCY_ID, $this->invoice_currency_id);
		if ($this->isColumnModified(InvoicePeer::INVOICE_PROFORMA_ID)) $criteria->add(InvoicePeer::INVOICE_PROFORMA_ID, $this->invoice_proforma_id);
		if ($this->isColumnModified(InvoicePeer::COMPANY_DESCRIPTION)) $criteria->add(InvoicePeer::COMPANY_DESCRIPTION, $this->company_description);
		if ($this->isColumnModified(InvoicePeer::DATE_SELLE)) $criteria->add(InvoicePeer::DATE_SELLE, $this->date_selle);
		if ($this->isColumnModified(InvoicePeer::DATE_CREATE_COPY)) $criteria->add(InvoicePeer::DATE_CREATE_COPY, $this->date_create_copy);
		if ($this->isColumnModified(InvoicePeer::NUMBER)) $criteria->add(InvoicePeer::NUMBER, $this->number);
		if ($this->isColumnModified(InvoicePeer::SIGNATURE_SELLER)) $criteria->add(InvoicePeer::SIGNATURE_SELLER, $this->signature_seller);
		if ($this->isColumnModified(InvoicePeer::SIGNATURE_CUSTOMER)) $criteria->add(InvoicePeer::SIGNATURE_CUSTOMER, $this->signature_customer);
		if ($this->isColumnModified(InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO)) $criteria->add(InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO, $this->opt_total_ammount_brutto);
		if ($this->isColumnModified(InvoicePeer::TOWN)) $criteria->add(InvoicePeer::TOWN, $this->town);
		if ($this->isColumnModified(InvoicePeer::CURENCY)) $criteria->add(InvoicePeer::CURENCY, $this->curency);
		if ($this->isColumnModified(InvoicePeer::MAX_DAY)) $criteria->add(InvoicePeer::MAX_DAY, $this->max_day);
		if ($this->isColumnModified(InvoicePeer::PAYMENT_TYPE)) $criteria->add(InvoicePeer::PAYMENT_TYPE, $this->payment_type);
		if ($this->isColumnModified(InvoicePeer::IS_PROFORMA)) $criteria->add(InvoicePeer::IS_PROFORMA, $this->is_proforma);
		if ($this->isColumnModified(InvoicePeer::IS_REQUEST)) $criteria->add(InvoicePeer::IS_REQUEST, $this->is_request);
		if ($this->isColumnModified(InvoicePeer::IS_CONFIRM)) $criteria->add(InvoicePeer::IS_CONFIRM, $this->is_confirm);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(InvoicePeer::DATABASE_NAME);

		$criteria->add(InvoicePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setInvoiceUserSellerId($this->invoice_user_seller_id);

		$copyObj->setInvoiceUserCustomerId($this->invoice_user_customer_id);

		$copyObj->setOrderId($this->order_id);

		$copyObj->setInvoiceCurrencyId($this->invoice_currency_id);

		$copyObj->setInvoiceProformaId($this->invoice_proforma_id);

		$copyObj->setCompanyDescription($this->company_description);

		$copyObj->setDateSelle($this->date_selle);

		$copyObj->setDateCreateCopy($this->date_create_copy);

		$copyObj->setNumber($this->number);

		$copyObj->setSignatureSeller($this->signature_seller);

		$copyObj->setSignatureCustomer($this->signature_customer);

		$copyObj->setOptTotalAmmountBrutto($this->opt_total_ammount_brutto);

		$copyObj->setTown($this->town);

		$copyObj->setCurency($this->curency);

		$copyObj->setMaxDay($this->max_day);

		$copyObj->setPaymentType($this->payment_type);

		$copyObj->setIsProforma($this->is_proforma);

		$copyObj->setIsRequest($this->is_request);

		$copyObj->setIsConfirm($this->is_confirm);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getInvoiceStatuss() as $relObj) {
				$copyObj->addInvoiceStatus($relObj->copy($deepCopy));
			}

			foreach($this->getInvoiceProducts() as $relObj) {
				$copyObj->addInvoiceProduct($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new InvoicePeer();
		}
		return self::$peer;
	}

	
	public function setInvoiceUserSeller($v)
	{


		if ($v === null) {
			$this->setInvoiceUserSellerId(NULL);
		} else {
			$this->setInvoiceUserSellerId($v->getId());
		}


		$this->aInvoiceUserSeller = $v;
	}


	
	public function getInvoiceUserSeller($con = null)
	{
		if ($this->aInvoiceUserSeller === null && ($this->invoice_user_seller_id !== null)) {
						$this->aInvoiceUserSeller = InvoiceUserSellerPeer::retrieveByPK($this->invoice_user_seller_id, $con);

			
		}
		return $this->aInvoiceUserSeller;
	}

	
	public function setInvoiceUserCustomer($v)
	{


		if ($v === null) {
			$this->setInvoiceUserCustomerId(NULL);
		} else {
			$this->setInvoiceUserCustomerId($v->getId());
		}


		$this->aInvoiceUserCustomer = $v;
	}


	
	public function getInvoiceUserCustomer($con = null)
	{
		if ($this->aInvoiceUserCustomer === null && ($this->invoice_user_customer_id !== null)) {
						$this->aInvoiceUserCustomer = InvoiceUserCustomerPeer::retrieveByPK($this->invoice_user_customer_id, $con);

			
		}
		return $this->aInvoiceUserCustomer;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setOrderId(NULL);
		} else {
			$this->setOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->order_id, $con);

			
		}
		return $this->aOrder;
	}

	
	public function setInvoiceCurrency($v)
	{


		if ($v === null) {
			$this->setInvoiceCurrencyId(NULL);
		} else {
			$this->setInvoiceCurrencyId($v->getId());
		}


		$this->aInvoiceCurrency = $v;
	}


	
	public function getInvoiceCurrency($con = null)
	{
		if ($this->aInvoiceCurrency === null && ($this->invoice_currency_id !== null)) {
						$this->aInvoiceCurrency = InvoiceCurrencyPeer::retrieveByPK($this->invoice_currency_id, $con);

			
		}
		return $this->aInvoiceCurrency;
	}

	
	public function initInvoiceStatuss()
	{
		if ($this->collInvoiceStatuss === null) {
			$this->collInvoiceStatuss = array();
		}
	}

	
	public function getInvoiceStatuss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoiceStatuss === null) {
			if ($this->isNew()) {
			   $this->collInvoiceStatuss = array();
			} else {

				$criteria->add(InvoiceStatusPeer::INVOICE_ID, $this->getId());

				InvoiceStatusPeer::addSelectColumns($criteria);
				$this->collInvoiceStatuss = InvoiceStatusPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(InvoiceStatusPeer::INVOICE_ID, $this->getId());

				InvoiceStatusPeer::addSelectColumns($criteria);
				if (!isset($this->lastInvoiceStatusCriteria) || !$this->lastInvoiceStatusCriteria->equals($criteria)) {
					$this->collInvoiceStatuss = InvoiceStatusPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastInvoiceStatusCriteria = $criteria;
		return $this->collInvoiceStatuss;
	}

	
	public function countInvoiceStatuss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(InvoiceStatusPeer::INVOICE_ID, $this->getId());

		return InvoiceStatusPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addInvoiceStatus(InvoiceStatus $l)
	{
		$this->collInvoiceStatuss[] = $l;
		$l->setInvoice($this);
	}

	
	public function initInvoiceProducts()
	{
		if ($this->collInvoiceProducts === null) {
			$this->collInvoiceProducts = array();
		}
	}

	
	public function getInvoiceProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoiceProducts === null) {
			if ($this->isNew()) {
			   $this->collInvoiceProducts = array();
			} else {

				$criteria->add(InvoiceProductPeer::INVOICE_ID, $this->getId());

				InvoiceProductPeer::addSelectColumns($criteria);
				$this->collInvoiceProducts = InvoiceProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(InvoiceProductPeer::INVOICE_ID, $this->getId());

				InvoiceProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastInvoiceProductCriteria) || !$this->lastInvoiceProductCriteria->equals($criteria)) {
					$this->collInvoiceProducts = InvoiceProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastInvoiceProductCriteria = $criteria;
		return $this->collInvoiceProducts;
	}

	
	public function countInvoiceProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(InvoiceProductPeer::INVOICE_ID, $this->getId());

		return InvoiceProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addInvoiceProduct(InvoiceProduct $l)
	{
		$this->collInvoiceProducts[] = $l;
		$l->setInvoice($this);
	}


	
	public function getInvoiceProductsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoiceProducts === null) {
			if ($this->isNew()) {
				$this->collInvoiceProducts = array();
			} else {

				$criteria->add(InvoiceProductPeer::INVOICE_ID, $this->getId());

				$this->collInvoiceProducts = InvoiceProductPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoiceProductPeer::INVOICE_ID, $this->getId());

			if (!isset($this->lastInvoiceProductCriteria) || !$this->lastInvoiceProductCriteria->equals($criteria)) {
				$this->collInvoiceProducts = InvoiceProductPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastInvoiceProductCriteria = $criteria;

		return $this->collInvoiceProducts;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Invoice.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseInvoice:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseInvoice::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 