<?php


abstract class BaseInvoicePeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_invoice';

	
	const CLASS_DEFAULT = 'plugins.stInvoicePlugin.lib.model.Invoice';

	
	const NUM_COLUMNS = 22;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_invoice.CREATED_AT';

	
	const UPDATED_AT = 'st_invoice.UPDATED_AT';

	
	const ID = 'st_invoice.ID';

	
	const INVOICE_USER_SELLER_ID = 'st_invoice.INVOICE_USER_SELLER_ID';

	
	const INVOICE_USER_CUSTOMER_ID = 'st_invoice.INVOICE_USER_CUSTOMER_ID';

	
	const ORDER_ID = 'st_invoice.ORDER_ID';

	
	const INVOICE_CURRENCY_ID = 'st_invoice.INVOICE_CURRENCY_ID';

	
	const INVOICE_PROFORMA_ID = 'st_invoice.INVOICE_PROFORMA_ID';

	
	const COMPANY_DESCRIPTION = 'st_invoice.COMPANY_DESCRIPTION';

	
	const DATE_SELLE = 'st_invoice.DATE_SELLE';

	
	const DATE_CREATE_COPY = 'st_invoice.DATE_CREATE_COPY';

	
	const NUMBER = 'st_invoice.NUMBER';

	
	const SIGNATURE_SELLER = 'st_invoice.SIGNATURE_SELLER';

	
	const SIGNATURE_CUSTOMER = 'st_invoice.SIGNATURE_CUSTOMER';

	
	const OPT_TOTAL_AMMOUNT_BRUTTO = 'st_invoice.OPT_TOTAL_AMMOUNT_BRUTTO';

	
	const TOWN = 'st_invoice.TOWN';

	
	const CURENCY = 'st_invoice.CURENCY';

	
	const MAX_DAY = 'st_invoice.MAX_DAY';

	
	const PAYMENT_TYPE = 'st_invoice.PAYMENT_TYPE';

	
	const IS_PROFORMA = 'st_invoice.IS_PROFORMA';

	
	const IS_REQUEST = 'st_invoice.IS_REQUEST';

	
	const IS_CONFIRM = 'st_invoice.IS_CONFIRM';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'InvoiceUserSellerId', 'InvoiceUserCustomerId', 'OrderId', 'InvoiceCurrencyId', 'InvoiceProformaId', 'CompanyDescription', 'DateSelle', 'DateCreateCopy', 'Number', 'SignatureSeller', 'SignatureCustomer', 'OptTotalAmmountBrutto', 'Town', 'Curency', 'MaxDay', 'PaymentType', 'IsProforma', 'IsRequest', 'IsConfirm', ),
		BasePeer::TYPE_COLNAME => array (InvoicePeer::CREATED_AT, InvoicePeer::UPDATED_AT, InvoicePeer::ID, InvoicePeer::INVOICE_USER_SELLER_ID, InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoicePeer::ORDER_ID, InvoicePeer::INVOICE_CURRENCY_ID, InvoicePeer::INVOICE_PROFORMA_ID, InvoicePeer::COMPANY_DESCRIPTION, InvoicePeer::DATE_SELLE, InvoicePeer::DATE_CREATE_COPY, InvoicePeer::NUMBER, InvoicePeer::SIGNATURE_SELLER, InvoicePeer::SIGNATURE_CUSTOMER, InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO, InvoicePeer::TOWN, InvoicePeer::CURENCY, InvoicePeer::MAX_DAY, InvoicePeer::PAYMENT_TYPE, InvoicePeer::IS_PROFORMA, InvoicePeer::IS_REQUEST, InvoicePeer::IS_CONFIRM, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'invoice_user_seller_id', 'invoice_user_customer_id', 'order_id', 'invoice_currency_id', 'invoice_proforma_id', 'company_description', 'date_selle', 'date_create_copy', 'number', 'signature_seller', 'signature_customer', 'opt_total_ammount_brutto', 'town', 'curency', 'max_day', 'payment_type', 'is_proforma', 'is_request', 'is_confirm', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'InvoiceUserSellerId' => 3, 'InvoiceUserCustomerId' => 4, 'OrderId' => 5, 'InvoiceCurrencyId' => 6, 'InvoiceProformaId' => 7, 'CompanyDescription' => 8, 'DateSelle' => 9, 'DateCreateCopy' => 10, 'Number' => 11, 'SignatureSeller' => 12, 'SignatureCustomer' => 13, 'OptTotalAmmountBrutto' => 14, 'Town' => 15, 'Curency' => 16, 'MaxDay' => 17, 'PaymentType' => 18, 'IsProforma' => 19, 'IsRequest' => 20, 'IsConfirm' => 21, ),
		BasePeer::TYPE_COLNAME => array (InvoicePeer::CREATED_AT => 0, InvoicePeer::UPDATED_AT => 1, InvoicePeer::ID => 2, InvoicePeer::INVOICE_USER_SELLER_ID => 3, InvoicePeer::INVOICE_USER_CUSTOMER_ID => 4, InvoicePeer::ORDER_ID => 5, InvoicePeer::INVOICE_CURRENCY_ID => 6, InvoicePeer::INVOICE_PROFORMA_ID => 7, InvoicePeer::COMPANY_DESCRIPTION => 8, InvoicePeer::DATE_SELLE => 9, InvoicePeer::DATE_CREATE_COPY => 10, InvoicePeer::NUMBER => 11, InvoicePeer::SIGNATURE_SELLER => 12, InvoicePeer::SIGNATURE_CUSTOMER => 13, InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO => 14, InvoicePeer::TOWN => 15, InvoicePeer::CURENCY => 16, InvoicePeer::MAX_DAY => 17, InvoicePeer::PAYMENT_TYPE => 18, InvoicePeer::IS_PROFORMA => 19, InvoicePeer::IS_REQUEST => 20, InvoicePeer::IS_CONFIRM => 21, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'invoice_user_seller_id' => 3, 'invoice_user_customer_id' => 4, 'order_id' => 5, 'invoice_currency_id' => 6, 'invoice_proforma_id' => 7, 'company_description' => 8, 'date_selle' => 9, 'date_create_copy' => 10, 'number' => 11, 'signature_seller' => 12, 'signature_customer' => 13, 'opt_total_ammount_brutto' => 14, 'town' => 15, 'curency' => 16, 'max_day' => 17, 'payment_type' => 18, 'is_proforma' => 19, 'is_request' => 20, 'is_confirm' => 21, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stInvoicePlugin.lib.model.map.InvoiceMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = InvoicePeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(InvoicePeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(InvoicePeer::CREATED_AT);

		$criteria->addSelectColumn(InvoicePeer::UPDATED_AT);

		$criteria->addSelectColumn(InvoicePeer::ID);

		$criteria->addSelectColumn(InvoicePeer::INVOICE_USER_SELLER_ID);

		$criteria->addSelectColumn(InvoicePeer::INVOICE_USER_CUSTOMER_ID);

		$criteria->addSelectColumn(InvoicePeer::ORDER_ID);

		$criteria->addSelectColumn(InvoicePeer::INVOICE_CURRENCY_ID);

		$criteria->addSelectColumn(InvoicePeer::INVOICE_PROFORMA_ID);

		$criteria->addSelectColumn(InvoicePeer::COMPANY_DESCRIPTION);

		$criteria->addSelectColumn(InvoicePeer::DATE_SELLE);

		$criteria->addSelectColumn(InvoicePeer::DATE_CREATE_COPY);

		$criteria->addSelectColumn(InvoicePeer::NUMBER);

		$criteria->addSelectColumn(InvoicePeer::SIGNATURE_SELLER);

		$criteria->addSelectColumn(InvoicePeer::SIGNATURE_CUSTOMER);

		$criteria->addSelectColumn(InvoicePeer::OPT_TOTAL_AMMOUNT_BRUTTO);

		$criteria->addSelectColumn(InvoicePeer::TOWN);

		$criteria->addSelectColumn(InvoicePeer::CURENCY);

		$criteria->addSelectColumn(InvoicePeer::MAX_DAY);

		$criteria->addSelectColumn(InvoicePeer::PAYMENT_TYPE);

		$criteria->addSelectColumn(InvoicePeer::IS_PROFORMA);

		$criteria->addSelectColumn(InvoicePeer::IS_REQUEST);

		$criteria->addSelectColumn(InvoicePeer::IS_CONFIRM);

	}

	const COUNT = 'COUNT(st_invoice.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_invoice.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = InvoicePeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return InvoicePeer::populateObjects(InvoicePeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoicePeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseInvoicePeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			InvoicePeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = InvoicePeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinInvoiceUserSeller(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinInvoiceUserCustomer(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinOrder(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinInvoiceCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinInvoiceUserSeller(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		InvoiceUserSellerPeer::addSelectColumns($c);

		$c->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getInvoiceUserSellerId())
                        {

			   $omClass = InvoiceUserSellerPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addInvoice($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinInvoiceUserCustomer(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		InvoiceUserCustomerPeer::addSelectColumns($c);

		$c->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getInvoiceUserCustomerId())
                        {

			   $omClass = InvoiceUserCustomerPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addInvoice($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinOrder(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderPeer::addSelectColumns($c);

		$c->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderId())
                        {

			   $omClass = OrderPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addInvoice($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinInvoiceCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		InvoiceCurrencyPeer::addSelectColumns($c);

		$c->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getInvoiceCurrencyId())
                        {

			   $omClass = InvoiceCurrencyPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addInvoice($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$criteria->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$criteria->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol2 = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		InvoiceUserSellerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + InvoiceUserSellerPeer::NUM_COLUMNS;

		InvoiceUserCustomerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + InvoiceUserCustomerPeer::NUM_COLUMNS;

		OrderPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderPeer::NUM_COLUMNS;

		InvoiceCurrencyPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + InvoiceCurrencyPeer::NUM_COLUMNS;

		$c->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$c->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$c->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = InvoiceUserSellerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getInvoiceUserSeller(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addInvoice($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initInvoices();
				$obj2->addInvoice($obj1);
			}


					
			$omClass = InvoiceUserCustomerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getInvoiceUserCustomer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addInvoice($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initInvoices();
				$obj3->addInvoice($obj1);
			}


					
			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrder(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addInvoice($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initInvoices();
				$obj4->addInvoice($obj1);
			}


					
			$omClass = InvoiceCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5 = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getInvoiceCurrency(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addInvoice($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj5->initInvoices();
				$obj5->addInvoice($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptInvoiceUserSeller(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$criteria->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptInvoiceUserCustomer(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$criteria->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptOrder(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$criteria->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$criteria->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptInvoiceCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(InvoicePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(InvoicePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$criteria->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$criteria->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$rs = InvoicePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptInvoiceUserSeller(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol2 = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		InvoiceUserCustomerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + InvoiceUserCustomerPeer::NUM_COLUMNS;

		OrderPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + OrderPeer::NUM_COLUMNS;

		InvoiceCurrencyPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + InvoiceCurrencyPeer::NUM_COLUMNS;

		$c->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$c->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = InvoiceUserCustomerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getInvoiceUserCustomer(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initInvoices();
				$obj2->addInvoice($obj1);
			}

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getOrder(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initInvoices();
				$obj3->addInvoice($obj1);
			}

			$omClass = InvoiceCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getInvoiceCurrency(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initInvoices();
				$obj4->addInvoice($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptInvoiceUserCustomer(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol2 = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		InvoiceUserSellerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + InvoiceUserSellerPeer::NUM_COLUMNS;

		OrderPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + OrderPeer::NUM_COLUMNS;

		InvoiceCurrencyPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + InvoiceCurrencyPeer::NUM_COLUMNS;

		$c->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$c->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = InvoiceUserSellerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getInvoiceUserSeller(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initInvoices();
				$obj2->addInvoice($obj1);
			}

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getOrder(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initInvoices();
				$obj3->addInvoice($obj1);
			}

			$omClass = InvoiceCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getInvoiceCurrency(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initInvoices();
				$obj4->addInvoice($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptOrder(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol2 = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		InvoiceUserSellerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + InvoiceUserSellerPeer::NUM_COLUMNS;

		InvoiceUserCustomerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + InvoiceUserCustomerPeer::NUM_COLUMNS;

		InvoiceCurrencyPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + InvoiceCurrencyPeer::NUM_COLUMNS;

		$c->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$c->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$c->addJoin(InvoicePeer::INVOICE_CURRENCY_ID, InvoiceCurrencyPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = InvoiceUserSellerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getInvoiceUserSeller(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initInvoices();
				$obj2->addInvoice($obj1);
			}

			$omClass = InvoiceUserCustomerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getInvoiceUserCustomer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initInvoices();
				$obj3->addInvoice($obj1);
			}

			$omClass = InvoiceCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getInvoiceCurrency(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initInvoices();
				$obj4->addInvoice($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptInvoiceCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		InvoicePeer::addSelectColumns($c);
		$startcol2 = (InvoicePeer::NUM_COLUMNS - InvoicePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		InvoiceUserSellerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + InvoiceUserSellerPeer::NUM_COLUMNS;

		InvoiceUserCustomerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + InvoiceUserCustomerPeer::NUM_COLUMNS;

		OrderPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderPeer::NUM_COLUMNS;

		$c->addJoin(InvoicePeer::INVOICE_USER_SELLER_ID, InvoiceUserSellerPeer::ID);

		$c->addJoin(InvoicePeer::INVOICE_USER_CUSTOMER_ID, InvoiceUserCustomerPeer::ID);

		$c->addJoin(InvoicePeer::ORDER_ID, OrderPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = InvoicePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = InvoiceUserSellerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getInvoiceUserSeller(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initInvoices();
				$obj2->addInvoice($obj1);
			}

			$omClass = InvoiceUserCustomerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getInvoiceUserCustomer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initInvoices();
				$obj3->addInvoice($obj1);
			}

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrder(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addInvoice($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initInvoices();
				$obj4->addInvoice($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return InvoicePeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoicePeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseInvoicePeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(InvoicePeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseInvoicePeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseInvoicePeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoicePeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseInvoicePeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(InvoicePeer::ID);
			$selectCriteria->add(InvoicePeer::ID, $criteria->remove(InvoicePeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseInvoicePeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseInvoicePeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += InvoicePeer::doOnDeleteCascade(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(InvoicePeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(InvoicePeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Invoice) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(InvoicePeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += InvoicePeer::doOnDeleteCascade($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = InvoicePeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(InvoiceStatusPeer::INVOICE_ID, $obj->getId());
			$affectedRows += InvoiceStatusPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(InvoiceProductPeer::INVOICE_ID, $obj->getId());
			$affectedRows += InvoiceProductPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	public static function doValidate(Invoice $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(InvoicePeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(InvoicePeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(InvoicePeer::DATABASE_NAME, InvoicePeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = InvoicePeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(InvoicePeer::DATABASE_NAME);

		$criteria->add(InvoicePeer::ID, $pk);


		$v = InvoicePeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(InvoicePeer::ID, $pks, Criteria::IN);
			$objs = InvoicePeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseInvoicePeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stInvoicePlugin.lib.model.map.InvoiceMapBuilder');
}
