<?php


abstract class BaseInvoiceProduct extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $invoice_id;


	
	protected $product_id;


	
	protected $name;


	
	protected $pkwiu;


	
	protected $quantity;


	
	protected $measure_unit;


	
	protected $discount;


	
	protected $price_netto;


	
	protected $price_brutto;


	
	protected $vat;


	
	protected $vat_id;


	
	protected $total_price_netto;


	
	protected $vat_ammount;


	
	protected $opt_total_price_brutto;

	
	protected $aInvoice;

	
	protected $aProduct;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getInvoiceId()
    {

            return $this->invoice_id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getPkwiu()
    {

            return $this->pkwiu;
    }

    
    public function getQuantity()
    {

            return null !== $this->quantity ? (string)$this->quantity : null;
    }

    
    public function getMeasureUnit()
    {

            return $this->measure_unit;
    }

    
    public function getDiscount()
    {

            return $this->discount;
    }

    
    public function getPriceNetto()
    {

            return null !== $this->price_netto ? (string)$this->price_netto : null;
    }

    
    public function getPriceBrutto()
    {

            return null !== $this->price_brutto ? (string)$this->price_brutto : null;
    }

    
    public function getVat()
    {

            return $this->vat;
    }

    
    public function getVatId()
    {

            return $this->vat_id;
    }

    
    public function getTotalPriceNetto()
    {

            return null !== $this->total_price_netto ? (string)$this->total_price_netto : null;
    }

    
    public function getVatAmmount()
    {

            return null !== $this->vat_ammount ? (string)$this->vat_ammount : null;
    }

    
    public function getOptTotalPriceBrutto()
    {

            return null !== $this->opt_total_price_brutto ? (string)$this->opt_total_price_brutto : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = InvoiceProductPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = InvoiceProductPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::ID;
        }

	} 
	
	public function setInvoiceId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_id !== $v) {
          $this->invoice_id = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::INVOICE_ID;
        }

		if ($this->aInvoice !== null && $this->aInvoice->getId() !== $v) {
			$this->aInvoice = null;
		}

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::NAME;
        }

	} 
	
	public function setPkwiu($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->pkwiu !== $v) {
          $this->pkwiu = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::PKWIU;
        }

	} 
	
	public function setQuantity($v)
	{

        if ($this->quantity !== $v) {
          $this->quantity = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::QUANTITY;
        }

	} 
	
	public function setMeasureUnit($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->measure_unit !== $v) {
          $this->measure_unit = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::MEASURE_UNIT;
        }

	} 
	
	public function setDiscount($v)
	{

        if ($this->discount !== $v) {
          $this->discount = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::DISCOUNT;
        }

	} 
	
	public function setPriceNetto($v)
	{

        if ($this->price_netto !== $v) {
          $this->price_netto = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::PRICE_NETTO;
        }

	} 
	
	public function setPriceBrutto($v)
	{

        if ($this->price_brutto !== $v) {
          $this->price_brutto = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::PRICE_BRUTTO;
        }

	} 
	
	public function setVat($v)
	{

        if ($this->vat !== $v) {
          $this->vat = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::VAT;
        }

	} 
	
	public function setVatId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->vat_id !== $v) {
          $this->vat_id = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::VAT_ID;
        }

	} 
	
	public function setTotalPriceNetto($v)
	{

        if ($this->total_price_netto !== $v) {
          $this->total_price_netto = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::TOTAL_PRICE_NETTO;
        }

	} 
	
	public function setVatAmmount($v)
	{

        if ($this->vat_ammount !== $v) {
          $this->vat_ammount = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::VAT_AMMOUNT;
        }

	} 
	
	public function setOptTotalPriceBrutto($v)
	{

        if ($this->opt_total_price_brutto !== $v) {
          $this->opt_total_price_brutto = $v;
          $this->modifiedColumns[] = InvoiceProductPeer::OPT_TOTAL_PRICE_BRUTTO;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceProduct.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->invoice_id = $rs->getInt($startcol + 3);

      $this->product_id = $rs->getInt($startcol + 4);

      $this->name = $rs->getString($startcol + 5);

      $this->pkwiu = $rs->getString($startcol + 6);

      $this->quantity = $rs->getString($startcol + 7, null);

      $this->quantity = $rs->getFloat($startcol + 7);

      $this->measure_unit = $rs->getString($startcol + 8);

      $this->discount = $rs->getFloat($startcol + 9);

      $this->price_netto = $rs->getString($startcol + 10, null);

      $this->price_netto = $rs->getFloat($startcol + 10);

      $this->price_brutto = $rs->getString($startcol + 11, null);

      $this->price_brutto = $rs->getFloat($startcol + 11);

      $this->vat = $rs->getFloat($startcol + 12);

      $this->vat_id = $rs->getInt($startcol + 13);

      $this->total_price_netto = $rs->getString($startcol + 14, null);

      $this->total_price_netto = $rs->getFloat($startcol + 14);

      $this->vat_ammount = $rs->getString($startcol + 15, null);

      $this->vat_ammount = $rs->getFloat($startcol + 15);

      $this->opt_total_price_brutto = $rs->getString($startcol + 16, null);

      $this->opt_total_price_brutto = $rs->getFloat($startcol + 16);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceProduct.postHydrate', array('resultset' => $rs, 'startcol' => 17)));

            return $startcol + 17; 
    } catch (Exception $e) {
      throw new PropelException("Error populating InvoiceProduct object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoiceProduct:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			InvoiceProductPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseInvoiceProduct:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceProduct.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseInvoiceProduct:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(InvoiceProductPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(InvoiceProductPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceProduct.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseInvoiceProduct:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aInvoice !== null) {
				if ($this->aInvoice->isModified()) {
					$affectedRows += $this->aInvoice->save($con);
				}
				$this->setInvoice($this->aInvoice);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = InvoiceProductPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += InvoiceProductPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aInvoice !== null) {
				if (!$this->aInvoice->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aInvoice->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}


			if (($retval = InvoiceProductPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getInvoiceId();
				break;
			case 4:
				return $this->getProductId();
				break;
			case 5:
				return $this->getName();
				break;
			case 6:
				return $this->getPkwiu();
				break;
			case 7:
				return $this->getQuantity();
				break;
			case 8:
				return $this->getMeasureUnit();
				break;
			case 9:
				return $this->getDiscount();
				break;
			case 10:
				return $this->getPriceNetto();
				break;
			case 11:
				return $this->getPriceBrutto();
				break;
			case 12:
				return $this->getVat();
				break;
			case 13:
				return $this->getVatId();
				break;
			case 14:
				return $this->getTotalPriceNetto();
				break;
			case 15:
				return $this->getVatAmmount();
				break;
			case 16:
				return $this->getOptTotalPriceBrutto();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceProductPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getInvoiceId(),
			$keys[4] => $this->getProductId(),
			$keys[5] => $this->getName(),
			$keys[6] => $this->getPkwiu(),
			$keys[7] => $this->getQuantity(),
			$keys[8] => $this->getMeasureUnit(),
			$keys[9] => $this->getDiscount(),
			$keys[10] => $this->getPriceNetto(),
			$keys[11] => $this->getPriceBrutto(),
			$keys[12] => $this->getVat(),
			$keys[13] => $this->getVatId(),
			$keys[14] => $this->getTotalPriceNetto(),
			$keys[15] => $this->getVatAmmount(),
			$keys[16] => $this->getOptTotalPriceBrutto(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setInvoiceId($value);
				break;
			case 4:
				$this->setProductId($value);
				break;
			case 5:
				$this->setName($value);
				break;
			case 6:
				$this->setPkwiu($value);
				break;
			case 7:
				$this->setQuantity($value);
				break;
			case 8:
				$this->setMeasureUnit($value);
				break;
			case 9:
				$this->setDiscount($value);
				break;
			case 10:
				$this->setPriceNetto($value);
				break;
			case 11:
				$this->setPriceBrutto($value);
				break;
			case 12:
				$this->setVat($value);
				break;
			case 13:
				$this->setVatId($value);
				break;
			case 14:
				$this->setTotalPriceNetto($value);
				break;
			case 15:
				$this->setVatAmmount($value);
				break;
			case 16:
				$this->setOptTotalPriceBrutto($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceProductPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setInvoiceId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setProductId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPkwiu($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setQuantity($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setMeasureUnit($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setDiscount($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setPriceNetto($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setPriceBrutto($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setVat($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setVatId($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setTotalPriceNetto($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setVatAmmount($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setOptTotalPriceBrutto($arr[$keys[16]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(InvoiceProductPeer::DATABASE_NAME);

		if ($this->isColumnModified(InvoiceProductPeer::CREATED_AT)) $criteria->add(InvoiceProductPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(InvoiceProductPeer::UPDATED_AT)) $criteria->add(InvoiceProductPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(InvoiceProductPeer::ID)) $criteria->add(InvoiceProductPeer::ID, $this->id);
		if ($this->isColumnModified(InvoiceProductPeer::INVOICE_ID)) $criteria->add(InvoiceProductPeer::INVOICE_ID, $this->invoice_id);
		if ($this->isColumnModified(InvoiceProductPeer::PRODUCT_ID)) $criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(InvoiceProductPeer::NAME)) $criteria->add(InvoiceProductPeer::NAME, $this->name);
		if ($this->isColumnModified(InvoiceProductPeer::PKWIU)) $criteria->add(InvoiceProductPeer::PKWIU, $this->pkwiu);
		if ($this->isColumnModified(InvoiceProductPeer::QUANTITY)) $criteria->add(InvoiceProductPeer::QUANTITY, $this->quantity);
		if ($this->isColumnModified(InvoiceProductPeer::MEASURE_UNIT)) $criteria->add(InvoiceProductPeer::MEASURE_UNIT, $this->measure_unit);
		if ($this->isColumnModified(InvoiceProductPeer::DISCOUNT)) $criteria->add(InvoiceProductPeer::DISCOUNT, $this->discount);
		if ($this->isColumnModified(InvoiceProductPeer::PRICE_NETTO)) $criteria->add(InvoiceProductPeer::PRICE_NETTO, $this->price_netto);
		if ($this->isColumnModified(InvoiceProductPeer::PRICE_BRUTTO)) $criteria->add(InvoiceProductPeer::PRICE_BRUTTO, $this->price_brutto);
		if ($this->isColumnModified(InvoiceProductPeer::VAT)) $criteria->add(InvoiceProductPeer::VAT, $this->vat);
		if ($this->isColumnModified(InvoiceProductPeer::VAT_ID)) $criteria->add(InvoiceProductPeer::VAT_ID, $this->vat_id);
		if ($this->isColumnModified(InvoiceProductPeer::TOTAL_PRICE_NETTO)) $criteria->add(InvoiceProductPeer::TOTAL_PRICE_NETTO, $this->total_price_netto);
		if ($this->isColumnModified(InvoiceProductPeer::VAT_AMMOUNT)) $criteria->add(InvoiceProductPeer::VAT_AMMOUNT, $this->vat_ammount);
		if ($this->isColumnModified(InvoiceProductPeer::OPT_TOTAL_PRICE_BRUTTO)) $criteria->add(InvoiceProductPeer::OPT_TOTAL_PRICE_BRUTTO, $this->opt_total_price_brutto);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(InvoiceProductPeer::DATABASE_NAME);

		$criteria->add(InvoiceProductPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setInvoiceId($this->invoice_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setName($this->name);

		$copyObj->setPkwiu($this->pkwiu);

		$copyObj->setQuantity($this->quantity);

		$copyObj->setMeasureUnit($this->measure_unit);

		$copyObj->setDiscount($this->discount);

		$copyObj->setPriceNetto($this->price_netto);

		$copyObj->setPriceBrutto($this->price_brutto);

		$copyObj->setVat($this->vat);

		$copyObj->setVatId($this->vat_id);

		$copyObj->setTotalPriceNetto($this->total_price_netto);

		$copyObj->setVatAmmount($this->vat_ammount);

		$copyObj->setOptTotalPriceBrutto($this->opt_total_price_brutto);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new InvoiceProductPeer();
		}
		return self::$peer;
	}

	
	public function setInvoice($v)
	{


		if ($v === null) {
			$this->setInvoiceId(NULL);
		} else {
			$this->setInvoiceId($v->getId());
		}


		$this->aInvoice = $v;
	}


	
	public function getInvoice($con = null)
	{
		if ($this->aInvoice === null && ($this->invoice_id !== null)) {
						$this->aInvoice = InvoicePeer::retrieveByPK($this->invoice_id, $con);

			
		}
		return $this->aInvoice;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'InvoiceProduct.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseInvoiceProduct:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseInvoiceProduct::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 