<?php


abstract class BaseInvoiceStatus extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $invoice_id;


	
	protected $payment_id = 0;


	
	protected $opt_payment_type_name;


	
	protected $opt_payment_status = false;


	
	protected $opt_payment_type_id;


	
	protected $hand_mod = false;


	
	protected $paid_amount;

	
	protected $aInvoice;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getInvoiceId()
    {

            return $this->invoice_id;
    }

    
    public function getPaymentId()
    {

            return $this->payment_id;
    }

    
    public function getOptPaymentTypeName()
    {

            return $this->opt_payment_type_name;
    }

    
    public function getOptPaymentStatus()
    {

            return $this->opt_payment_status;
    }

    
    public function getOptPaymentTypeId()
    {

            return $this->opt_payment_type_id;
    }

    
    public function getHandMod()
    {

            return $this->hand_mod;
    }

    
    public function getPaidAmount()
    {

            return null !== $this->paid_amount ? (string)$this->paid_amount : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = InvoiceStatusPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = InvoiceStatusPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::ID;
        }

	} 
	
	public function setInvoiceId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->invoice_id !== $v) {
          $this->invoice_id = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::INVOICE_ID;
        }

		if ($this->aInvoice !== null && $this->aInvoice->getId() !== $v) {
			$this->aInvoice = null;
		}

	} 
	
	public function setPaymentId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->payment_id !== $v || $v === 0) {
          $this->payment_id = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::PAYMENT_ID;
        }

	} 
	
	public function setOptPaymentTypeName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_payment_type_name !== $v) {
          $this->opt_payment_type_name = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::OPT_PAYMENT_TYPE_NAME;
        }

	} 
	
	public function setOptPaymentStatus($v)
	{

        if ($this->opt_payment_status !== $v || $v === false) {
          $this->opt_payment_status = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::OPT_PAYMENT_STATUS;
        }

	} 
	
	public function setOptPaymentTypeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_payment_type_id !== $v) {
          $this->opt_payment_type_id = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::OPT_PAYMENT_TYPE_ID;
        }

	} 
	
	public function setHandMod($v)
	{

        if ($this->hand_mod !== $v || $v === false) {
          $this->hand_mod = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::HAND_MOD;
        }

	} 
	
	public function setPaidAmount($v)
	{

        if ($this->paid_amount !== $v) {
          $this->paid_amount = $v;
          $this->modifiedColumns[] = InvoiceStatusPeer::PAID_AMOUNT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceStatus.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->invoice_id = $rs->getInt($startcol + 3);

      $this->payment_id = $rs->getInt($startcol + 4);

      $this->opt_payment_type_name = $rs->getString($startcol + 5);

      $this->opt_payment_status = $rs->getBoolean($startcol + 6);

      $this->opt_payment_type_id = $rs->getInt($startcol + 7);

      $this->hand_mod = $rs->getBoolean($startcol + 8);

      $this->paid_amount = $rs->getString($startcol + 9, null);

      $this->paid_amount = $rs->getFloat($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceStatus.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating InvoiceStatus object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoiceStatus:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			InvoiceStatusPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseInvoiceStatus:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceStatus.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseInvoiceStatus:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(InvoiceStatusPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(InvoiceStatusPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceStatus.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseInvoiceStatus:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aInvoice !== null) {
				if ($this->aInvoice->isModified()) {
					$affectedRows += $this->aInvoice->save($con);
				}
				$this->setInvoice($this->aInvoice);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = InvoiceStatusPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += InvoiceStatusPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aInvoice !== null) {
				if (!$this->aInvoice->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aInvoice->getValidationFailures());
				}
			}


			if (($retval = InvoiceStatusPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getInvoiceId();
				break;
			case 4:
				return $this->getPaymentId();
				break;
			case 5:
				return $this->getOptPaymentTypeName();
				break;
			case 6:
				return $this->getOptPaymentStatus();
				break;
			case 7:
				return $this->getOptPaymentTypeId();
				break;
			case 8:
				return $this->getHandMod();
				break;
			case 9:
				return $this->getPaidAmount();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceStatusPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getInvoiceId(),
			$keys[4] => $this->getPaymentId(),
			$keys[5] => $this->getOptPaymentTypeName(),
			$keys[6] => $this->getOptPaymentStatus(),
			$keys[7] => $this->getOptPaymentTypeId(),
			$keys[8] => $this->getHandMod(),
			$keys[9] => $this->getPaidAmount(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setInvoiceId($value);
				break;
			case 4:
				$this->setPaymentId($value);
				break;
			case 5:
				$this->setOptPaymentTypeName($value);
				break;
			case 6:
				$this->setOptPaymentStatus($value);
				break;
			case 7:
				$this->setOptPaymentTypeId($value);
				break;
			case 8:
				$this->setHandMod($value);
				break;
			case 9:
				$this->setPaidAmount($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceStatusPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setInvoiceId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setPaymentId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptPaymentTypeName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptPaymentStatus($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptPaymentTypeId($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setHandMod($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setPaidAmount($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(InvoiceStatusPeer::DATABASE_NAME);

		if ($this->isColumnModified(InvoiceStatusPeer::CREATED_AT)) $criteria->add(InvoiceStatusPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(InvoiceStatusPeer::UPDATED_AT)) $criteria->add(InvoiceStatusPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(InvoiceStatusPeer::ID)) $criteria->add(InvoiceStatusPeer::ID, $this->id);
		if ($this->isColumnModified(InvoiceStatusPeer::INVOICE_ID)) $criteria->add(InvoiceStatusPeer::INVOICE_ID, $this->invoice_id);
		if ($this->isColumnModified(InvoiceStatusPeer::PAYMENT_ID)) $criteria->add(InvoiceStatusPeer::PAYMENT_ID, $this->payment_id);
		if ($this->isColumnModified(InvoiceStatusPeer::OPT_PAYMENT_TYPE_NAME)) $criteria->add(InvoiceStatusPeer::OPT_PAYMENT_TYPE_NAME, $this->opt_payment_type_name);
		if ($this->isColumnModified(InvoiceStatusPeer::OPT_PAYMENT_STATUS)) $criteria->add(InvoiceStatusPeer::OPT_PAYMENT_STATUS, $this->opt_payment_status);
		if ($this->isColumnModified(InvoiceStatusPeer::OPT_PAYMENT_TYPE_ID)) $criteria->add(InvoiceStatusPeer::OPT_PAYMENT_TYPE_ID, $this->opt_payment_type_id);
		if ($this->isColumnModified(InvoiceStatusPeer::HAND_MOD)) $criteria->add(InvoiceStatusPeer::HAND_MOD, $this->hand_mod);
		if ($this->isColumnModified(InvoiceStatusPeer::PAID_AMOUNT)) $criteria->add(InvoiceStatusPeer::PAID_AMOUNT, $this->paid_amount);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(InvoiceStatusPeer::DATABASE_NAME);

		$criteria->add(InvoiceStatusPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setInvoiceId($this->invoice_id);

		$copyObj->setPaymentId($this->payment_id);

		$copyObj->setOptPaymentTypeName($this->opt_payment_type_name);

		$copyObj->setOptPaymentStatus($this->opt_payment_status);

		$copyObj->setOptPaymentTypeId($this->opt_payment_type_id);

		$copyObj->setHandMod($this->hand_mod);

		$copyObj->setPaidAmount($this->paid_amount);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new InvoiceStatusPeer();
		}
		return self::$peer;
	}

	
	public function setInvoice($v)
	{


		if ($v === null) {
			$this->setInvoiceId(NULL);
		} else {
			$this->setInvoiceId($v->getId());
		}


		$this->aInvoice = $v;
	}


	
	public function getInvoice($con = null)
	{
		if ($this->aInvoice === null && ($this->invoice_id !== null)) {
						$this->aInvoice = InvoicePeer::retrieveByPK($this->invoice_id, $con);

			
		}
		return $this->aInvoice;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'InvoiceStatus.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseInvoiceStatus:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseInvoiceStatus::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 