<?php


abstract class BaseInvoiceUserCustomer extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $country;


	
	protected $full_name;


	
	protected $name;


	
	protected $surname;


	
	protected $address;


	
	protected $address_more;


	
	protected $region;


	
	protected $street;


	
	protected $house;


	
	protected $flat;


	
	protected $code;


	
	protected $town;


	
	protected $company;


	
	protected $vat_number;

	
	protected $collInvoices;

	
	protected $lastInvoiceCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCountry()
    {

            return $this->country;
    }

    
    public function getFullName()
    {

            return $this->full_name;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getSurname()
    {

            return $this->surname;
    }

    
    public function getAddress()
    {

            return $this->address;
    }

    
    public function getAddressMore()
    {

            return $this->address_more;
    }

    
    public function getRegion()
    {

            return $this->region;
    }

    
    public function getStreet()
    {

            return $this->street;
    }

    
    public function getHouse()
    {

            return $this->house;
    }

    
    public function getFlat()
    {

            return $this->flat;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getTown()
    {

            return $this->town;
    }

    
    public function getCompany()
    {

            return $this->company;
    }

    
    public function getVatNumber()
    {

            return $this->vat_number;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = InvoiceUserCustomerPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = InvoiceUserCustomerPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::ID;
        }

	} 
	
	public function setCountry($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->country !== $v) {
          $this->country = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::COUNTRY;
        }

	} 
	
	public function setFullName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->full_name !== $v) {
          $this->full_name = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::FULL_NAME;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::NAME;
        }

	} 
	
	public function setSurname($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->surname !== $v) {
          $this->surname = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::SURNAME;
        }

	} 
	
	public function setAddress($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address !== $v) {
          $this->address = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::ADDRESS;
        }

	} 
	
	public function setAddressMore($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address_more !== $v) {
          $this->address_more = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::ADDRESS_MORE;
        }

	} 
	
	public function setRegion($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->region !== $v) {
          $this->region = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::REGION;
        }

	} 
	
	public function setStreet($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->street !== $v) {
          $this->street = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::STREET;
        }

	} 
	
	public function setHouse($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->house !== $v) {
          $this->house = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::HOUSE;
        }

	} 
	
	public function setFlat($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->flat !== $v) {
          $this->flat = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::FLAT;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::CODE;
        }

	} 
	
	public function setTown($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->town !== $v) {
          $this->town = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::TOWN;
        }

	} 
	
	public function setCompany($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->company !== $v) {
          $this->company = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::COMPANY;
        }

	} 
	
	public function setVatNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->vat_number !== $v) {
          $this->vat_number = $v;
          $this->modifiedColumns[] = InvoiceUserCustomerPeer::VAT_NUMBER;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceUserCustomer.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->country = $rs->getString($startcol + 3);

      $this->full_name = $rs->getString($startcol + 4);

      $this->name = $rs->getString($startcol + 5);

      $this->surname = $rs->getString($startcol + 6);

      $this->address = $rs->getString($startcol + 7);

      $this->address_more = $rs->getString($startcol + 8);

      $this->region = $rs->getString($startcol + 9);

      $this->street = $rs->getString($startcol + 10);

      $this->house = $rs->getString($startcol + 11);

      $this->flat = $rs->getString($startcol + 12);

      $this->code = $rs->getString($startcol + 13);

      $this->town = $rs->getString($startcol + 14);

      $this->company = $rs->getString($startcol + 15);

      $this->vat_number = $rs->getString($startcol + 16);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceUserCustomer.postHydrate', array('resultset' => $rs, 'startcol' => 17)));

            return $startcol + 17; 
    } catch (Exception $e) {
      throw new PropelException("Error populating InvoiceUserCustomer object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseInvoiceUserCustomer:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceUserCustomerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			InvoiceUserCustomerPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseInvoiceUserCustomer:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceUserCustomer.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseInvoiceUserCustomer:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(InvoiceUserCustomerPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(InvoiceUserCustomerPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(InvoiceUserCustomerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'InvoiceUserCustomer.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseInvoiceUserCustomer:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = InvoiceUserCustomerPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += InvoiceUserCustomerPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collInvoices !== null) {
				foreach($this->collInvoices as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = InvoiceUserCustomerPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collInvoices !== null) {
					foreach($this->collInvoices as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceUserCustomerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCountry();
				break;
			case 4:
				return $this->getFullName();
				break;
			case 5:
				return $this->getName();
				break;
			case 6:
				return $this->getSurname();
				break;
			case 7:
				return $this->getAddress();
				break;
			case 8:
				return $this->getAddressMore();
				break;
			case 9:
				return $this->getRegion();
				break;
			case 10:
				return $this->getStreet();
				break;
			case 11:
				return $this->getHouse();
				break;
			case 12:
				return $this->getFlat();
				break;
			case 13:
				return $this->getCode();
				break;
			case 14:
				return $this->getTown();
				break;
			case 15:
				return $this->getCompany();
				break;
			case 16:
				return $this->getVatNumber();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceUserCustomerPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCountry(),
			$keys[4] => $this->getFullName(),
			$keys[5] => $this->getName(),
			$keys[6] => $this->getSurname(),
			$keys[7] => $this->getAddress(),
			$keys[8] => $this->getAddressMore(),
			$keys[9] => $this->getRegion(),
			$keys[10] => $this->getStreet(),
			$keys[11] => $this->getHouse(),
			$keys[12] => $this->getFlat(),
			$keys[13] => $this->getCode(),
			$keys[14] => $this->getTown(),
			$keys[15] => $this->getCompany(),
			$keys[16] => $this->getVatNumber(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = InvoiceUserCustomerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCountry($value);
				break;
			case 4:
				$this->setFullName($value);
				break;
			case 5:
				$this->setName($value);
				break;
			case 6:
				$this->setSurname($value);
				break;
			case 7:
				$this->setAddress($value);
				break;
			case 8:
				$this->setAddressMore($value);
				break;
			case 9:
				$this->setRegion($value);
				break;
			case 10:
				$this->setStreet($value);
				break;
			case 11:
				$this->setHouse($value);
				break;
			case 12:
				$this->setFlat($value);
				break;
			case 13:
				$this->setCode($value);
				break;
			case 14:
				$this->setTown($value);
				break;
			case 15:
				$this->setCompany($value);
				break;
			case 16:
				$this->setVatNumber($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = InvoiceUserCustomerPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCountry($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setFullName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setSurname($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAddress($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setAddressMore($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setRegion($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setStreet($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setHouse($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setFlat($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setCode($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setTown($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setCompany($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setVatNumber($arr[$keys[16]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(InvoiceUserCustomerPeer::DATABASE_NAME);

		if ($this->isColumnModified(InvoiceUserCustomerPeer::CREATED_AT)) $criteria->add(InvoiceUserCustomerPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::UPDATED_AT)) $criteria->add(InvoiceUserCustomerPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::ID)) $criteria->add(InvoiceUserCustomerPeer::ID, $this->id);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::COUNTRY)) $criteria->add(InvoiceUserCustomerPeer::COUNTRY, $this->country);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::FULL_NAME)) $criteria->add(InvoiceUserCustomerPeer::FULL_NAME, $this->full_name);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::NAME)) $criteria->add(InvoiceUserCustomerPeer::NAME, $this->name);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::SURNAME)) $criteria->add(InvoiceUserCustomerPeer::SURNAME, $this->surname);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::ADDRESS)) $criteria->add(InvoiceUserCustomerPeer::ADDRESS, $this->address);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::ADDRESS_MORE)) $criteria->add(InvoiceUserCustomerPeer::ADDRESS_MORE, $this->address_more);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::REGION)) $criteria->add(InvoiceUserCustomerPeer::REGION, $this->region);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::STREET)) $criteria->add(InvoiceUserCustomerPeer::STREET, $this->street);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::HOUSE)) $criteria->add(InvoiceUserCustomerPeer::HOUSE, $this->house);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::FLAT)) $criteria->add(InvoiceUserCustomerPeer::FLAT, $this->flat);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::CODE)) $criteria->add(InvoiceUserCustomerPeer::CODE, $this->code);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::TOWN)) $criteria->add(InvoiceUserCustomerPeer::TOWN, $this->town);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::COMPANY)) $criteria->add(InvoiceUserCustomerPeer::COMPANY, $this->company);
		if ($this->isColumnModified(InvoiceUserCustomerPeer::VAT_NUMBER)) $criteria->add(InvoiceUserCustomerPeer::VAT_NUMBER, $this->vat_number);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(InvoiceUserCustomerPeer::DATABASE_NAME);

		$criteria->add(InvoiceUserCustomerPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCountry($this->country);

		$copyObj->setFullName($this->full_name);

		$copyObj->setName($this->name);

		$copyObj->setSurname($this->surname);

		$copyObj->setAddress($this->address);

		$copyObj->setAddressMore($this->address_more);

		$copyObj->setRegion($this->region);

		$copyObj->setStreet($this->street);

		$copyObj->setHouse($this->house);

		$copyObj->setFlat($this->flat);

		$copyObj->setCode($this->code);

		$copyObj->setTown($this->town);

		$copyObj->setCompany($this->company);

		$copyObj->setVatNumber($this->vat_number);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getInvoices() as $relObj) {
				$copyObj->addInvoice($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new InvoiceUserCustomerPeer();
		}
		return self::$peer;
	}

	
	public function initInvoices()
	{
		if ($this->collInvoices === null) {
			$this->collInvoices = array();
		}
	}

	
	public function getInvoices($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
			   $this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

				InvoicePeer::addSelectColumns($criteria);
				$this->collInvoices = InvoicePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

				InvoicePeer::addSelectColumns($criteria);
				if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
					$this->collInvoices = InvoicePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastInvoiceCriteria = $criteria;
		return $this->collInvoices;
	}

	
	public function countInvoices($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

		return InvoicePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addInvoice(Invoice $l)
	{
		$this->collInvoices[] = $l;
		$l->setInvoiceUserCustomer($this);
	}


	
	public function getInvoicesJoinInvoiceUserSeller($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserSeller($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserSeller($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}


	
	public function getInvoicesJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}


	
	public function getInvoicesJoinInvoiceCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::INVOICE_USER_CUSTOMER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceCurrency($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'InvoiceUserCustomer.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseInvoiceUserCustomer:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseInvoiceUserCustomer::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 