<?php
/**
 * 
 */

class stInvoicePdf {
    
    protected $pdf = null;
    
    protected $invoiceId = null;
        
    protected $showBorder = 0;
    
    public static $PDF_MARGIN_TOP = 5;
    
    public static $PDF_MARGIN_LEFT = 5;
    
    public static $PDF_MARGIN_RIGHT = 5;
    
    protected $download = "D";
    
    public function __construct($invoiceId) {
        /**
         * inicjalizacja klasy stInvoicePdf
         */
        $this->pdf = new stCustomTCPDF();
        $this->invoiceId = $invoiceId;

        //tryb developerski
        if (SF_DEBUG) $this->showBorder=1;
        
        $this->configure();
    }
    
    protected function configure() {
        $this->pdf->SetFont("dejavusans", "", 11);
        $this->pdf->SetMargins(stInvoicePdf::$PDF_MARGIN_LEFT, stInvoicePdf::$PDF_MARGIN_TOP, stInvoicePdf::$PDF_MARGIN_RIGHT);
        $this->pdf->AddPage();
    }
    
    public function forceDownload($download = false) {
        $this->download = $download?"D":"I";
    }
    
    public function renderInvoice() {
        
        $this->pdf->startPageGroup(); 
        
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->invoiceId);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $c = new Criteria();
        $c->add(OrderPeer::ID, $invoice->getOrderId());        
        $orderd = OrderPeer::doSelectOne($c);
        
        $sellerInfoHTML = st_get_component('stInvoicePdf', 'sellerInfo', array('id'=>$this->invoiceId));
        $dateInfoHTML = st_get_component('stInvoicePdf', 'dateInfo', array('id'=>$this->invoiceId));
        $sellerAddressHTML = st_get_component('stInvoicePdf', 'sellerAddress', array('id'=>$this->invoiceId));
        $buyerAddressHTML = st_get_component('stInvoicePdf', 'buyerAddress', array('id'=>$this->invoiceId));
        
        
        if($invoice->getIsProforma() != 1)
        {
            $invoiceNumberHTML = st_get_component('stInvoicePdf', 'invoiceNumber', array('id'=>$this->invoiceId, 'invoiceType'=>'1'));
        }
        else 
        {
            $invoiceNumberHTML = st_get_component('stInvoicePdf', 'invoiceNumber', array('id'=>$this->invoiceId, 'invoiceType'=>'3'));
        }
        
        
        $invoiceItemsHTML = st_get_component('stInvoicePdf', 'invoiceItems', array('id'=>$this->invoiceId));
        $invoiceTaxSummaryHTML = st_get_component('stInvoicePdf', 'invoiceTaxSummary', array('id'=>$this->invoiceId));
        $invoiceSummaryHTML = st_get_component('stInvoicePdf', 'invoiceSummary', array('id'=>$this->invoiceId));
        $sellerSignHTML = st_get_component('stInvoicePdf', 'sellerSign', array('id'=>$this->invoiceId));
        $buyerSignHTML = st_get_component('stInvoicePdf', 'buyerSign', array('id'=>$this->invoiceId));      
        
        
        //$this->pdf->SetDrawColor(255, 255, 255);
        $this->pdf->SetDrawColor(120, 120, 120);
        $this->pdf->SetLineWidth(0.2); 
        
        $current_y_pos = stInvoicePdf::$PDF_MARGIN_TOP;
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerInfoHTML,$this->showBorder,1,0);
        $new_y_pos = $this->pdf->getY();

        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $dateInfoHTML,$this->showBorder,1,0); 
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;

        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerAddressHTML,$this->showBorder,1,0); 
        $new_y_pos = $this->pdf->getY();
        
        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $buyerAddressHTML,$this->showBorder,1,0); 
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(0,0,0,$current_y_pos, $invoiceNumberHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,0,0, $invoiceItemsHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,70,0, $invoiceTaxSummaryHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,0,0, $invoiceSummaryHTML,$this->showBorder,1,0);
        
        $current_y_pos = $this->pdf->getY();
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerSignHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $buyerSignHTML,$this->showBorder,1,0);
        
             
        if($invoice->getIsProforma() != 1)
        {
        $invoiceNumberHTML = st_get_component('stInvoicePdf', 'invoiceNumber', array('id'=>$this->invoiceId, 'invoiceType'=>'2'));
            
        $this->pdf->AddPage(); 
        
       
        //$this->pdf->SetDrawColor(255, 255, 255);
        $this->pdf->SetDrawColor(120, 120, 120);
        $this->pdf->SetLineWidth(0.2); 
        
        $current_y_pos = stInvoicePdf::$PDF_MARGIN_TOP;
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerInfoHTML,$this->showBorder,1,0);
        $new_y_pos = $this->pdf->getY();

        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $dateInfoHTML,$this->showBorder,1,0); 
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;

        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerAddressHTML,$this->showBorder,1,0); 
        $new_y_pos = $this->pdf->getY();
        
        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $buyerAddressHTML,$this->showBorder,1,0); 
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(0,0,0,$current_y_pos, $invoiceNumberHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,0,0, $invoiceItemsHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,70,0, $invoiceTaxSummaryHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,0,0, $invoiceSummaryHTML,$this->showBorder,1,0);
        
        $current_y_pos = $this->pdf->getY();
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $sellerSignHTML,$this->showBorder,1,0);
        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $buyerSignHTML,$this->showBorder,1,0);
        
        }              
        
        
        $user_id = sfContext::getInstance()->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');
        
        if (SF_APP == 'backend')
        {
                if($invoice->getIsProforma() == 1)
                {
                    $this->pdf->Output('proforma-'.$invoice->getNumber().'.pdf',$this->download);
                }
                else
                {
                    $this->pdf->Output('invoice-'.$invoice->getNumber().'.pdf',$this->download);    
                }
        }
        else 
        {
            if($orderd->getSfGuardUserId() == $user_id)
            {
                       
                if($invoice->getIsProforma() == 1)
                {
                    $this->pdf->Output('proforma-'.$invoice->getNumber().'.pdf',$this->download);
                }
                else
                {
                    $this->pdf->Output('invoice-'.$invoice->getNumber().'.pdf',$this->download);    
                }
            
            }
        }

    }
}