<?php
/**
 * SOTESHOP/stInvoicePlugin
 *
 * Ten plik należy do aplikacji stInvoicePlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stInvoicePlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 2285 2009-07-23 12:50:05Z bartek $
 * @author      Bartosz Alejski <bartosz.alejski@sote.pl>
 */

/**
 * Komponent stInvoiceFrontendComponents
 *
 * @package     stInvoicePlugin
 * @subpackage  actions
 */
class stInvoicePdfComponents extends sfComponents
{
    public function executeSellerInfo() 
    {  
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
    }

    public function executeDateInfo()
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);
        $invoice = InvoicePeer::doSelectOne($c);
        
        $description = $invoice->getCompanyDescription();
        
        $test = substr($description,3);
        
        
        
        $invoice->setCompanyDescription($test);
        
        $this->invoice = $invoice;   
        
    }
    
    public function executeSellerAddress() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);
        $invoice = InvoicePeer::doSelectOne($c);    
                
        $c = new Criteria();
        $c->add(InvoiceUserSellerPeer::ID  , $invoice->getInvoiceUserSellerId());        
        $InvoiceUserSeller = InvoiceUserSellerPeer::doSelectOne($c);
        
        $this->InvoiceUserSeller = $InvoiceUserSeller;
    }
    
    public function executeBuyerAddress() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);
        $invoice = InvoicePeer::doSelectOne($c);    
        
        $c = new Criteria();
        $c->add(InvoiceUserCustomerPeer::ID  , $invoice->getInvoiceUserCustomerId());        
        $InvoiceUserCustomer = InvoiceUserCustomerPeer::doSelectOne($c);
        
        $this->InvoiceUserCustomer = $InvoiceUserCustomer;
    }

    public function executeInvoiceNumber() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
        
        if($this->invoiceType==1)
        {
            $this->invoiceVersion = __('oryginał');
        }
        
        if($this->invoiceType==2)
        {
            $this->invoiceVersion = __('kopia');
        }
        
        if($this->invoiceType==3)
        {
            $this->invoiceVersion = "";   
        }
    }
    
    public function executeInvoiceItems() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
        
        $c = new Criteria();
        $c->add(InvoiceProductPeer::INVOICE_ID , $this->id);        
        $invoiceProducts = InvoiceProductPeer::doSelect($c);
                      
        $c = new Criteria();
        $c->addDescendingOrderByColumn(TaxPeer::IS_DEFAULT);
        $tax = TaxPeer::doSelect($c);
        
        foreach ($invoiceProducts as $product)
        {    
            $c = new Criteria();
            $c->add(TaxPeer::ID, $product->getVatId());        
            $vat = TaxPeer::doSelectOne($c);
            
            $product->setVat($vat);
        }
        
        $this->invoiceProducts = $invoiceProducts;
        
    }

    public function executeInvoiceTaxSummary() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
        
        
        $c = new Criteria();
        $c->addDescendingOrderByColumn(TaxPeer::IS_DEFAULT);
        $tax = TaxPeer::doSelect($c);
        
        $i=0;
        foreach ($tax as $vat)
        {
            $i++; 
            $c = new Criteria();
            $c->add(InvoiceProductPeer::INVOICE_ID , $this->id);        
            $c->add(InvoiceProductPeer::VAT_ID  , $vat->getId());
            $vatProducts = InvoiceProductPeer::doSelect($c);   
            
                $price_brutto_bufor = 0;

                foreach ($vatProducts as $vatProduct)
                {
                    $price_brutto_bufor += stCurrency::formatPrice($vatProduct->getOptTotalPriceBrutto());
                }

                if($price_brutto_bufor != 0)
                {
                    $taxProducts[$i]['vat_id'] = $vat->getId();
                    $taxProducts[$i]['vat_name'] = $vat->getVatName();
                    $taxProducts[$i]['vat'] = $vat->getVat();
                    $taxProducts[$i]['is_default'] = $vat->getIsDefault();
                    $taxProducts[$i]['total_netto'] = stPrice::extract($price_brutto_bufor, $vat->getVat());
                    $taxProducts[$i]['total_ammount_vat'] = $price_brutto_bufor - stPrice::extract($price_brutto_bufor, $vat->getVat());
                    $taxProducts[$i]['total_brutto'] = $price_brutto_bufor;
                }
        }
        
        $this->taxProducts = $taxProducts;
    }
    
    public function executeInvoiceSummary() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $c = new Criteria();
        $c->add(InvoiceStatusPeer::INVOICE_ID, $invoice->getId());
        $status = InvoiceStatusPeer::doSelectOne($c);
        
        $c = new Criteria();
        $c->add(InvoiceCurrencyPeer::ID  , $invoice->getInvoiceCurrencyId());        
        $invoiceCurrency = InvoiceCurrencyPeer::doSelectOne($c);
        
        
        if($invoiceCurrency)
        {
            $shortcut = $invoiceCurrency->getShortcut();
            
        }else{
            
            $shortcut = "PLN";
        }
        
        $this->status = $status;
        $this->invoice = $invoice;
        $this->shortcut = $shortcut;
        
        $this->paid_amount = $status->getPaidAmount() > 0 && !$status->getOptPaymentStatus() ? $status->getPaidAmount() : $invoice->getOptTotalAmmountBrutto();
        
        $this->unpaid_amount = $invoice->getOptTotalAmmountBrutto() - $this->paid_amount;
    }
    
    public function executeSellerSign() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
    }

    public function executeBuyerSign() 
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $this->id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->invoice = $invoice;
    }
    
    public function  executeDownloadInvoice()
    {
        $ifirmaConfig = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');
        $this->ifirma_enabled = $ifirmaConfig->get('ifirma_enabled');

        $id = $this->getRequestParameter('id');
        
        $this->invoiceDefault = stConfig::getInstance($this->getContext(), 'stInvoiceBackend');

        $invoiceDefault = $this->invoiceDefault->load();
        $this->order = OrderPeer::retrieveByPk($id);        
        if($invoiceDefault['proforma_on']==1)
        {
            $this->showProforma = 1;
        }else 
        {
            $this->showProforma = 0;
        }
        
        
        $c = new Criteria();
        $c->add(InvoicePeer::ORDER_ID, $id);
        $c->add(InvoicePeer::IS_PROFORMA, 1);
        $invoice = InvoicePeer::doSelectOne($c);
        
        $this->number = $invoice->getId();
    }
    
    public function  executeOrderInvoice()
    {
        
        $this->invoiceDefault = stConfig::getInstance($this->getContext(), 'stInvoiceBackend');

        $invoiceDefault = $this->invoiceDefault->load();
        
        if($invoiceDefault['proforma_on']==1)
        {
            $this->showProforma = 1;
        }else 
        {
            $this->showProforma = 0;
        }
        
        $c = new Criteria();
        $c->add(InvoicePeer::ORDER_ID, $this->order->getId());        
        $c->add(InvoicePeer::IS_PROFORMA, 1);
        $invoiceProforma = InvoicePeer::doSelectOne($c);
        
        
        $c = new Criteria();
        $c->add(InvoicePeer::ORDER_ID, $this->order->getId());        
        $c->add(InvoicePeer::IS_CONFIRM, 1);
        $invoiceConfirm = InvoicePeer::doSelectOne($c);

        $ifirmaConfig = stConfig::getInstance(sfContext::getInstance(), 'stInvoiceBackend');
        $this->ifirma_enabled = $ifirmaConfig->get('ifirma_enabled');
        
        if($invoiceProforma)
        {
            $this->invoiceNumberProforma = $invoiceProforma->getId();    
        }
        
        if($invoiceConfirm)
        {
            $this->invoiceNumber = $invoiceConfirm->getId();    
        }
        
    }
    
    public function isProforma($id)
    {
        $c = new Criteria();
        $c->add(InvoicePeer::ID, $id);        
        $invoice = InvoicePeer::doSelectOne($c);
        
        if($invoice->getIsProforma()==1)
        {
            return true;
        }
        else 
        {
            return false;
        }
        
        
        
    }
    
}
