<?php

/**
 * Subclass for representing a row from the 'st_language_has_domain' table.
 *
 *
 *
 * @package plugins.stLanguagePlugin.lib.model
 */
class LanguageHasDomain extends BaseLanguageHasDomain
{
    /**
     * Przeciążenie zapisu
     */
    public function save($con = null)
    {
        stFastCacheManager::clearCache();
        stLanguageFastCache::create();
        
        $stCache = new stFunctionCache('stLanguagePlugin');
        $stCache->clearFunction('allLanguageHasDomain');
        $stCache->clearFunction('languageByDomain*');
        
        return parent::save($con);
    }

    /**
     * Przeciążenie zapisu
     */
    public function delete($con = null)
    {
        stFastCacheManager::clearCache();
        stLanguageFastCache::create();
        
        $stCache = new stFunctionCache('stLanguagePlugin');
        $stCache->clearFunction('allLanguageHasDomain');
        $stCache->clearFunction('languageByDomain*');

        return parent::delete($con);
    }

    /**
     * Ustawianie pola is_default
     */
    public function setIsDefault($v)
    {
        if ($v == 1 && $this->getIsDefault() == 0)
        {
            $c1 = new Criteria();
            $c1->add(LanguageHasDomainPeer::LANGUAGE_ID, $this->getLanguageId());
            $c2 = new Criteria();
            $c2->add(LanguageHasDomainPeer::IS_DEFAULT, 0);
            BasePeer::doUpdate($c1, $c2, Propel::getConnection());
        }

        parent::setIsDefault($v);
    }
}
