<?php

/**
 * Subclass for performing query and update operations on the 'st_language_has_domain' table.
 *
 *
 *
 * @package plugins.stLanguagePlugin.lib.model
 */
class LanguageHasDomainPeer extends BaseLanguageHasDomainPeer
{
    protected static $allLanguageHasDomain = null;
    
    public static function doSelectAll($con = null)
    {
        if (!is_null(self::$allLanguageHasDomain))
        {
            return self::$allLanguageHasDomain;
        } else {
            $stCache = new stFunctionCache('stLanguagePlugin');
            self::$allLanguageHasDomain = $stCache->add('allLanguageHasDomain',"LanguageHasDomainPeer::doSelect", new Criteria(), $con);
            return self::$allLanguageHasDomain; 
        }
        return null;
    }

    public static function doSelectByDomain($domain, $con = null)
    {
        $all = self::doSelectAll($con);
        foreach ($all as $key => $languageHasDomain)
        {
            if ($languageHasDomain->getDomain() == $domain) return $languageHasDomain;
        }
    }

    public static function doSelectByLanguageShortcut($shortcut, $con = null)
    {
        $languagesHasDomain = self::doSelectAll($con);
        $languages = LanguagePeer::doSelectActive(null, $con);
        $languageByShortcut = null;
        $return = array();

        foreach ($languages as $language)
        {
            if ($language->getShortcut() == $shortcut) $languageByShortcut = $language;
        }

        if(!is_null($languageByShortcut))
        {
            foreach ($languagesHasDomain as $languageHasDomain)
            {
                if ($languageHasDomain->getLanguageId() == $languageByShortcut->getId()) $return[] = $languageHasDomain;
            }
        }
        
        return $return;
    }
}