<?php


abstract class BaseLanguage extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $currency_id = 0;


	
	protected $active_image;


	
	protected $inactive_image;


	
	protected $shortcut;


	
	protected $is_default = false;


	
	protected $active = true;


	
	protected $language;


	
	protected $is_translate = false;


	
	protected $system = false;


	
	protected $is_default_panel;


	
	protected $is_translate_panel;


	
	protected $opt_name;

	
	protected $aCurrency;

	
	protected $collLanguageHasDomains;

	
	protected $lastLanguageHasDomainCriteria = null;

	
	protected $collLanguageI18ns;

	
	protected $lastLanguageI18nCriteria = null;

	
	protected $collProductHasAttachments;

	
	protected $lastProductHasAttachmentCriteria = null;

	
	protected $collSlideBanners;

	
	protected $lastSlideBannerCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCurrencyId()
    {

            return $this->currency_id;
    }

    
    public function getActiveImage()
    {

            return $this->active_image;
    }

    
    public function getInactiveImage()
    {

            return $this->inactive_image;
    }

    
    public function getShortcut()
    {

            return $this->shortcut;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getLanguage()
    {

            return $this->language;
    }

    
    public function getIsTranslate()
    {

            return $this->is_translate;
    }

    
    public function getSystem()
    {

            return $this->system;
    }

    
    public function getIsDefaultPanel()
    {

            return $this->is_default_panel;
    }

    
    public function getIsTranslatePanel()
    {

            return $this->is_translate_panel;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = LanguagePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = LanguagePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = LanguagePeer::ID;
        }

	} 
	
	public function setCurrencyId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->currency_id !== $v || $v === 0) {
          $this->currency_id = $v;
          $this->modifiedColumns[] = LanguagePeer::CURRENCY_ID;
        }

		if ($this->aCurrency !== null && $this->aCurrency->getId() !== $v) {
			$this->aCurrency = null;
		}

	} 
	
	public function setActiveImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->active_image !== $v) {
          $this->active_image = $v;
          $this->modifiedColumns[] = LanguagePeer::ACTIVE_IMAGE;
        }

	} 
	
	public function setInactiveImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->inactive_image !== $v) {
          $this->inactive_image = $v;
          $this->modifiedColumns[] = LanguagePeer::INACTIVE_IMAGE;
        }

	} 
	
	public function setShortcut($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->shortcut !== $v) {
          $this->shortcut = $v;
          $this->modifiedColumns[] = LanguagePeer::SHORTCUT;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = LanguagePeer::IS_DEFAULT;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === true) {
          $this->active = $v;
          $this->modifiedColumns[] = LanguagePeer::ACTIVE;
        }

	} 
	
	public function setLanguage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->language !== $v) {
          $this->language = $v;
          $this->modifiedColumns[] = LanguagePeer::LANGUAGE;
        }

	} 
	
	public function setIsTranslate($v)
	{

        if ($this->is_translate !== $v || $v === false) {
          $this->is_translate = $v;
          $this->modifiedColumns[] = LanguagePeer::IS_TRANSLATE;
        }

	} 
	
	public function setSystem($v)
	{

        if ($this->system !== $v || $v === false) {
          $this->system = $v;
          $this->modifiedColumns[] = LanguagePeer::SYSTEM;
        }

	} 
	
	public function setIsDefaultPanel($v)
	{

        if ($this->is_default_panel !== $v) {
          $this->is_default_panel = $v;
          $this->modifiedColumns[] = LanguagePeer::IS_DEFAULT_PANEL;
        }

	} 
	
	public function setIsTranslatePanel($v)
	{

        if ($this->is_translate_panel !== $v) {
          $this->is_translate_panel = $v;
          $this->modifiedColumns[] = LanguagePeer::IS_TRANSLATE_PANEL;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = LanguagePeer::OPT_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Language.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->currency_id = $rs->getInt($startcol + 3);

      $this->active_image = $rs->getString($startcol + 4);

      $this->inactive_image = $rs->getString($startcol + 5);

      $this->shortcut = $rs->getString($startcol + 6);

      $this->is_default = $rs->getBoolean($startcol + 7);

      $this->active = $rs->getBoolean($startcol + 8);

      $this->language = $rs->getString($startcol + 9);

      $this->is_translate = $rs->getBoolean($startcol + 10);

      $this->system = $rs->getBoolean($startcol + 11);

      $this->is_default_panel = $rs->getBoolean($startcol + 12);

      $this->is_translate_panel = $rs->getBoolean($startcol + 13);

      $this->opt_name = $rs->getString($startcol + 14);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Language.postHydrate', array('resultset' => $rs, 'startcol' => 15)));

            return $startcol + 15; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Language object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseLanguage:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(LanguagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			LanguagePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseLanguage:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Language.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseLanguage:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(LanguagePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(LanguagePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(LanguagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Language.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseLanguage:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCurrency !== null) {
				if ($this->aCurrency->isModified() || $this->aCurrency->getCurrentCurrencyI18n()->isModified()) {
					$affectedRows += $this->aCurrency->save($con);
				}
				$this->setCurrency($this->aCurrency);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = LanguagePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += LanguagePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collLanguageHasDomains !== null) {
				foreach($this->collLanguageHasDomains as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collLanguageI18ns !== null) {
				foreach($this->collLanguageI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAttachments !== null) {
				foreach($this->collProductHasAttachments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collSlideBanners !== null) {
				foreach($this->collSlideBanners as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCurrency !== null) {
				if (!$this->aCurrency->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCurrency->getValidationFailures());
				}
			}


			if (($retval = LanguagePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collLanguageHasDomains !== null) {
					foreach($this->collLanguageHasDomains as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collLanguageI18ns !== null) {
					foreach($this->collLanguageI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAttachments !== null) {
					foreach($this->collProductHasAttachments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collSlideBanners !== null) {
					foreach($this->collSlideBanners as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = LanguagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCurrencyId();
				break;
			case 4:
				return $this->getActiveImage();
				break;
			case 5:
				return $this->getInactiveImage();
				break;
			case 6:
				return $this->getShortcut();
				break;
			case 7:
				return $this->getIsDefault();
				break;
			case 8:
				return $this->getActive();
				break;
			case 9:
				return $this->getLanguage();
				break;
			case 10:
				return $this->getIsTranslate();
				break;
			case 11:
				return $this->getSystem();
				break;
			case 12:
				return $this->getIsDefaultPanel();
				break;
			case 13:
				return $this->getIsTranslatePanel();
				break;
			case 14:
				return $this->getOptName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = LanguagePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCurrencyId(),
			$keys[4] => $this->getActiveImage(),
			$keys[5] => $this->getInactiveImage(),
			$keys[6] => $this->getShortcut(),
			$keys[7] => $this->getIsDefault(),
			$keys[8] => $this->getActive(),
			$keys[9] => $this->getLanguage(),
			$keys[10] => $this->getIsTranslate(),
			$keys[11] => $this->getSystem(),
			$keys[12] => $this->getIsDefaultPanel(),
			$keys[13] => $this->getIsTranslatePanel(),
			$keys[14] => $this->getOptName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = LanguagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCurrencyId($value);
				break;
			case 4:
				$this->setActiveImage($value);
				break;
			case 5:
				$this->setInactiveImage($value);
				break;
			case 6:
				$this->setShortcut($value);
				break;
			case 7:
				$this->setIsDefault($value);
				break;
			case 8:
				$this->setActive($value);
				break;
			case 9:
				$this->setLanguage($value);
				break;
			case 10:
				$this->setIsTranslate($value);
				break;
			case 11:
				$this->setSystem($value);
				break;
			case 12:
				$this->setIsDefaultPanel($value);
				break;
			case 13:
				$this->setIsTranslatePanel($value);
				break;
			case 14:
				$this->setOptName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = LanguagePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCurrencyId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setActiveImage($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setInactiveImage($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setShortcut($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsDefault($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setActive($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setLanguage($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setIsTranslate($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setSystem($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setIsDefaultPanel($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setIsTranslatePanel($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setOptName($arr[$keys[14]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(LanguagePeer::DATABASE_NAME);

		if ($this->isColumnModified(LanguagePeer::CREATED_AT)) $criteria->add(LanguagePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(LanguagePeer::UPDATED_AT)) $criteria->add(LanguagePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(LanguagePeer::ID)) $criteria->add(LanguagePeer::ID, $this->id);
		if ($this->isColumnModified(LanguagePeer::CURRENCY_ID)) $criteria->add(LanguagePeer::CURRENCY_ID, $this->currency_id);
		if ($this->isColumnModified(LanguagePeer::ACTIVE_IMAGE)) $criteria->add(LanguagePeer::ACTIVE_IMAGE, $this->active_image);
		if ($this->isColumnModified(LanguagePeer::INACTIVE_IMAGE)) $criteria->add(LanguagePeer::INACTIVE_IMAGE, $this->inactive_image);
		if ($this->isColumnModified(LanguagePeer::SHORTCUT)) $criteria->add(LanguagePeer::SHORTCUT, $this->shortcut);
		if ($this->isColumnModified(LanguagePeer::IS_DEFAULT)) $criteria->add(LanguagePeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(LanguagePeer::ACTIVE)) $criteria->add(LanguagePeer::ACTIVE, $this->active);
		if ($this->isColumnModified(LanguagePeer::LANGUAGE)) $criteria->add(LanguagePeer::LANGUAGE, $this->language);
		if ($this->isColumnModified(LanguagePeer::IS_TRANSLATE)) $criteria->add(LanguagePeer::IS_TRANSLATE, $this->is_translate);
		if ($this->isColumnModified(LanguagePeer::SYSTEM)) $criteria->add(LanguagePeer::SYSTEM, $this->system);
		if ($this->isColumnModified(LanguagePeer::IS_DEFAULT_PANEL)) $criteria->add(LanguagePeer::IS_DEFAULT_PANEL, $this->is_default_panel);
		if ($this->isColumnModified(LanguagePeer::IS_TRANSLATE_PANEL)) $criteria->add(LanguagePeer::IS_TRANSLATE_PANEL, $this->is_translate_panel);
		if ($this->isColumnModified(LanguagePeer::OPT_NAME)) $criteria->add(LanguagePeer::OPT_NAME, $this->opt_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(LanguagePeer::DATABASE_NAME);

		$criteria->add(LanguagePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCurrencyId($this->currency_id);

		$copyObj->setActiveImage($this->active_image);

		$copyObj->setInactiveImage($this->inactive_image);

		$copyObj->setShortcut($this->shortcut);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setActive($this->active);

		$copyObj->setLanguage($this->language);

		$copyObj->setIsTranslate($this->is_translate);

		$copyObj->setSystem($this->system);

		$copyObj->setIsDefaultPanel($this->is_default_panel);

		$copyObj->setIsTranslatePanel($this->is_translate_panel);

		$copyObj->setOptName($this->opt_name);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getLanguageHasDomains() as $relObj) {
				$copyObj->addLanguageHasDomain($relObj->copy($deepCopy));
			}

			foreach($this->getLanguageI18ns() as $relObj) {
				$copyObj->addLanguageI18n($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAttachments() as $relObj) {
				$copyObj->addProductHasAttachment($relObj->copy($deepCopy));
			}

			foreach($this->getSlideBanners() as $relObj) {
				$copyObj->addSlideBanner($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new LanguagePeer();
		}
		return self::$peer;
	}

	
	public function setCurrency($v)
	{


		if ($v === null) {
			$this->setCurrencyId('0');
		} else {
			$this->setCurrencyId($v->getId());
		}


		$this->aCurrency = $v;
	}


	
	public function getCurrency($con = null)
	{
		if ($this->aCurrency === null && ($this->currency_id !== null)) {
						$this->aCurrency = CurrencyPeer::retrieveByPK($this->currency_id, $con);

			
		}
		return $this->aCurrency;
	}

	
	public function initLanguageHasDomains()
	{
		if ($this->collLanguageHasDomains === null) {
			$this->collLanguageHasDomains = array();
		}
	}

	
	public function getLanguageHasDomains($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLanguageHasDomains === null) {
			if ($this->isNew()) {
			   $this->collLanguageHasDomains = array();
			} else {

				$criteria->add(LanguageHasDomainPeer::LANGUAGE_ID, $this->getId());

				LanguageHasDomainPeer::addSelectColumns($criteria);
				$this->collLanguageHasDomains = LanguageHasDomainPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(LanguageHasDomainPeer::LANGUAGE_ID, $this->getId());

				LanguageHasDomainPeer::addSelectColumns($criteria);
				if (!isset($this->lastLanguageHasDomainCriteria) || !$this->lastLanguageHasDomainCriteria->equals($criteria)) {
					$this->collLanguageHasDomains = LanguageHasDomainPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLanguageHasDomainCriteria = $criteria;
		return $this->collLanguageHasDomains;
	}

	
	public function countLanguageHasDomains($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(LanguageHasDomainPeer::LANGUAGE_ID, $this->getId());

		return LanguageHasDomainPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addLanguageHasDomain(LanguageHasDomain $l)
	{
		$this->collLanguageHasDomains[] = $l;
		$l->setLanguage($this);
	}

	
	public function initLanguageI18ns()
	{
		if ($this->collLanguageI18ns === null) {
			$this->collLanguageI18ns = array();
		}
	}

	
	public function getLanguageI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLanguageI18ns === null) {
			if ($this->isNew()) {
			   $this->collLanguageI18ns = array();
			} else {

				$criteria->add(LanguageI18nPeer::ID, $this->getId());

				LanguageI18nPeer::addSelectColumns($criteria);
				$this->collLanguageI18ns = LanguageI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(LanguageI18nPeer::ID, $this->getId());

				LanguageI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastLanguageI18nCriteria) || !$this->lastLanguageI18nCriteria->equals($criteria)) {
					$this->collLanguageI18ns = LanguageI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLanguageI18nCriteria = $criteria;
		return $this->collLanguageI18ns;
	}

	
	public function countLanguageI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(LanguageI18nPeer::ID, $this->getId());

		return LanguageI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addLanguageI18n(LanguageI18n $l)
	{
		$this->collLanguageI18ns[] = $l;
		$l->setLanguage($this);
	}

	
	public function initProductHasAttachments()
	{
		if ($this->collProductHasAttachments === null) {
			$this->collProductHasAttachments = array();
		}
	}

	
	public function getProductHasAttachments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
			   $this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
					$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;
		return $this->collProductHasAttachments;
	}

	
	public function countProductHasAttachments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

		return ProductHasAttachmentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAttachment(ProductHasAttachment $l)
	{
		$this->collProductHasAttachments[] = $l;
		$l->setLanguage($this);
	}


	
	public function getProductHasAttachmentsJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}


	
	public function getProductHasAttachmentsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::LANGUAGE_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}

	
	public function initSlideBanners()
	{
		if ($this->collSlideBanners === null) {
			$this->collSlideBanners = array();
		}
	}

	
	public function getSlideBanners($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collSlideBanners === null) {
			if ($this->isNew()) {
			   $this->collSlideBanners = array();
			} else {

				$criteria->add(SlideBannerPeer::LANGUAGE_ID, $this->getId());

				SlideBannerPeer::addSelectColumns($criteria);
				$this->collSlideBanners = SlideBannerPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(SlideBannerPeer::LANGUAGE_ID, $this->getId());

				SlideBannerPeer::addSelectColumns($criteria);
				if (!isset($this->lastSlideBannerCriteria) || !$this->lastSlideBannerCriteria->equals($criteria)) {
					$this->collSlideBanners = SlideBannerPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastSlideBannerCriteria = $criteria;
		return $this->collSlideBanners;
	}

	
	public function countSlideBanners($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(SlideBannerPeer::LANGUAGE_ID, $this->getId());

		return SlideBannerPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addSlideBanner(SlideBanner $l)
	{
		$this->collSlideBanners[] = $l;
		$l->setLanguage($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentLanguageI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentLanguageI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentLanguageI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = LanguageI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setLanguageI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setLanguageI18nForCulture(new LanguageI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setLanguageI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addLanguageI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Language.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseLanguage:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseLanguage::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 