<?php
/**
 * SOTESHOP/stLanguagePlugin
 *
 * Ten plik należy do aplikacji stLanguagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stLanguagePlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 11171 2011-02-21 13:07:13Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stLanguageBackendActions
 *
 * @package     stLanguagePlugin
 * @subpackage  actions
 */
class stLanguageBackendActions extends autoStLanguageBackendActions
{
	/**
	 * Zmiana języka na angielski
	 */
	public function executeChangeLanguage()
	{
		if ($this->getRequest()->hasParameter('name'))
		{
			if ($this->getRequest()->getParameter('name') == 'pl')
			{
				$this->getUser()->setCulture('pl_PL');
			} elseif ($this->getRequest()->getParameter('name') == 'en') {
				$this->getUser()->setCulture('en_US');
			}
		} else {
			$this->getUser()->setCulture('pl_PL');
		}

		/**
		 if($this->getUser()->isAuthenticated())
		 {
			$sfGuardUser = sfGuardUserPeer::retrieveByPK($this->getUser()->getGuardUser()->getId());
			$sfGuardUser->setLanguage($this->getUser()->getCulture());
			$sfGuardUser->save();
			}
			*/

		$this->getUser()->setAttribute('changedLanguage', true, stLanguage::SESSION_NAMESPACE);

		$this->redirect($this->getRequest()->getReferer());
	}

	/**
	 * Przeciążenie edycji 
	 */
	public function executeAdvancedEdit()
	{
		$hasError = false;
		if ($this->getRequest()->hasParameter('id'))
		{
			if ($this->getRequest()->getMethod() == sfRequest::POST)
			{
				$this->myLanguage = LanguagePeer::retrieveByPk($this->getRequest()->getParameter('id'));

				if(is_object($this->myLanguage)) {

					$userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.user.'.$this->myLanguage->getLanguage().'.xml';

					$filename = $this->getRequest()->getFileName('language[file]');
					if (!empty($filename))
					{
						$this->getRequest()->moveFile('language[file]', $userFile);

						$pakeweb = new stPakeWeb();
						if (!$pakeweb->run('xliff-split-files frontend '.$this->myLanguage->getLanguage()))
						{
							if ($pakeweb->error == "Parsing error")
							{
								$this->setFlash('warning', 'Plik z definicjami językowymi został wgrany, ale wystąpił błąd podczas jego przetwarzania.<br />Proszę sprawdzić czy plik nie zawiera błędów.');
								$hasError = true;
							} else {
								throw new Exception($pakeweb->error);
							}
						} else {
							$files = glob(sfConfig::get('sf_root_dir').'/cache/frontend/*/i18n/*/*.cache');
							foreach ($files as $file) @unlink($file);
						}
					}

					if ($this->getRequestParameter('language[delete_file]'))
					{
						if (file_exists($userFile))
						{
							unlink($userFile);
						}

						$pakeweb = new stPakeWeb();
						if (!$pakeweb->run('xliff-delete-user-files frontend '.$this->myLanguage->getLanguage()))
						{
							throw new Exception($pakeweb->error);
						}
					}
				}
			}
		}

		$this->processAdvancedEditForwardParameters();
		$this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStLanguageBackend/advanced_forward_parameters');

		$this->language = $this->getAdvancedLanguageOrCreate();

		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			$this->updateAdvancedLanguageFromRequest();

			$this->saveAdvancedLanguage($this->language);
			if (!$this->hasFlash('notice') && $hasError == false)
			{
				$this->setFlash('notice', 'Twoje zmiany zostały zapisane');
			}
			if ($this->getRequestParameter('save_and_add'))
			{
				return $this->redirect('stLanguageBackend/advancedCreate?id='.$this->forward_parameters['id']);
			}
			else if ($this->getRequestParameter('save_and_list'))
			{
				return $this->redirect('stLanguageBackend/advancedList?id='.$this->forward_parameters['id']);
			}
			else
			{
				return $this->redirect('stLanguageBackend/advancedEdit?language='.$this->getRequestParameter('language', 'pl_PL').'&id='.$this->forward_parameters['id'].'&id='.$this->language->getId());
			}
		}
		else
		{
			$this->labels = $this->getAdvancedLabels();
		}
	}

	/**
	 * Pobieranie pliku użytkownika 
	 */
	public function executeDownloadFrontendUserFile()
	{
		if ($this->getRequest()->hasParameter('language'))
		{
			$language = $this->getRequest()->getParameter('language');

			$userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.user.'.$language.'.xml';

			$this->setLayout(false);
			$response = $this->getContext()->getResponse();
			$response->setContentType("text/xml");
			//            $response->setContentType("application/octet-stream");
			$response->setHttpHeader('Content-Disposition', 'attachment; filename="messages.user.'.$language.'.xml"');

			$this->handle = fopen($userFile,'r');
		} else {
			$this->forward404('Nie podano parametru language');
		}
	}

	/**
	 * Pobieranie pliku oryginalnego
	 */
	public function executeDownloadFrontendShopFile()
	{
		if ($this->getRequest()->hasParameter('language'))
		{
			$language = $this->getRequest()->getParameter('language');

			$pakeweb = new stPakeWeb();
			if (!$pakeweb->run('xliff-merge-files frontend '.$language))
			{
				throw new Exception($pakeweb->error);
			}

			$userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.shop.'.$language.'.xml';

			$this->setLayout(false);
			$response = $this->getContext()->getResponse();
			$response->setContentType("text/xml");
			//            $response->setContentType("application/octet-stream");
			$response->setHttpHeader('Content-Disposition', 'attachment; filename="messages.shop.'.$language.'.xml"');

			$this->handle = fopen($userFile,'r');
		} else {
			$this->forward404('Nie podano parametru language');
		}
	}

	/**
	 * Pobieranie pliku do edycji
	 */
	public function executeDownloadEmptyFrontendShopFile()
	{
		if ($this->getRequest()->hasParameter('language'))
		{
			$language = $this->getRequest()->getParameter('language');

			$pakeweb = new stPakeWeb();
			if (!$pakeweb->run('xliff-merge-clear-files frontend '.$language))
			{
				throw new Exception($pakeweb->error);
			}

			$userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.shop.'.$language.'.xml';

			$this->setLayout(false);
			$response = $this->getContext()->getResponse();
			$response->setContentType("text/xml");
			//            $response->setContentType("application/octet-stream");
			$response->setHttpHeader('Content-Disposition', 'attachment; filename="messages.shop.'.$language.'.xml"');

			$this->handle = fopen($userFile,'r');
		} else {
			$this->forward404('Nie podano parametru language');
		}
	}

	/**
	 * Prazeciążenie executeDomainList
	 */
	public function executeDomainList()
	{
		parent::executeDomainList();
			
		$this->pager->getCriteria()->add(LanguageHasDomainPeer::LANGUAGE_ID, $this->forward_parameters['language_id']);
		$this->pager->init();
	}

	/**
	 * Przeciążenie getDomainLanguageHasDomainOrCreate
	 */
	protected function getDomainLanguageHasDomainOrCreate($id = 'id')
	{
		parent::getDomainLanguageHasDomainOrCreate($id);

		$this->language_has_domain->setLanguageId($this->forward_parameters['language_id']);
		return $this->language_has_domain;
	}

	/**
	 * Przeciążenie aktualizacji config'a
	 */
	protected function updateConfigFromRequest()
	{
		$config = $this->getRequestParameter('config');

		$c = new Criteria();
		$c->add(LanguagePeer::ID, $config['language_panel']);
		$language = LanguagePeer::doSelectOne($c);

		if(is_object($language))
		{
			$language->setIsDefaultPanel(true);
			$language->save();
				
			$this->getUser()->setCulture($language->getOriginalLanguage());
				
			$config = stConfig::getInstance($this->getContext(), 'stLanguagePlugin');
			$config->set('admin_language', $language->getOriginalLanguage());
			$config->save();
		}
	}
}