<?php
/** 
 * SOTESHOP/stLanguagePlugin 
 * 
 * Ten plik należy do aplikacji stLanguagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stLanguagePlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: components.class.php 9 2009-08-24 09:31:16Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/** 
 * Klasa stLanguageBackendActions
 *
 * @package     stLanguagePlugin
 * @subpackage  actions
 */
class stLanguageBackendComponents extends autoStLanguageBackendComponents
{
    /**
     * Wyświetlanie wyboru języków 
     */
    public function executeShowLanguages()
    {
        $c = new Criteria();
        $this->languages = LanguagePeer::doSelect($c);
    }
    
    /**
     * Wyświetlanie pobierania pliku do edycji
     */
    public function executeGetEmptyFrontendShopFile()
    {
        $this->hasOriginalFile = false;
        if ($this->getRequest()->hasParameter('id'))
        {
            $this->language = LanguagePeer::retrieveByPK($this->getRequest()->getParameter('id'));
            
            if ($this->language->getIsTranslate())
            {
                $this->hasOriginalFile = true;
            }
        }
    }
    
    /**
     * Wyświetlanie pobierania pliku użytkownika
     */
    public function executeGetFrontendUserFile()
    {
        $userFile = '';
        if ($this->getRequest()->hasParameter('id'))
        {
            $this->language = LanguagePeer::retrieveByPK($this->getRequest()->getParameter('id'));

            if (is_object($this->language))
            {
                $userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.user.'.$this->language->getLanguage().'.xml';
            }
        }

        $this->fileExist = false;
        if (file_exists($userFile)) $this->fileExist = true;
    }
    
    /**
     * Wyświetlanie przywracania oryginalnego pliku
     */
    public function executeRecoveryFrontendFile()
    {
        $userFile = '';
        if ($this->getRequest()->hasParameter('id'))
        {
            $this->language = LanguagePeer::retrieveByPK($this->getRequest()->getParameter('id'));

            if (is_object($this->language))
            {
                $userFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'i18n'.DIRECTORY_SEPARATOR.'messages.user.'.$this->language->getLanguage().'.xml';
            }
        }

        $this->fileExist = false;
        if (file_exists($userFile)) $this->fileExist = true;
    }
}