<?php
/** 
 * SOTESHOP/stLockPlugin 
 * 
 * Ten plik należy do aplikacji stLockPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stLockPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stLock.class.php 1249 2009-10-08 11:37:34Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/** 
 * Klasa stUnavailable
 *
 * @package     stLockPlugin
 * @subpackage  libs
 */
class stLock
{
    /** 
     * Sprawdzanie konfiguracji.
     *
     * @return   bool
     */
    public static function check($app = SF_APP, $environment = SF_ENVIRONMENT)
    {
        if ($environment == 'dev') return true;
        $file = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.'stLock'.ucfirst($app).'.lck';
        if(file_exists($file)) return false;
        return true; 
    }

    /**
     * Blokowanie sklepu
     *
     * @param string $app
     */
    public static function lock($app = SF_APP)
    {
        $file = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.'stLock'.ucfirst($app).'.lck';
        file_put_contents($file, '');
    }
    
    /**
     * Odblokowanie sklepu
     *
     * @param string $app
     */
    public static function unlock($app = SF_APP)
    {
        $file = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.'stLock'.ucfirst($app).'.lck';
        @unlink($file);
    }
}