<?php


abstract class BaseMailAccount extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $mail_smtp_profile_id;


	
	protected $username;


	
	protected $password;


	
	protected $email;


	
	protected $is_default = false;


	
	protected $name;

	
	protected $aMailSmtpProfile;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getMailSmtpProfileId()
    {

            return $this->mail_smtp_profile_id;
    }

    
    public function getUsername()
    {

            return $this->username;
    }

    
    public function getPassword()
    {

            return $this->password;
    }

    
    public function getEmail()
    {

            return $this->email;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getName()
    {

            return $this->name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = MailAccountPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = MailAccountPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = MailAccountPeer::ID;
        }

	} 
	
	public function setMailSmtpProfileId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->mail_smtp_profile_id !== $v) {
          $this->mail_smtp_profile_id = $v;
          $this->modifiedColumns[] = MailAccountPeer::MAIL_SMTP_PROFILE_ID;
        }

		if ($this->aMailSmtpProfile !== null && $this->aMailSmtpProfile->getId() !== $v) {
			$this->aMailSmtpProfile = null;
		}

	} 
	
	public function setUsername($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->username !== $v) {
          $this->username = $v;
          $this->modifiedColumns[] = MailAccountPeer::USERNAME;
        }

	} 
	
	public function setPassword($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->password !== $v) {
          $this->password = $v;
          $this->modifiedColumns[] = MailAccountPeer::PASSWORD;
        }

	} 
	
	public function setEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->email !== $v) {
          $this->email = $v;
          $this->modifiedColumns[] = MailAccountPeer::EMAIL;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = MailAccountPeer::IS_DEFAULT;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = MailAccountPeer::NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'MailAccount.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->mail_smtp_profile_id = $rs->getInt($startcol + 3);

      $this->username = $rs->getString($startcol + 4);

      $this->password = $rs->getString($startcol + 5);

      $this->email = $rs->getString($startcol + 6);

      $this->is_default = $rs->getBoolean($startcol + 7);

      $this->name = $rs->getString($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'MailAccount.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating MailAccount object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseMailAccount:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MailAccountPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			MailAccountPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseMailAccount:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'MailAccount.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseMailAccount:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(MailAccountPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(MailAccountPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MailAccountPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'MailAccount.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseMailAccount:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aMailSmtpProfile !== null) {
				if ($this->aMailSmtpProfile->isModified()) {
					$affectedRows += $this->aMailSmtpProfile->save($con);
				}
				$this->setMailSmtpProfile($this->aMailSmtpProfile);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = MailAccountPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += MailAccountPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aMailSmtpProfile !== null) {
				if (!$this->aMailSmtpProfile->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aMailSmtpProfile->getValidationFailures());
				}
			}


			if (($retval = MailAccountPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MailAccountPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getMailSmtpProfileId();
				break;
			case 4:
				return $this->getUsername();
				break;
			case 5:
				return $this->getPassword();
				break;
			case 6:
				return $this->getEmail();
				break;
			case 7:
				return $this->getIsDefault();
				break;
			case 8:
				return $this->getName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = MailAccountPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getMailSmtpProfileId(),
			$keys[4] => $this->getUsername(),
			$keys[5] => $this->getPassword(),
			$keys[6] => $this->getEmail(),
			$keys[7] => $this->getIsDefault(),
			$keys[8] => $this->getName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MailAccountPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setMailSmtpProfileId($value);
				break;
			case 4:
				$this->setUsername($value);
				break;
			case 5:
				$this->setPassword($value);
				break;
			case 6:
				$this->setEmail($value);
				break;
			case 7:
				$this->setIsDefault($value);
				break;
			case 8:
				$this->setName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = MailAccountPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setMailSmtpProfileId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setUsername($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setPassword($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setEmail($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsDefault($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setName($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(MailAccountPeer::DATABASE_NAME);

		if ($this->isColumnModified(MailAccountPeer::CREATED_AT)) $criteria->add(MailAccountPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(MailAccountPeer::UPDATED_AT)) $criteria->add(MailAccountPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(MailAccountPeer::ID)) $criteria->add(MailAccountPeer::ID, $this->id);
		if ($this->isColumnModified(MailAccountPeer::MAIL_SMTP_PROFILE_ID)) $criteria->add(MailAccountPeer::MAIL_SMTP_PROFILE_ID, $this->mail_smtp_profile_id);
		if ($this->isColumnModified(MailAccountPeer::USERNAME)) $criteria->add(MailAccountPeer::USERNAME, $this->username);
		if ($this->isColumnModified(MailAccountPeer::PASSWORD)) $criteria->add(MailAccountPeer::PASSWORD, $this->password);
		if ($this->isColumnModified(MailAccountPeer::EMAIL)) $criteria->add(MailAccountPeer::EMAIL, $this->email);
		if ($this->isColumnModified(MailAccountPeer::IS_DEFAULT)) $criteria->add(MailAccountPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(MailAccountPeer::NAME)) $criteria->add(MailAccountPeer::NAME, $this->name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(MailAccountPeer::DATABASE_NAME);

		$criteria->add(MailAccountPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setMailSmtpProfileId($this->mail_smtp_profile_id);

		$copyObj->setUsername($this->username);

		$copyObj->setPassword($this->password);

		$copyObj->setEmail($this->email);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setName($this->name);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new MailAccountPeer();
		}
		return self::$peer;
	}

	
	public function setMailSmtpProfile($v)
	{


		if ($v === null) {
			$this->setMailSmtpProfileId(NULL);
		} else {
			$this->setMailSmtpProfileId($v->getId());
		}


		$this->aMailSmtpProfile = $v;
	}


	
	public function getMailSmtpProfile($con = null)
	{
		if ($this->aMailSmtpProfile === null && ($this->mail_smtp_profile_id !== null)) {
						$this->aMailSmtpProfile = MailSmtpProfilePeer::retrieveByPK($this->mail_smtp_profile_id, $con);

			
		}
		return $this->aMailSmtpProfile;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'MailAccount.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseMailAccount:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseMailAccount::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 