<?php


abstract class BaseMailSmtpProfile extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $name;


	
	protected $host;


	
	protected $port = 25;


	
	protected $enc_type;

	
	protected $collMailAccounts;

	
	protected $lastMailAccountCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getHost()
    {

            return $this->host;
    }

    
    public function getPort()
    {

            return $this->port;
    }

    
    public function getEncType()
    {

            return $this->enc_type;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = MailSmtpProfilePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = MailSmtpProfilePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = MailSmtpProfilePeer::ID;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = MailSmtpProfilePeer::NAME;
        }

	} 
	
	public function setHost($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->host !== $v) {
          $this->host = $v;
          $this->modifiedColumns[] = MailSmtpProfilePeer::HOST;
        }

	} 
	
	public function setPort($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->port !== $v || $v === 25) {
          $this->port = $v;
          $this->modifiedColumns[] = MailSmtpProfilePeer::PORT;
        }

	} 
	
	public function setEncType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->enc_type !== $v) {
          $this->enc_type = $v;
          $this->modifiedColumns[] = MailSmtpProfilePeer::ENC_TYPE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'MailSmtpProfile.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->name = $rs->getString($startcol + 3);

      $this->host = $rs->getString($startcol + 4);

      $this->port = $rs->getInt($startcol + 5);

      $this->enc_type = $rs->getString($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'MailSmtpProfile.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating MailSmtpProfile object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseMailSmtpProfile:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MailSmtpProfilePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			MailSmtpProfilePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseMailSmtpProfile:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'MailSmtpProfile.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseMailSmtpProfile:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(MailSmtpProfilePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(MailSmtpProfilePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MailSmtpProfilePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'MailSmtpProfile.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseMailSmtpProfile:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = MailSmtpProfilePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += MailSmtpProfilePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collMailAccounts !== null) {
				foreach($this->collMailAccounts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = MailSmtpProfilePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collMailAccounts !== null) {
					foreach($this->collMailAccounts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MailSmtpProfilePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getName();
				break;
			case 4:
				return $this->getHost();
				break;
			case 5:
				return $this->getPort();
				break;
			case 6:
				return $this->getEncType();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = MailSmtpProfilePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getName(),
			$keys[4] => $this->getHost(),
			$keys[5] => $this->getPort(),
			$keys[6] => $this->getEncType(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MailSmtpProfilePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setName($value);
				break;
			case 4:
				$this->setHost($value);
				break;
			case 5:
				$this->setPort($value);
				break;
			case 6:
				$this->setEncType($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = MailSmtpProfilePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setHost($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setPort($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setEncType($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(MailSmtpProfilePeer::DATABASE_NAME);

		if ($this->isColumnModified(MailSmtpProfilePeer::CREATED_AT)) $criteria->add(MailSmtpProfilePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(MailSmtpProfilePeer::UPDATED_AT)) $criteria->add(MailSmtpProfilePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(MailSmtpProfilePeer::ID)) $criteria->add(MailSmtpProfilePeer::ID, $this->id);
		if ($this->isColumnModified(MailSmtpProfilePeer::NAME)) $criteria->add(MailSmtpProfilePeer::NAME, $this->name);
		if ($this->isColumnModified(MailSmtpProfilePeer::HOST)) $criteria->add(MailSmtpProfilePeer::HOST, $this->host);
		if ($this->isColumnModified(MailSmtpProfilePeer::PORT)) $criteria->add(MailSmtpProfilePeer::PORT, $this->port);
		if ($this->isColumnModified(MailSmtpProfilePeer::ENC_TYPE)) $criteria->add(MailSmtpProfilePeer::ENC_TYPE, $this->enc_type);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(MailSmtpProfilePeer::DATABASE_NAME);

		$criteria->add(MailSmtpProfilePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setName($this->name);

		$copyObj->setHost($this->host);

		$copyObj->setPort($this->port);

		$copyObj->setEncType($this->enc_type);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getMailAccounts() as $relObj) {
				$copyObj->addMailAccount($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new MailSmtpProfilePeer();
		}
		return self::$peer;
	}

	
	public function initMailAccounts()
	{
		if ($this->collMailAccounts === null) {
			$this->collMailAccounts = array();
		}
	}

	
	public function getMailAccounts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collMailAccounts === null) {
			if ($this->isNew()) {
			   $this->collMailAccounts = array();
			} else {

				$criteria->add(MailAccountPeer::MAIL_SMTP_PROFILE_ID, $this->getId());

				MailAccountPeer::addSelectColumns($criteria);
				$this->collMailAccounts = MailAccountPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(MailAccountPeer::MAIL_SMTP_PROFILE_ID, $this->getId());

				MailAccountPeer::addSelectColumns($criteria);
				if (!isset($this->lastMailAccountCriteria) || !$this->lastMailAccountCriteria->equals($criteria)) {
					$this->collMailAccounts = MailAccountPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastMailAccountCriteria = $criteria;
		return $this->collMailAccounts;
	}

	
	public function countMailAccounts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(MailAccountPeer::MAIL_SMTP_PROFILE_ID, $this->getId());

		return MailAccountPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addMailAccount(MailAccount $l)
	{
		$this->collMailAccounts[] = $l;
		$l->setMailSmtpProfile($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'MailSmtpProfile.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseMailSmtpProfile:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseMailSmtpProfile::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 