<?php
/**
 * SOTESHOP/stNavigationPlugin
 *
 * Ten plik należy do aplikacji stNavigationPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package stNavigationPlugin
 * @subpackage actions
 * @copyright SOTE (www.sote.pl)
 * @license http://www.sote.pl/license/sote (Professional License SOTE)
 * @version $Id: actions.class.php 16525 2011-12-19 12:19:16Z krzysiek $
 * @author Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stNavigationFrontendActions
 *
 * @package stNavigationPlugin
 * @subpackage actions
 */
class stNavigationFrontendActions extends stActions
{
    /**
     * Wyświetla historie ostatnio oglądanych produktów
     */
    public function executeShowHistory()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');
        $this->config->load();

        $stNavigation = stNavigation::getInstance($this->getContext());
        $products = $stNavigation->getLastViewedProducts();

        $productsId = array();
        foreach ($products as $product)
        {
            $productsId[] = $product['id'];
        }
        
        if (count($productsId) == 0) $this->redirect('@homepage');

        $c = new Criteria();
        $c->add(ProductPeer::ID, $productsId, Criteria::IN);
        $c->addDescendingOrderByColumn('Field('.ProductPeer::ID.','.implode(',', $productsId).')', Criteria::CUSTOM);
        stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stNavigationFrontendActions.postShowHistoryCriteria', array('criteria' => $c)));
        $pager = new sfPropelPager('Product');
        $pager->setCriteria($c);
        $pager->setPeerMethod('doSelect');
        $pager->setPage($this->getRequestParameter('page',1));

        switch ($this->config->get('list_type')) {
            case 'long':
                $listType = 'long_list';
                $this->listType = "listLongProduct";
                break;
            case 'short':
                $listType = 'short_list';
                $this->listType = "listShortProduct";
                break;
            case 'other':
                $listType = 'other_list';
                $this->listType = "listOther";
                break;
            default:
                $listType = 'long_list';
                $this->listType = "listLongProduct";
                break;
        }

        $pager->setMaxPerPage($this->config->get($listType));
        $pager->init();
        $this->products = $pager;
        
        $this->page = $this->getRequestParameter('page', '1');
        
        $stNavigation->addNavigationPathElement($this->getContext()->getI18n()->__('Historia oglądanych produktów'), false, true);
    }
}