<?php
/** 
 * SOTESHOP/stNewsPlugin 
 * 
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stNewsPlugin
 * @subpackage  configs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: config.php 156 2009-08-31 08:46:11Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Włączanie modułów
 */
stPluginHelper::addEnableModule('stNewsBackend', 'backend');
//stPluginHelper::addEnableModule('stNewsGroupBackend', 'backend');
//stPluginHelper::addEnableModule('stNewsGroupHasNewsBackend', 'backend');

stPluginHelper::addEnableModule('stNewsFrontend', 'frontend');

/** 
 * Dodawanie routingów
 */
stPluginHelper::addRouting('stNewsPlugin', '/news/:action/*', 'stNewsBackend', null, 'backend');
stPluginHelper::addRouting('stNewsPluginDefault', '/news', 'stNewsBackend', 'list', 'backend');
stPluginHelper::addRouting('stNewsGroupBackend', '/news_group/:action/*', 'stNewsGroupBackend', null, 'backend');
stPluginHelper::addRouting('stNewsGroupHasNewsBackend', '/news_group_has_news/:action/*', 'stNewsGroupHasNewsBackend', null, 'backend');

stPluginHelper::addRouting('stNewsFrontend', '/news/:action/*', 'stNewsFrontend', null, 'frontend');

sfMixer::register('BaseNews:save:post', array('stNewsCache', 'deleteCacheNews'));
sfMixer::register('BaseNews:delete:post', array('stNewsCache', 'deleteCacheNews'));