<?php
/** 
 * SOTESHOP/stNewsPlugin 
 * 
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stNewsPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: News.php 10242 2011-01-13 14:16:32Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Klasa News
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 */
class News extends BaseNews
{
    
    /** 
     * Pobieranie nazwy informacji
     *
     * @return  string      nazwa informacji
     */
    public function __toString()
    {
        return $this->getName();
    }
    
    /**
     * Przeciążenie hydrate
     *
     * @param ResultSet $rs
     * @param int $startcol
     * @return object
     */
    public function hydrate(ResultSet $rs, $startcol = 1)
    {
        $this->setCulture(stLanguage::getHydrateCulture());
        return parent::hydrate($rs, $startcol);
    }
    
    /**
     * Przeciążenie getName
     *
     * @return string
     */
    public function getName()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);   
        }   
        $v = parent::getName();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }
    
    /**
     * Przeciążenie setName
     * 
     * @param string $v
     */
    public function setName($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }
        
        parent::setName($v);
    }
    
    /**
     * Przeciążenie getDescription
     *
     * @return string
     */
    public function getDescription()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);   
        }   
        $v = parent::getDescription();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }
    
    /**
     * Przeciążenie setDescription
     * 
     * @param string $v
     */
    public function setDescription($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }
        
        parent::setDescription($v);
    }
    
    /**
     * Przeciążenie getLongDescription
     *
     * @return string
     */
    public function getLongDescription()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);   
        }   
        $v = parent::getLongDescription();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }
    
    /**
     * Przeciążenie setLongDescription
     * 
     * @param string $v
     */
    public function setLongDescription($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }
        
        parent::setLongDescription($v);
    }
    
    
    /** 
     * Pobieranie obiektu NewsGroup
     *
     * @return  object      obiekt WebpageGroup
     */
    public function getNewsGroup()
    {
        $c = new Criteria();
        $c->add(NewsGroupHasNewsPeer::NEWS_ID,$this->getId());
        $c->addJoin(NewsGroupHasNewsPeer::NEWS_GROUP_ID,NewsGroupPeer::ID);
        $this->newsGroup = NewsGroupPeer::doSelect($c);
        return $this->newsGroup;
    }
    
    /** 
     * Pobieranie obiektu NewsGroupHasNews
     */
    public function getNewsGroupHasNews()
    {
        $this->newsGroup = NewsGroupHasNewsPeer::doSelectJoinAll();
    }
    
    /** 
     * Zapisuje wartości domyślne dla zapisanej informacji
     *
     * @param   string      domyślna           wartość informacji $news  
     */
    public function setDefaultPages($news)
    {
         if ($news=="NONE") $news=NULL;         
         $this->setNews($news);
    }
    
    /** 
     * Pobiera zawartość przyciętą do określonej długości.
     * Funkcja nie dzieli słów.
     *
     * @param   integer     $length             Ilość znaków  
     * @return  string      Przycięty tekst  
     */
    public function getDescriptionTrimed($length = 50)
    {        
        $description = $this->getDescription();
        $description = strip_tags($description);
        
        //echo "[".$content."]"; die();
        $descriptionLength = strlen($description);
        
        //sprawdzenie czy istnieje potrzeba przyciecia
        if($descriptionLength <= $length)
        {            
            return strip_tags($this->getDescription());
        }
        
        $content = trim(wordwrap($description, $length, "\n"));
        $table = explode("\n", $description);
        
        if(count($table) > 0)
        {
            return $table[0]."..."; 
        } 
        return "";      
    }
}
