<?php
/**
 * SOTESHOP/stNewsPlugin
 *
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: NewsGroup.php 10242 2011-01-13 14:16:32Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/**
 * Klasa NewsGroup
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 */
class NewsGroup extends BaseNewsGroup
{
    /**
     * Pobieranie nazwy grupy
     *
     * @return   string
     */
    public function __toString()
    {
        return $this->getName();
    }

    /**
     * Zapisuje wartości domyślne dla zapisanej informacji
     *
     * @param   string      domyślna           wartość informacji $news  
     */
    public function setDefaultGroupNews($group_news)
    {
        if ($group_news=="NONE") $group_news=NULL;
        $this->setGroupNews($group_news);
    }

    /**
     * Przeciążenie hydrate
     *
     * @param ResultSet $rs
     * @param int $startcol
     * @return object
     */
    public function hydrate(ResultSet $rs, $startcol = 1)
    {
        $this->setCulture(stLanguage::getHydrateCulture());
        return parent::hydrate($rs, $startcol);
    }

    /**
     * Przeciążenie getName
     *
     * @return string
     */
    public function getName()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);   
        }   
        $v = parent::getName();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }
    
    /**
     * Przeciążenie setName
     * 
     * @param string $v
     */
    public function setName($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }
        
        parent::setName($v);
    }

}