<?php
/**
 * SOTESHOP/stNewsPlugin
 *
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: NewsPeer.php 10530 2011-01-26 16:56:34Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/**
 * Klasa NewsPeer
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 */
class NewsPeer extends BaseNewsPeer
{
	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		NewsPeer::addSelectColumns($c);

		$startcol = (NewsPeer::NUM_COLUMNS - NewsPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		NewsI18nPeer::addSelectColumns($c);

		$c->addJoin(NewsPeer::ID, sprintf("%s AND %s = '%s'", NewsI18nPeer::ID, NewsI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while($rs->next())
		{
			$omClass = NewsPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = NewsI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setNewsI18nForCulture($obj2, $culture);
			$obj2->setNews($obj1);

			$results[] = $obj1;
		}
		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(NewsI18nPeer::ID, NewsPeer::ID);

		$c->add(NewsI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
}