<?php


abstract class BaseNews extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $active;


	
	protected $opt_name;


	
	protected $opt_description;


	
	protected $opt_long_description;

	
	protected $collNewsGroupHasNewss;

	
	protected $lastNewsGroupHasNewsCriteria = null;

	
	protected $collNewsI18ns;

	
	protected $lastNewsI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getOptLongDescription()
    {

            return $this->opt_long_description;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsPeer::ID;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = NewsPeer::ACTIVE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = NewsPeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = NewsPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setOptLongDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_long_description !== $v) {
          $this->opt_long_description = $v;
          $this->modifiedColumns[] = NewsPeer::OPT_LONG_DESCRIPTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'News.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->active = $rs->getBoolean($startcol + 3);

      $this->opt_name = $rs->getString($startcol + 4);

      $this->opt_description = $rs->getString($startcol + 5);

      $this->opt_long_description = $rs->getString($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'News.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating News object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNews:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNews:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'News.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNews:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'News.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNews:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collNewsGroupHasNewss !== null) {
				foreach($this->collNewsGroupHasNewss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collNewsI18ns !== null) {
				foreach($this->collNewsI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = NewsPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNewsGroupHasNewss !== null) {
					foreach($this->collNewsGroupHasNewss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collNewsI18ns !== null) {
					foreach($this->collNewsI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getActive();
				break;
			case 4:
				return $this->getOptName();
				break;
			case 5:
				return $this->getOptDescription();
				break;
			case 6:
				return $this->getOptLongDescription();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getActive(),
			$keys[4] => $this->getOptName(),
			$keys[5] => $this->getOptDescription(),
			$keys[6] => $this->getOptLongDescription(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setActive($value);
				break;
			case 4:
				$this->setOptName($value);
				break;
			case 5:
				$this->setOptDescription($value);
				break;
			case 6:
				$this->setOptLongDescription($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setActive($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptDescription($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptLongDescription($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsPeer::CREATED_AT)) $criteria->add(NewsPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsPeer::UPDATED_AT)) $criteria->add(NewsPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsPeer::ID)) $criteria->add(NewsPeer::ID, $this->id);
		if ($this->isColumnModified(NewsPeer::ACTIVE)) $criteria->add(NewsPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(NewsPeer::OPT_NAME)) $criteria->add(NewsPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(NewsPeer::OPT_DESCRIPTION)) $criteria->add(NewsPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(NewsPeer::OPT_LONG_DESCRIPTION)) $criteria->add(NewsPeer::OPT_LONG_DESCRIPTION, $this->opt_long_description);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsPeer::DATABASE_NAME);

		$criteria->add(NewsPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setActive($this->active);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setOptLongDescription($this->opt_long_description);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getNewsGroupHasNewss() as $relObj) {
				$copyObj->addNewsGroupHasNews($relObj->copy($deepCopy));
			}

			foreach($this->getNewsI18ns() as $relObj) {
				$copyObj->addNewsI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsPeer();
		}
		return self::$peer;
	}

	
	public function initNewsGroupHasNewss()
	{
		if ($this->collNewsGroupHasNewss === null) {
			$this->collNewsGroupHasNewss = array();
		}
	}

	
	public function getNewsGroupHasNewss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsGroupHasNewss === null) {
			if ($this->isNew()) {
			   $this->collNewsGroupHasNewss = array();
			} else {

				$criteria->add(NewsGroupHasNewsPeer::NEWS_ID, $this->getId());

				NewsGroupHasNewsPeer::addSelectColumns($criteria);
				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsGroupHasNewsPeer::NEWS_ID, $this->getId());

				NewsGroupHasNewsPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsGroupHasNewsCriteria) || !$this->lastNewsGroupHasNewsCriteria->equals($criteria)) {
					$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsGroupHasNewsCriteria = $criteria;
		return $this->collNewsGroupHasNewss;
	}

	
	public function countNewsGroupHasNewss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsGroupHasNewsPeer::NEWS_ID, $this->getId());

		return NewsGroupHasNewsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsGroupHasNews(NewsGroupHasNews $l)
	{
		$this->collNewsGroupHasNewss[] = $l;
		$l->setNews($this);
	}


	
	public function getNewsGroupHasNewssJoinNewsGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsGroupHasNewss === null) {
			if ($this->isNew()) {
				$this->collNewsGroupHasNewss = array();
			} else {

				$criteria->add(NewsGroupHasNewsPeer::NEWS_ID, $this->getId());

				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelectJoinNewsGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsGroupHasNewsPeer::NEWS_ID, $this->getId());

			if (!isset($this->lastNewsGroupHasNewsCriteria) || !$this->lastNewsGroupHasNewsCriteria->equals($criteria)) {
				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelectJoinNewsGroup($criteria, $con);
			}
		}
		$this->lastNewsGroupHasNewsCriteria = $criteria;

		return $this->collNewsGroupHasNewss;
	}

	
	public function initNewsI18ns()
	{
		if ($this->collNewsI18ns === null) {
			$this->collNewsI18ns = array();
		}
	}

	
	public function getNewsI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsI18ns === null) {
			if ($this->isNew()) {
			   $this->collNewsI18ns = array();
			} else {

				$criteria->add(NewsI18nPeer::ID, $this->getId());

				NewsI18nPeer::addSelectColumns($criteria);
				$this->collNewsI18ns = NewsI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsI18nPeer::ID, $this->getId());

				NewsI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsI18nCriteria) || !$this->lastNewsI18nCriteria->equals($criteria)) {
					$this->collNewsI18ns = NewsI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsI18nCriteria = $criteria;
		return $this->collNewsI18ns;
	}

	
	public function countNewsI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsI18nPeer::ID, $this->getId());

		return NewsI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsI18n(NewsI18n $l)
	{
		$this->collNewsI18ns[] = $l;
		$l->setNews($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentNewsI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentNewsI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentNewsI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentNewsI18n()->setDescription($value);
  }

  public function getLongDescription()
  {
    $obj = $this->getCurrentNewsI18n();

    return ($obj ? $obj->getLongDescription() : null);
  }

  public function setLongDescription($value)
  {
    $this->getCurrentNewsI18n()->setLongDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentNewsI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = NewsI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setNewsI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setNewsI18nForCulture(new NewsI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setNewsI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addNewsI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'News.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNews:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNews::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 