<?php


abstract class BaseNewsGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $group_news;


	
	protected $opt_name;

	
	protected $collNewsGroupHasNewss;

	
	protected $lastNewsGroupHasNewsCriteria = null;

	
	protected $collNewsGroupI18ns;

	
	protected $lastNewsGroupI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getGroupNews()
    {

            return $this->group_news;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsGroupPeer::ID;
        }

	} 
	
	public function setGroupNews($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->group_news !== $v) {
          $this->group_news = $v;
          $this->modifiedColumns[] = NewsGroupPeer::GROUP_NEWS;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = NewsGroupPeer::OPT_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->group_news = $rs->getString($startcol + 3);

      $this->opt_name = $rs->getString($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsGroup.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collNewsGroupHasNewss !== null) {
				foreach($this->collNewsGroupHasNewss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collNewsGroupI18ns !== null) {
				foreach($this->collNewsGroupI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = NewsGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNewsGroupHasNewss !== null) {
					foreach($this->collNewsGroupHasNewss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collNewsGroupI18ns !== null) {
					foreach($this->collNewsGroupI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getGroupNews();
				break;
			case 4:
				return $this->getOptName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getGroupNews(),
			$keys[4] => $this->getOptName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setGroupNews($value);
				break;
			case 4:
				$this->setOptName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setGroupNews($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptName($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsGroupPeer::CREATED_AT)) $criteria->add(NewsGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsGroupPeer::UPDATED_AT)) $criteria->add(NewsGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsGroupPeer::ID)) $criteria->add(NewsGroupPeer::ID, $this->id);
		if ($this->isColumnModified(NewsGroupPeer::GROUP_NEWS)) $criteria->add(NewsGroupPeer::GROUP_NEWS, $this->group_news);
		if ($this->isColumnModified(NewsGroupPeer::OPT_NAME)) $criteria->add(NewsGroupPeer::OPT_NAME, $this->opt_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsGroupPeer::DATABASE_NAME);

		$criteria->add(NewsGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setGroupNews($this->group_news);

		$copyObj->setOptName($this->opt_name);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getNewsGroupHasNewss() as $relObj) {
				$copyObj->addNewsGroupHasNews($relObj->copy($deepCopy));
			}

			foreach($this->getNewsGroupI18ns() as $relObj) {
				$copyObj->addNewsGroupI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsGroupPeer();
		}
		return self::$peer;
	}

	
	public function initNewsGroupHasNewss()
	{
		if ($this->collNewsGroupHasNewss === null) {
			$this->collNewsGroupHasNewss = array();
		}
	}

	
	public function getNewsGroupHasNewss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsGroupHasNewss === null) {
			if ($this->isNew()) {
			   $this->collNewsGroupHasNewss = array();
			} else {

				$criteria->add(NewsGroupHasNewsPeer::NEWS_GROUP_ID, $this->getId());

				NewsGroupHasNewsPeer::addSelectColumns($criteria);
				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsGroupHasNewsPeer::NEWS_GROUP_ID, $this->getId());

				NewsGroupHasNewsPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsGroupHasNewsCriteria) || !$this->lastNewsGroupHasNewsCriteria->equals($criteria)) {
					$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsGroupHasNewsCriteria = $criteria;
		return $this->collNewsGroupHasNewss;
	}

	
	public function countNewsGroupHasNewss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsGroupHasNewsPeer::NEWS_GROUP_ID, $this->getId());

		return NewsGroupHasNewsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsGroupHasNews(NewsGroupHasNews $l)
	{
		$this->collNewsGroupHasNewss[] = $l;
		$l->setNewsGroup($this);
	}


	
	public function getNewsGroupHasNewssJoinNews($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsGroupHasNewss === null) {
			if ($this->isNew()) {
				$this->collNewsGroupHasNewss = array();
			} else {

				$criteria->add(NewsGroupHasNewsPeer::NEWS_GROUP_ID, $this->getId());

				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelectJoinNews($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsGroupHasNewsPeer::NEWS_GROUP_ID, $this->getId());

			if (!isset($this->lastNewsGroupHasNewsCriteria) || !$this->lastNewsGroupHasNewsCriteria->equals($criteria)) {
				$this->collNewsGroupHasNewss = NewsGroupHasNewsPeer::doSelectJoinNews($criteria, $con);
			}
		}
		$this->lastNewsGroupHasNewsCriteria = $criteria;

		return $this->collNewsGroupHasNewss;
	}

	
	public function initNewsGroupI18ns()
	{
		if ($this->collNewsGroupI18ns === null) {
			$this->collNewsGroupI18ns = array();
		}
	}

	
	public function getNewsGroupI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsGroupI18ns === null) {
			if ($this->isNew()) {
			   $this->collNewsGroupI18ns = array();
			} else {

				$criteria->add(NewsGroupI18nPeer::ID, $this->getId());

				NewsGroupI18nPeer::addSelectColumns($criteria);
				$this->collNewsGroupI18ns = NewsGroupI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsGroupI18nPeer::ID, $this->getId());

				NewsGroupI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsGroupI18nCriteria) || !$this->lastNewsGroupI18nCriteria->equals($criteria)) {
					$this->collNewsGroupI18ns = NewsGroupI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsGroupI18nCriteria = $criteria;
		return $this->collNewsGroupI18ns;
	}

	
	public function countNewsGroupI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsGroupI18nPeer::ID, $this->getId());

		return NewsGroupI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsGroupI18n(NewsGroupI18n $l)
	{
		$this->collNewsGroupI18ns[] = $l;
		$l->setNewsGroup($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentNewsGroupI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentNewsGroupI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentNewsGroupI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = NewsGroupI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setNewsGroupI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setNewsGroupI18nForCulture(new NewsGroupI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setNewsGroupI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addNewsGroupI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 