<?php


abstract class BaseNewsGroupPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_news_group';

	
	const CLASS_DEFAULT = 'plugins.stNewsPlugin.lib.model.NewsGroup';

	
	const NUM_COLUMNS = 5;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_news_group.CREATED_AT';

	
	const UPDATED_AT = 'st_news_group.UPDATED_AT';

	
	const ID = 'st_news_group.ID';

	
	const GROUP_NEWS = 'st_news_group.GROUP_NEWS';

	
	const OPT_NAME = 'st_news_group.OPT_NAME';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'GroupNews', 'OptName', ),
		BasePeer::TYPE_COLNAME => array (NewsGroupPeer::CREATED_AT, NewsGroupPeer::UPDATED_AT, NewsGroupPeer::ID, NewsGroupPeer::GROUP_NEWS, NewsGroupPeer::OPT_NAME, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'group_news', 'opt_name', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'GroupNews' => 3, 'OptName' => 4, ),
		BasePeer::TYPE_COLNAME => array (NewsGroupPeer::CREATED_AT => 0, NewsGroupPeer::UPDATED_AT => 1, NewsGroupPeer::ID => 2, NewsGroupPeer::GROUP_NEWS => 3, NewsGroupPeer::OPT_NAME => 4, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'group_news' => 3, 'opt_name' => 4, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stNewsPlugin.lib.model.map.NewsGroupMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = NewsGroupPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(NewsGroupPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(NewsGroupPeer::CREATED_AT);

		$criteria->addSelectColumn(NewsGroupPeer::UPDATED_AT);

		$criteria->addSelectColumn(NewsGroupPeer::ID);

		$criteria->addSelectColumn(NewsGroupPeer::GROUP_NEWS);

		$criteria->addSelectColumn(NewsGroupPeer::OPT_NAME);

	}

	const COUNT = 'COUNT(st_news_group.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_news_group.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(NewsGroupPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(NewsGroupPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = NewsGroupPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = NewsGroupPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return NewsGroupPeer::populateObjects(NewsGroupPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsGroupPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseNewsGroupPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			NewsGroupPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = NewsGroupPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      NewsGroupPeer::addSelectColumns($c);
      $startcol = (NewsGroupPeer::NUM_COLUMNS - NewsGroupPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      NewsGroupI18nPeer::addSelectColumns($c);

      $c->addJoin(NewsGroupPeer::ID, sprintf('%s AND %s = \'%s\'', NewsGroupI18nPeer::ID, NewsGroupI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = NewsGroupPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = NewsGroupI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setNewsGroupI18nForCulture($obj2, $culture);
         $obj2->setNewsGroup($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return NewsGroupPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsGroupPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseNewsGroupPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(NewsGroupPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseNewsGroupPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseNewsGroupPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsGroupPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseNewsGroupPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(NewsGroupPeer::ID);
			$selectCriteria->add(NewsGroupPeer::ID, $criteria->remove(NewsGroupPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseNewsGroupPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseNewsGroupPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += NewsGroupPeer::doOnDeleteCascade(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(NewsGroupPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(NewsGroupPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof NewsGroup) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(NewsGroupPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += NewsGroupPeer::doOnDeleteCascade($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = NewsGroupPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(NewsGroupI18nPeer::ID, $obj->getId());
			$affectedRows += NewsGroupI18nPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	public static function doValidate(NewsGroup $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(NewsGroupPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(NewsGroupPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(NewsGroupPeer::DATABASE_NAME, NewsGroupPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = NewsGroupPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(NewsGroupPeer::DATABASE_NAME);

		$criteria->add(NewsGroupPeer::ID, $pk);


		$v = NewsGroupPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(NewsGroupPeer::ID, $pks, Criteria::IN);
			$objs = NewsGroupPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseNewsGroupPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stNewsPlugin.lib.model.map.NewsGroupMapBuilder');
}
