<?php
/** 
 * SOTESHOP/stNewsPlugin 
 * 
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stNewsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: components.class.php 156 2009-08-31 08:46:11Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Klasa stNewsFrontendComponents
 *
 * @package     stNewsPlugin
 * @subpackage  actions
 */
class stNewsFrontendComponents extends sfComponents
{
    /** 
     * Wyświetla wiadomość należącą
     * do grup przekazanej w parametrze.
     */
    public function executeIndex()
    {
        $config = stConfig::getInstance(sfContext::getInstance(), 'stNewsBackend');
        $config->load();


        if($config->get('active')==0)
        {
            return sfView::NONE;
        }

        $this->config = $config;

        $this->smarty = new stSmarty('stNewsFrontend');
        if ($this->params)
        {
            $group=$this->params;
        }
        elseif ($this->group)
        {
            $group=$this->group;
        }
        else return;
        $this->group=$group;
        $c = new Criteria();
        //        $c->add(NewsGroupPeer::GROUP_NEWS, $group);
        //        $c->addJoin(NewsPeer::ID, NewsGroupHasNewsPeer::NEWS_ID);
        //        $c->addJoin(NewsGroupHasNewsPeer::NEWS_GROUP_ID, NewsGroupPeer::ID);
        $c->add(NewsPeer::ACTIVE, 1);
        if($config->get('date')==1)
        {
            $c->addDescendingOrderByColumn(NewsPeer::UPDATED_AT);
        }
        else
        {
            $c->addDescendingOrderByColumn(NewsPeer::CREATED_AT);
        }

        if($newsy = NewsPeer::doSelect($c))
        {
            $c = new Criteria();
            $c->add(NewsGroupPeer::GROUP_NEWS, $group);
            $this->group_name = NewsGroupPeer::doSelectOne($c)->getName();

            if($config->get('columns')==1)
            {
                $all_newsy['central'] = $newsy;
                $this->newsy = $all_newsy;
            }
            else
            {
                foreach($newsy as $index => $news)
                {
                    if($config->get('sort')=='vertical')
                    {
                        $side = ($side=='left') ? 'right' : 'left';
                    }
                    else
                    {
                        $side = ($index <= (count($newsy)-1)/2) ? 'left' : 'right';
                    }
                    $sorted_newsy[$side][] = $news;
                }
                $this->newsy = $sorted_newsy;
            }
        }
        else
        {
            return sfView::NONE;
        }
    }
}
