<?php
/** 
 * SOTESHOP/stNewsPlugin 
 * 
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stNewsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 156 2009-08-31 08:46:11Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Klasa stNewsGroupBackendActions
 *
 * @package     stNewsPlugin
 * @subpackage  actions
 */
class stNewsGroupBackendActions extends autostNewsGroupBackendActions
{
    public function executeConfig()
    {
        $request = sfContext::getInstance()->getRequest();
        if($request->getMethod()==sfRequest::POST && !$request->hasErrors())
        {
            $group_news = $request->getParameter('group_news');
            if(!empty($group_news))
            {
                foreach($group_news as $index => $item)
                {
                    $index = explode('_', $index);
                    if(empty($new_group_news[$index[0]]))
                    {
                        $new_group_news[$index[0]] = array($index[1] => $item);   
                    }
                    else
                    {
                        $new_group_news[$index[0]] = array_merge($new_group_news[$index[0]], array($index[1] => $item));    
                    }
                    
                }
                $group_news = array('group_news' => $new_group_news);
                $yml = sfYaml::dump($group_news);
                $ymlFile = SF_ROOT_DIR . DIRECTORY_SEPARATOR . sfConfig::get('sf_plugins_dir_name'). DIRECTORY_SEPARATOR. 'stNewsPlugin' . DIRECTORY_SEPARATOR . sfConfig::get('sf_config_dir_name') . DIRECTORY_SEPARATOR . "default_news.yml";
                $fp = fopen($ymlFile, "w+");
                flock($fp,LOCK_EX);
                fwrite($fp, $yml);
                flock($fp,LOCK_UN);
                fclose($fp);  
                $this->setFlash('notice','Zmiany zostały zapisane');    
            }
            
        }
        
        $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStNewsGroupBackend/forward_parameters');
    }
    
    public function validateConfig()
    {
        $request = sfContext::getInstance()->getRequest();
        $group_news = $request->getParameter('group_news');
        foreach($group_news as $index => $item)
        {
            $index = explode('_', $index);
            if($index[1]=='MAX')
            {
                $numberValidator = new sfNumberValidator();
                $numberValidator->initialize(sfContext::getInstance(), array('nan_error' => 'Wprowadź liczbę'));
                $error = 'Wprowadź liczbę';
                
                if(!$numberValidator->execute($item, $error) || trim($item)=='')
                {
                    $request->setError($index[0].'_MAX',$error);
                }
            }
        }
        return sfView::SUCCESS;
    }

}
