<?php
/** 
 * SOTESHOP/stNewsPlugin 
 * 
 * Ten plik należy do aplikacji stNewsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stNewsPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stPluginNewsGroupBackendComponents.class.php 156 2009-08-31 08:46:11Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * stNewsGroupBackend components. Dodaje wybór domyślnych wartości stron.
 *
 * @package stNewsPlugin
 * @subpackage stNewsGroupBackend
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>  
 */

/** 
 * klasa stPluginNewsGroupBackendComponents
 *
 * @package     stNewsPlugin
 * @subpackage  libs
 */
class stPluginNewsGroupBackendComponents extends autoStNewsGroupBackendComponents
{
    public function executeAllGroupNews()
    {
        $fileymlRoot = SF_ROOT_DIR . DIRECTORY_SEPARATOR . sfConfig::get('sf_plugins_dir_name'). DIRECTORY_SEPARATOR. 'stNewsPlugin' . DIRECTORY_SEPARATOR . sfConfig::get('sf_config_dir_name') . DIRECTORY_SEPARATOR . "default_news.yml";
        $yml = sfYaml::load($fileymlRoot);
        $this->all_group_news = $yml['group_news'];  
    }
    
    /** 
     * Dostarcza tablicę dla wyboru domyślnych wartości strony
     */
    public function executeDefaultGroupNews()
    {
        // pobiera wartości domyślne dla strony z pliku konfiguracyjnego
        $fileymlRoot = SF_ROOT_DIR . DIRECTORY_SEPARATOR . sfConfig::get('sf_plugins_dir_name'). DIRECTORY_SEPARATOR. 'stNewsPlugin' . DIRECTORY_SEPARATOR . sfConfig::get('sf_config_dir_name') . DIRECTORY_SEPARATOR . "default_news.yml";
        $yml = sfYaml::load($fileymlRoot);
        $default_group_news = $yml['group_news'];
        foreach($default_group_news as $index => $group_news)
        {
            $default_group_news[$index] = $group_news['NAME'];
        }
        $chosen_default_group_news=$this->getChosenDefaultGroupNews($this->getRequestParameter("id"));           
        $default_group_news=(array_diff_key($default_group_news, $chosen_default_group_news));
        $this->default_group_news = $default_group_news; 
    }
    
    /** 
     * Pobiera już wybrane wartości domyślne
     *
     * @param   integer     id                  edytowanej strony $id
     * @return  array       tablicę z wybranymi już wcześniej wartościami  
     */
    private function getChosenDefaultGroupNews($id)
    {
            $c = new Criteria();
            if ($id)
            {
                $c->add(NewsGroupPeer::ID, $id, Criteria::NOT_EQUAL);
            }
            $groups_news = NewsGroupPeer::doSelect($c);
            $chosen_default_group_news=array();
            foreach ($groups_news as $group_news_item)
            {
                if($group_news_item->getGroupNews())
                {
                    array_push($chosen_default_group_news,$group_news_item->getGroupNews());
                }
            }
        $chosen_default_group_news=array_flip($chosen_default_group_news);
        return $chosen_default_group_news;
    }
}

?>
