<?php use_helper('I18N', 'Date', 'Text', 'stAdminGenerator', 'Validation') ?>


    
<div id="sf_admin_content">
    <?php st_include_partial('config_messages', array('forward_parameters' => $forward_parameters, 'labels' => $all_group_news)) ?>
    
    <?php echo form_tag('stNewsGroupBackend/config', array(
        'id'        => 'sf_admin_edit_form',
        'name'      => 'sf_admin_edit_form',
        'multipart' => true)) ?>
    
    <fieldset id="sf_fieldset_none" class="">
        <table cellspacing="0" class="st_record_list">
            <thead>
                <tr> 
                    <th>&nbsp;</th>
                    <th id="sf_admin_list_th_name"><?php echo __('Nazwa grupy') ?></th>
                    <th id="sf_admin_list_th_max"><?php echo __('Maksymalna ilość newsów') ?></th>
                    <th>&nbsp;</th>          
                </tr>
            </thead>
            <tbody>
            <?php foreach($all_group_news as $index => $group_news): ?>
                <tr> 
                    <?php echo input_hidden_tag('group_news['.$index.'_NAME]', !empty($group_news['NAME']) ? $group_news['NAME'] : '') ?>
                    <?php if($index != 'NONE'): ?>
                        <td>&nbsp;</td>
                        <?php $value = $group_news['NAME'] ?>
                        <td><?php echo $value ? $value : __('-') ?></td>
                        <?php $value = input_tag('group_news['.$index.'_MAX]',!empty($group_news['MAX']) ? $group_news['MAX'] : '', array('size' => '2', 'maxlength' => '2')) ?>
                        <td>
                            <div class="content<?php if ($sf_request->hasError($index.'_MAX')): ?> form-error<?php endif; ?>">
                            <?php if ($sf_request->hasError($index.'_MAX')): ?>
                                <?php echo form_error($index.'_MAX', array('class' => 'form-error-msg')) ?>
                            <?php endif; ?>
                            <?php echo $value ? $value : __('-')  ?>
                        </td>
                        <td>&nbsp;</td>
                    <?php endif ?>
                </tr>
            <?php endforeach ?>
            </tbody>
            <tfoot>
                <tr>   
                    <th colspan="6">
                    <div class="float-right">
                    <?php echo format_number_choice('[0] brak wyników|[1] 1 wynik|(1,+Inf] %1% wyników', array('%1%' => count($all_group_news)-1), count($all_group_news)-1) ?>
                    </div>
                    </th>
                </tr>
            </tfoot>
        </table>
    </fieldset>
    <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"') ?>
        <?php echo st_get_admin_action('save', __('Zapisz'), null, array ('name' => 'save')) ?>
    <?php echo st_get_admin_actions_foot() ?>    
    </form>
</div>