<?php


abstract class BaseNewsletterGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $opt_description;


	
	protected $shortcut;


	
	protected $is_public;


	
	protected $is_default;

	
	protected $collNewsletterUserHasNewsletterGroups;

	
	protected $lastNewsletterUserHasNewsletterGroupCriteria = null;

	
	protected $collNewsletterMessageHasNewsletterGroups;

	
	protected $lastNewsletterMessageHasNewsletterGroupCriteria = null;

	
	protected $collNewsletterGroupI18ns;

	
	protected $lastNewsletterGroupI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getShortcut()
    {

            return $this->shortcut;
    }

    
    public function getIsPublic()
    {

            return $this->is_public;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsletterGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsletterGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setShortcut($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->shortcut !== $v) {
          $this->shortcut = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::SHORTCUT;
        }

	} 
	
	public function setIsPublic($v)
	{

        if ($this->is_public !== $v) {
          $this->is_public = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::IS_PUBLIC;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v) {
          $this->is_default = $v;
          $this->modifiedColumns[] = NewsletterGroupPeer::IS_DEFAULT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->opt_description = $rs->getString($startcol + 4);

      $this->shortcut = $rs->getString($startcol + 5);

      $this->is_public = $rs->getBoolean($startcol + 6);

      $this->is_default = $rs->getBoolean($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterGroup.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsletterGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsletterGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsletterGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsletterGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsletterGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsletterGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsletterGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsletterGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsletterGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsletterGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collNewsletterUserHasNewsletterGroups !== null) {
				foreach($this->collNewsletterUserHasNewsletterGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collNewsletterMessageHasNewsletterGroups !== null) {
				foreach($this->collNewsletterMessageHasNewsletterGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collNewsletterGroupI18ns !== null) {
				foreach($this->collNewsletterGroupI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = NewsletterGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNewsletterUserHasNewsletterGroups !== null) {
					foreach($this->collNewsletterUserHasNewsletterGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collNewsletterMessageHasNewsletterGroups !== null) {
					foreach($this->collNewsletterMessageHasNewsletterGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collNewsletterGroupI18ns !== null) {
					foreach($this->collNewsletterGroupI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getOptDescription();
				break;
			case 5:
				return $this->getShortcut();
				break;
			case 6:
				return $this->getIsPublic();
				break;
			case 7:
				return $this->getIsDefault();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getOptDescription(),
			$keys[5] => $this->getShortcut(),
			$keys[6] => $this->getIsPublic(),
			$keys[7] => $this->getIsDefault(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setOptDescription($value);
				break;
			case 5:
				$this->setShortcut($value);
				break;
			case 6:
				$this->setIsPublic($value);
				break;
			case 7:
				$this->setIsDefault($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptDescription($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setShortcut($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setIsPublic($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsDefault($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsletterGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsletterGroupPeer::CREATED_AT)) $criteria->add(NewsletterGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsletterGroupPeer::UPDATED_AT)) $criteria->add(NewsletterGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsletterGroupPeer::ID)) $criteria->add(NewsletterGroupPeer::ID, $this->id);
		if ($this->isColumnModified(NewsletterGroupPeer::OPT_NAME)) $criteria->add(NewsletterGroupPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(NewsletterGroupPeer::OPT_DESCRIPTION)) $criteria->add(NewsletterGroupPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(NewsletterGroupPeer::SHORTCUT)) $criteria->add(NewsletterGroupPeer::SHORTCUT, $this->shortcut);
		if ($this->isColumnModified(NewsletterGroupPeer::IS_PUBLIC)) $criteria->add(NewsletterGroupPeer::IS_PUBLIC, $this->is_public);
		if ($this->isColumnModified(NewsletterGroupPeer::IS_DEFAULT)) $criteria->add(NewsletterGroupPeer::IS_DEFAULT, $this->is_default);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsletterGroupPeer::DATABASE_NAME);

		$criteria->add(NewsletterGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setShortcut($this->shortcut);

		$copyObj->setIsPublic($this->is_public);

		$copyObj->setIsDefault($this->is_default);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getNewsletterUserHasNewsletterGroups() as $relObj) {
				$copyObj->addNewsletterUserHasNewsletterGroup($relObj->copy($deepCopy));
			}

			foreach($this->getNewsletterMessageHasNewsletterGroups() as $relObj) {
				$copyObj->addNewsletterMessageHasNewsletterGroup($relObj->copy($deepCopy));
			}

			foreach($this->getNewsletterGroupI18ns() as $relObj) {
				$copyObj->addNewsletterGroupI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsletterGroupPeer();
		}
		return self::$peer;
	}

	
	public function initNewsletterUserHasNewsletterGroups()
	{
		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			$this->collNewsletterUserHasNewsletterGroups = array();
		}
	}

	
	public function getNewsletterUserHasNewsletterGroups($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			if ($this->isNew()) {
			   $this->collNewsletterUserHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				NewsletterUserHasNewsletterGroupPeer::addSelectColumns($criteria);
				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				NewsletterUserHasNewsletterGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterUserHasNewsletterGroupCriteria) || !$this->lastNewsletterUserHasNewsletterGroupCriteria->equals($criteria)) {
					$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterUserHasNewsletterGroupCriteria = $criteria;
		return $this->collNewsletterUserHasNewsletterGroups;
	}

	
	public function countNewsletterUserHasNewsletterGroups($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

		return NewsletterUserHasNewsletterGroupPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterUserHasNewsletterGroup(NewsletterUserHasNewsletterGroup $l)
	{
		$this->collNewsletterUserHasNewsletterGroups[] = $l;
		$l->setNewsletterGroup($this);
	}


	
	public function getNewsletterUserHasNewsletterGroupsJoinNewsletterUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			if ($this->isNew()) {
				$this->collNewsletterUserHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelectJoinNewsletterUser($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

			if (!isset($this->lastNewsletterUserHasNewsletterGroupCriteria) || !$this->lastNewsletterUserHasNewsletterGroupCriteria->equals($criteria)) {
				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelectJoinNewsletterUser($criteria, $con);
			}
		}
		$this->lastNewsletterUserHasNewsletterGroupCriteria = $criteria;

		return $this->collNewsletterUserHasNewsletterGroups;
	}

	
	public function initNewsletterMessageHasNewsletterGroups()
	{
		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			$this->collNewsletterMessageHasNewsletterGroups = array();
		}
	}

	
	public function getNewsletterMessageHasNewsletterGroups($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			if ($this->isNew()) {
			   $this->collNewsletterMessageHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				NewsletterMessageHasNewsletterGroupPeer::addSelectColumns($criteria);
				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				NewsletterMessageHasNewsletterGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterMessageHasNewsletterGroupCriteria) || !$this->lastNewsletterMessageHasNewsletterGroupCriteria->equals($criteria)) {
					$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterMessageHasNewsletterGroupCriteria = $criteria;
		return $this->collNewsletterMessageHasNewsletterGroups;
	}

	
	public function countNewsletterMessageHasNewsletterGroups($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

		return NewsletterMessageHasNewsletterGroupPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterMessageHasNewsletterGroup(NewsletterMessageHasNewsletterGroup $l)
	{
		$this->collNewsletterMessageHasNewsletterGroups[] = $l;
		$l->setNewsletterGroup($this);
	}


	
	public function getNewsletterMessageHasNewsletterGroupsJoinNewsletterMessage($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			if ($this->isNew()) {
				$this->collNewsletterMessageHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelectJoinNewsletterMessage($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->getId());

			if (!isset($this->lastNewsletterMessageHasNewsletterGroupCriteria) || !$this->lastNewsletterMessageHasNewsletterGroupCriteria->equals($criteria)) {
				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelectJoinNewsletterMessage($criteria, $con);
			}
		}
		$this->lastNewsletterMessageHasNewsletterGroupCriteria = $criteria;

		return $this->collNewsletterMessageHasNewsletterGroups;
	}

	
	public function initNewsletterGroupI18ns()
	{
		if ($this->collNewsletterGroupI18ns === null) {
			$this->collNewsletterGroupI18ns = array();
		}
	}

	
	public function getNewsletterGroupI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterGroupI18ns === null) {
			if ($this->isNew()) {
			   $this->collNewsletterGroupI18ns = array();
			} else {

				$criteria->add(NewsletterGroupI18nPeer::ID, $this->getId());

				NewsletterGroupI18nPeer::addSelectColumns($criteria);
				$this->collNewsletterGroupI18ns = NewsletterGroupI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterGroupI18nPeer::ID, $this->getId());

				NewsletterGroupI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterGroupI18nCriteria) || !$this->lastNewsletterGroupI18nCriteria->equals($criteria)) {
					$this->collNewsletterGroupI18ns = NewsletterGroupI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterGroupI18nCriteria = $criteria;
		return $this->collNewsletterGroupI18ns;
	}

	
	public function countNewsletterGroupI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterGroupI18nPeer::ID, $this->getId());

		return NewsletterGroupI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterGroupI18n(NewsletterGroupI18n $l)
	{
		$this->collNewsletterGroupI18ns[] = $l;
		$l->setNewsletterGroup($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentNewsletterGroupI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentNewsletterGroupI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentNewsletterGroupI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentNewsletterGroupI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentNewsletterGroupI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = NewsletterGroupI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setNewsletterGroupI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setNewsletterGroupI18nForCulture(new NewsletterGroupI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setNewsletterGroupI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addNewsletterGroupI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsletterGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsletterGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsletterGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 