<?php


abstract class BaseNewsletterMessage extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $subject;


	
	protected $content;


	
	protected $sent_at;

	
	protected $collNewsletterMessageHasNewsletterGroups;

	
	protected $lastNewsletterMessageHasNewsletterGroupCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSubject()
    {

            return $this->subject;
    }

    
    public function getContent()
    {

            return $this->content;
    }

	
	public function getSentAt($format = 'Y-m-d H:i:s')
	{

		if ($this->sent_at === null || $this->sent_at === '') {
			return null;
		} elseif (!is_int($this->sent_at)) {
						$ts = strtotime($this->sent_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [sent_at] as date/time value: " . var_export($this->sent_at, true));
			}
		} else {
			$ts = $this->sent_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsletterMessagePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsletterMessagePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsletterMessagePeer::ID;
        }

	} 
	
	public function setSubject($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->subject !== $v) {
          $this->subject = $v;
          $this->modifiedColumns[] = NewsletterMessagePeer::SUBJECT;
        }

	} 
	
	public function setContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->content !== $v) {
          $this->content = $v;
          $this->modifiedColumns[] = NewsletterMessagePeer::CONTENT;
        }

	} 
	
	public function setSentAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [sent_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->sent_at !== $ts) {
			$this->sent_at = $ts;
			$this->modifiedColumns[] = NewsletterMessagePeer::SENT_AT;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessage.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->subject = $rs->getString($startcol + 3);

      $this->content = $rs->getString($startcol + 4);

      $this->sent_at = $rs->getTimestamp($startcol + 5, null);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessage.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsletterMessage object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsletterMessage:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterMessagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsletterMessagePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsletterMessage:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessage.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsletterMessage:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsletterMessagePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsletterMessagePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterMessagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessage.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsletterMessage:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsletterMessagePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsletterMessagePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collNewsletterMessageHasNewsletterGroups !== null) {
				foreach($this->collNewsletterMessageHasNewsletterGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = NewsletterMessagePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNewsletterMessageHasNewsletterGroups !== null) {
					foreach($this->collNewsletterMessageHasNewsletterGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterMessagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSubject();
				break;
			case 4:
				return $this->getContent();
				break;
			case 5:
				return $this->getSentAt();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterMessagePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSubject(),
			$keys[4] => $this->getContent(),
			$keys[5] => $this->getSentAt(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterMessagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSubject($value);
				break;
			case 4:
				$this->setContent($value);
				break;
			case 5:
				$this->setSentAt($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterMessagePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSubject($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setContent($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSentAt($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsletterMessagePeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsletterMessagePeer::CREATED_AT)) $criteria->add(NewsletterMessagePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsletterMessagePeer::UPDATED_AT)) $criteria->add(NewsletterMessagePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsletterMessagePeer::ID)) $criteria->add(NewsletterMessagePeer::ID, $this->id);
		if ($this->isColumnModified(NewsletterMessagePeer::SUBJECT)) $criteria->add(NewsletterMessagePeer::SUBJECT, $this->subject);
		if ($this->isColumnModified(NewsletterMessagePeer::CONTENT)) $criteria->add(NewsletterMessagePeer::CONTENT, $this->content);
		if ($this->isColumnModified(NewsletterMessagePeer::SENT_AT)) $criteria->add(NewsletterMessagePeer::SENT_AT, $this->sent_at);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsletterMessagePeer::DATABASE_NAME);

		$criteria->add(NewsletterMessagePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSubject($this->subject);

		$copyObj->setContent($this->content);

		$copyObj->setSentAt($this->sent_at);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getNewsletterMessageHasNewsletterGroups() as $relObj) {
				$copyObj->addNewsletterMessageHasNewsletterGroup($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsletterMessagePeer();
		}
		return self::$peer;
	}

	
	public function initNewsletterMessageHasNewsletterGroups()
	{
		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			$this->collNewsletterMessageHasNewsletterGroups = array();
		}
	}

	
	public function getNewsletterMessageHasNewsletterGroups($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			if ($this->isNew()) {
			   $this->collNewsletterMessageHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->getId());

				NewsletterMessageHasNewsletterGroupPeer::addSelectColumns($criteria);
				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->getId());

				NewsletterMessageHasNewsletterGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterMessageHasNewsletterGroupCriteria) || !$this->lastNewsletterMessageHasNewsletterGroupCriteria->equals($criteria)) {
					$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterMessageHasNewsletterGroupCriteria = $criteria;
		return $this->collNewsletterMessageHasNewsletterGroups;
	}

	
	public function countNewsletterMessageHasNewsletterGroups($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->getId());

		return NewsletterMessageHasNewsletterGroupPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterMessageHasNewsletterGroup(NewsletterMessageHasNewsletterGroup $l)
	{
		$this->collNewsletterMessageHasNewsletterGroups[] = $l;
		$l->setNewsletterMessage($this);
	}


	
	public function getNewsletterMessageHasNewsletterGroupsJoinNewsletterGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterMessageHasNewsletterGroups === null) {
			if ($this->isNew()) {
				$this->collNewsletterMessageHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->getId());

				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelectJoinNewsletterGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->getId());

			if (!isset($this->lastNewsletterMessageHasNewsletterGroupCriteria) || !$this->lastNewsletterMessageHasNewsletterGroupCriteria->equals($criteria)) {
				$this->collNewsletterMessageHasNewsletterGroups = NewsletterMessageHasNewsletterGroupPeer::doSelectJoinNewsletterGroup($criteria, $con);
			}
		}
		$this->lastNewsletterMessageHasNewsletterGroupCriteria = $criteria;

		return $this->collNewsletterMessageHasNewsletterGroups;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsletterMessage.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsletterMessage:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsletterMessage::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 