<?php


abstract class BaseNewsletterMessageHasNewsletterGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $newsletter_message_id;


	
	protected $newsletter_group_id;

	
	protected $aNewsletterMessage;

	
	protected $aNewsletterGroup;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getNewsletterMessageId()
    {

            return $this->newsletter_message_id;
    }

    
    public function getNewsletterGroupId()
    {

            return $this->newsletter_group_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsletterMessageHasNewsletterGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsletterMessageHasNewsletterGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setNewsletterMessageId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->newsletter_message_id !== $v) {
          $this->newsletter_message_id = $v;
          $this->modifiedColumns[] = NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID;
        }

		if ($this->aNewsletterMessage !== null && $this->aNewsletterMessage->getId() !== $v) {
			$this->aNewsletterMessage = null;
		}

	} 
	
	public function setNewsletterGroupId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->newsletter_group_id !== $v) {
          $this->newsletter_group_id = $v;
          $this->modifiedColumns[] = NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID;
        }

		if ($this->aNewsletterGroup !== null && $this->aNewsletterGroup->getId() !== $v) {
			$this->aNewsletterGroup = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessageHasNewsletterGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->newsletter_message_id = $rs->getInt($startcol + 2);

      $this->newsletter_group_id = $rs->getInt($startcol + 3);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessageHasNewsletterGroup.postHydrate', array('resultset' => $rs, 'startcol' => 4)));

            return $startcol + 4; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsletterMessageHasNewsletterGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsletterMessageHasNewsletterGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterMessageHasNewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsletterMessageHasNewsletterGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsletterMessageHasNewsletterGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessageHasNewsletterGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsletterMessageHasNewsletterGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterMessageHasNewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterMessageHasNewsletterGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsletterMessageHasNewsletterGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aNewsletterMessage !== null) {
				if ($this->aNewsletterMessage->isModified()) {
					$affectedRows += $this->aNewsletterMessage->save($con);
				}
				$this->setNewsletterMessage($this->aNewsletterMessage);
			}

			if ($this->aNewsletterGroup !== null) {
				if ($this->aNewsletterGroup->isModified() || $this->aNewsletterGroup->getCurrentNewsletterGroupI18n()->isModified()) {
					$affectedRows += $this->aNewsletterGroup->save($con);
				}
				$this->setNewsletterGroup($this->aNewsletterGroup);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsletterMessageHasNewsletterGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += NewsletterMessageHasNewsletterGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aNewsletterMessage !== null) {
				if (!$this->aNewsletterMessage->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aNewsletterMessage->getValidationFailures());
				}
			}

			if ($this->aNewsletterGroup !== null) {
				if (!$this->aNewsletterGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aNewsletterGroup->getValidationFailures());
				}
			}


			if (($retval = NewsletterMessageHasNewsletterGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterMessageHasNewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getNewsletterMessageId();
				break;
			case 3:
				return $this->getNewsletterGroupId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterMessageHasNewsletterGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getNewsletterMessageId(),
			$keys[3] => $this->getNewsletterGroupId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterMessageHasNewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setNewsletterMessageId($value);
				break;
			case 3:
				$this->setNewsletterGroupId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterMessageHasNewsletterGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setNewsletterMessageId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setNewsletterGroupId($arr[$keys[3]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsletterMessageHasNewsletterGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::CREATED_AT)) $criteria->add(NewsletterMessageHasNewsletterGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::UPDATED_AT)) $criteria->add(NewsletterMessageHasNewsletterGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID)) $criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->newsletter_message_id);
		if ($this->isColumnModified(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID)) $criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->newsletter_group_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsletterMessageHasNewsletterGroupPeer::DATABASE_NAME);

		$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $this->newsletter_message_id);
		$criteria->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->newsletter_group_id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getNewsletterMessageId();

		$pks[1] = $this->getNewsletterGroupId();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setNewsletterMessageId($keys[0]);

		$this->setNewsletterGroupId($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);


		$copyObj->setNew(true);

		$copyObj->setNewsletterMessageId(NULL); 
		$copyObj->setNewsletterGroupId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsletterMessageHasNewsletterGroupPeer();
		}
		return self::$peer;
	}

	
	public function setNewsletterMessage($v)
	{


		if ($v === null) {
			$this->setNewsletterMessageId(NULL);
		} else {
			$this->setNewsletterMessageId($v->getId());
		}


		$this->aNewsletterMessage = $v;
	}


	
	public function getNewsletterMessage($con = null)
	{
		if ($this->aNewsletterMessage === null && ($this->newsletter_message_id !== null)) {
						$this->aNewsletterMessage = NewsletterMessagePeer::retrieveByPK($this->newsletter_message_id, $con);

			
		}
		return $this->aNewsletterMessage;
	}

	
	public function setNewsletterGroup($v)
	{


		if ($v === null) {
			$this->setNewsletterGroupId(NULL);
		} else {
			$this->setNewsletterGroupId($v->getId());
		}


		$this->aNewsletterGroup = $v;
	}


	
	public function getNewsletterGroup($con = null)
	{
		if ($this->aNewsletterGroup === null && ($this->newsletter_group_id !== null)) {
						$this->aNewsletterGroup = NewsletterGroupPeer::retrieveByPK($this->newsletter_group_id, $con);

			
		}
		return $this->aNewsletterGroup;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsletterMessageHasNewsletterGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsletterMessageHasNewsletterGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsletterMessageHasNewsletterGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 