<?php


abstract class BaseNewsletterUser extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $email;


	
	protected $active = true;


	
	protected $confirm = false;


	
	protected $hash;

	
	protected $asfGuardUser;

	
	protected $collNewsletterUserHasNewsletterGroups;

	
	protected $lastNewsletterUserHasNewsletterGroupCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getEmail()
    {

            return $this->email;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getConfirm()
    {

            return $this->confirm;
    }

    
    public function getHash()
    {

            return $this->hash;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsletterUserPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsletterUserPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->email !== $v) {
          $this->email = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::EMAIL;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === true) {
          $this->active = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::ACTIVE;
        }

	} 
	
	public function setConfirm($v)
	{

        if ($this->confirm !== $v || $v === false) {
          $this->confirm = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::CONFIRM;
        }

	} 
	
	public function setHash($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->hash !== $v) {
          $this->hash = $v;
          $this->modifiedColumns[] = NewsletterUserPeer::HASH;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUser.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->email = $rs->getString($startcol + 4);

      $this->active = $rs->getBoolean($startcol + 5);

      $this->confirm = $rs->getBoolean($startcol + 6);

      $this->hash = $rs->getString($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUser.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsletterUser object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsletterUser:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterUserPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsletterUserPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsletterUser:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUser.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsletterUser:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsletterUserPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsletterUserPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterUserPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUser.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsletterUser:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsletterUserPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsletterUserPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collNewsletterUserHasNewsletterGroups !== null) {
				foreach($this->collNewsletterUserHasNewsletterGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}


			if (($retval = NewsletterUserPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNewsletterUserHasNewsletterGroups !== null) {
					foreach($this->collNewsletterUserHasNewsletterGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getEmail();
				break;
			case 5:
				return $this->getActive();
				break;
			case 6:
				return $this->getConfirm();
				break;
			case 7:
				return $this->getHash();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterUserPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getEmail(),
			$keys[5] => $this->getActive(),
			$keys[6] => $this->getConfirm(),
			$keys[7] => $this->getHash(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setEmail($value);
				break;
			case 5:
				$this->setActive($value);
				break;
			case 6:
				$this->setConfirm($value);
				break;
			case 7:
				$this->setHash($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterUserPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setEmail($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setActive($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setConfirm($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setHash($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsletterUserPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsletterUserPeer::CREATED_AT)) $criteria->add(NewsletterUserPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsletterUserPeer::UPDATED_AT)) $criteria->add(NewsletterUserPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsletterUserPeer::ID)) $criteria->add(NewsletterUserPeer::ID, $this->id);
		if ($this->isColumnModified(NewsletterUserPeer::SF_GUARD_USER_ID)) $criteria->add(NewsletterUserPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(NewsletterUserPeer::EMAIL)) $criteria->add(NewsletterUserPeer::EMAIL, $this->email);
		if ($this->isColumnModified(NewsletterUserPeer::ACTIVE)) $criteria->add(NewsletterUserPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(NewsletterUserPeer::CONFIRM)) $criteria->add(NewsletterUserPeer::CONFIRM, $this->confirm);
		if ($this->isColumnModified(NewsletterUserPeer::HASH)) $criteria->add(NewsletterUserPeer::HASH, $this->hash);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsletterUserPeer::DATABASE_NAME);

		$criteria->add(NewsletterUserPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setEmail($this->email);

		$copyObj->setActive($this->active);

		$copyObj->setConfirm($this->confirm);

		$copyObj->setHash($this->hash);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getNewsletterUserHasNewsletterGroups() as $relObj) {
				$copyObj->addNewsletterUserHasNewsletterGroup($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsletterUserPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function initNewsletterUserHasNewsletterGroups()
	{
		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			$this->collNewsletterUserHasNewsletterGroups = array();
		}
	}

	
	public function getNewsletterUserHasNewsletterGroups($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			if ($this->isNew()) {
			   $this->collNewsletterUserHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->getId());

				NewsletterUserHasNewsletterGroupPeer::addSelectColumns($criteria);
				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->getId());

				NewsletterUserHasNewsletterGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterUserHasNewsletterGroupCriteria) || !$this->lastNewsletterUserHasNewsletterGroupCriteria->equals($criteria)) {
					$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterUserHasNewsletterGroupCriteria = $criteria;
		return $this->collNewsletterUserHasNewsletterGroups;
	}

	
	public function countNewsletterUserHasNewsletterGroups($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->getId());

		return NewsletterUserHasNewsletterGroupPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterUserHasNewsletterGroup(NewsletterUserHasNewsletterGroup $l)
	{
		$this->collNewsletterUserHasNewsletterGroups[] = $l;
		$l->setNewsletterUser($this);
	}


	
	public function getNewsletterUserHasNewsletterGroupsJoinNewsletterGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterUserHasNewsletterGroups === null) {
			if ($this->isNew()) {
				$this->collNewsletterUserHasNewsletterGroups = array();
			} else {

				$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->getId());

				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelectJoinNewsletterGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->getId());

			if (!isset($this->lastNewsletterUserHasNewsletterGroupCriteria) || !$this->lastNewsletterUserHasNewsletterGroupCriteria->equals($criteria)) {
				$this->collNewsletterUserHasNewsletterGroups = NewsletterUserHasNewsletterGroupPeer::doSelectJoinNewsletterGroup($criteria, $con);
			}
		}
		$this->lastNewsletterUserHasNewsletterGroupCriteria = $criteria;

		return $this->collNewsletterUserHasNewsletterGroups;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsletterUser.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsletterUser:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsletterUser::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 