<?php


abstract class BaseNewsletterUserHasNewsletterGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $newsletter_group_id;


	
	protected $newsletter_user_id;

	
	protected $aNewsletterGroup;

	
	protected $aNewsletterUser;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getNewsletterGroupId()
    {

            return $this->newsletter_group_id;
    }

    
    public function getNewsletterUserId()
    {

            return $this->newsletter_user_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = NewsletterUserHasNewsletterGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = NewsletterUserHasNewsletterGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = NewsletterUserHasNewsletterGroupPeer::ID;
        }

	} 
	
	public function setNewsletterGroupId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->newsletter_group_id !== $v) {
          $this->newsletter_group_id = $v;
          $this->modifiedColumns[] = NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID;
        }

		if ($this->aNewsletterGroup !== null && $this->aNewsletterGroup->getId() !== $v) {
			$this->aNewsletterGroup = null;
		}

	} 
	
	public function setNewsletterUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->newsletter_user_id !== $v) {
          $this->newsletter_user_id = $v;
          $this->modifiedColumns[] = NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID;
        }

		if ($this->aNewsletterUser !== null && $this->aNewsletterUser->getId() !== $v) {
			$this->aNewsletterUser = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUserHasNewsletterGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->newsletter_group_id = $rs->getInt($startcol + 3);

      $this->newsletter_user_id = $rs->getInt($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUserHasNewsletterGroup.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating NewsletterUserHasNewsletterGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseNewsletterUserHasNewsletterGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterUserHasNewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			NewsletterUserHasNewsletterGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseNewsletterUserHasNewsletterGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUserHasNewsletterGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseNewsletterUserHasNewsletterGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(NewsletterUserHasNewsletterGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'NewsletterUserHasNewsletterGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseNewsletterUserHasNewsletterGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aNewsletterGroup !== null) {
				if ($this->aNewsletterGroup->isModified() || $this->aNewsletterGroup->getCurrentNewsletterGroupI18n()->isModified()) {
					$affectedRows += $this->aNewsletterGroup->save($con);
				}
				$this->setNewsletterGroup($this->aNewsletterGroup);
			}

			if ($this->aNewsletterUser !== null) {
				if ($this->aNewsletterUser->isModified()) {
					$affectedRows += $this->aNewsletterUser->save($con);
				}
				$this->setNewsletterUser($this->aNewsletterUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = NewsletterUserHasNewsletterGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += NewsletterUserHasNewsletterGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aNewsletterGroup !== null) {
				if (!$this->aNewsletterGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aNewsletterGroup->getValidationFailures());
				}
			}

			if ($this->aNewsletterUser !== null) {
				if (!$this->aNewsletterUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aNewsletterUser->getValidationFailures());
				}
			}


			if (($retval = NewsletterUserHasNewsletterGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterUserHasNewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getNewsletterGroupId();
				break;
			case 4:
				return $this->getNewsletterUserId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterUserHasNewsletterGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getNewsletterGroupId(),
			$keys[4] => $this->getNewsletterUserId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = NewsletterUserHasNewsletterGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setNewsletterGroupId($value);
				break;
			case 4:
				$this->setNewsletterUserId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = NewsletterUserHasNewsletterGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setNewsletterGroupId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setNewsletterUserId($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(NewsletterUserHasNewsletterGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::CREATED_AT)) $criteria->add(NewsletterUserHasNewsletterGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::UPDATED_AT)) $criteria->add(NewsletterUserHasNewsletterGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::ID)) $criteria->add(NewsletterUserHasNewsletterGroupPeer::ID, $this->id);
		if ($this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID)) $criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->newsletter_group_id);
		if ($this->isColumnModified(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID)) $criteria->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $this->newsletter_user_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(NewsletterUserHasNewsletterGroupPeer::DATABASE_NAME);

		$criteria->add(NewsletterUserHasNewsletterGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setNewsletterGroupId($this->newsletter_group_id);

		$copyObj->setNewsletterUserId($this->newsletter_user_id);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new NewsletterUserHasNewsletterGroupPeer();
		}
		return self::$peer;
	}

	
	public function setNewsletterGroup($v)
	{


		if ($v === null) {
			$this->setNewsletterGroupId(NULL);
		} else {
			$this->setNewsletterGroupId($v->getId());
		}


		$this->aNewsletterGroup = $v;
	}


	
	public function getNewsletterGroup($con = null)
	{
		if ($this->aNewsletterGroup === null && ($this->newsletter_group_id !== null)) {
						$this->aNewsletterGroup = NewsletterGroupPeer::retrieveByPK($this->newsletter_group_id, $con);

			
		}
		return $this->aNewsletterGroup;
	}

	
	public function setNewsletterUser($v)
	{


		if ($v === null) {
			$this->setNewsletterUserId(NULL);
		} else {
			$this->setNewsletterUserId($v->getId());
		}


		$this->aNewsletterUser = $v;
	}


	
	public function getNewsletterUser($con = null)
	{
		if ($this->aNewsletterUser === null && ($this->newsletter_user_id !== null)) {
						$this->aNewsletterUser = NewsletterUserPeer::retrieveByPK($this->newsletter_user_id, $con);

			
		}
		return $this->aNewsletterUser;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'NewsletterUserHasNewsletterGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseNewsletterUserHasNewsletterGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseNewsletterUserHasNewsletterGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 