<?php

class stNewsletterProgressBar
{
   public function init()
   {
   }

   public function close()
   {
      $i18n = sfContext::getInstance()->getI18N();

      $id = self::getParam('id');

      sfLoader::loadHelpers(array('Helper', 'stPartial'));

      $newsletter = NewsletterMessagePeer::retrieveByPK($id);

      $newsletter->setSentAt(time());

      $newsletter->save();

      $message = st_get_partial('stNewsletterBackend/progress_success', array('steps' => self::getAttribute('steps'), 'id' => $id));

      $this->setMessage($message);

      sfContext::getInstance()->getUser()->getAttributeHolder()->removeNamespace('soteshop/stNewsletterProgressBar');
   }

   public function send($offset)
   {
      $newsletter = NewsletterMessagePeer::retrieveByPK(self::getParam('id'));

      $html = stMailTemplate::render('stNewsletterBackend/messageHtml', array('newsletter' => $newsletter));

      $plain = stMailTemplate::render('stNewsletterBackend/messagePlain', array('newsletter' => $newsletter));

      $i18n = sfContext::getInstance()->getI18N();

      $c = new Criteria();

      $c->setOffset($offset);

      $c->setLimit(100);

      $users = $newsletter->getUsers($c);

      $mailer = stMailer::getInstance();

      $mailer->setSubject($newsletter->getSubject())->setHtmlMessage($html)->setPlainMessage($plain);

      $counter = 0;
      
      foreach ($users as $user)
      {
         $counter++;
         
         try
         {
            $mailer->addBcc($user->getEmail());
         }
         catch(Swift_RfcComplianceException $e)
         {
            
         }
         
         if ($counter == 20)
         {
            $mailer->send();

            $mailer->setBcc(array());

            $counter = 0;

            usleep(200000);
         }
      }

      if ($counter > 0)
      {
         $mailer->send();
      }
      
      self::setMessage($i18n->__('Wysyłanie wiadomości w toku %current%/%from%', array('%current%' => $offset, '%from%' => self::getAttribute('steps'))));

      sleep(1);
      
      return $offset + count($users);
   }

   public static function setParam($name, $value)
   {
      sfContext::getInstance()->getUser()->setAttribute($name, $value, 'soteshop/stNewsletterProgressBar');
   }

   public static function getParam($name, $default = null)
   {
      return sfContext::getInstance()->getUser()->getAttribute($name, $default, 'soteshop/stNewsletterProgressBar');
   }

   public static function getAttribute($name)
   {
      $attributes = sfContext::getInstance()->getUser()->getAttribute('stNewsletter', array(), 'soteshop/stProgressBarPlugin');

      return isset($attributes[$name]) ? $attributes[$name] : null;
   }

   public static function setMessage($message)
   {
      sfContext::getInstance()->getUser()->setAttribute('stProgressBar-stNewsletter', $message, 'symfony/flash');
   }
}