<?php

/**
 * SOTESHOP/stNewsletterPlugin
 *
 * Ten plik należy do aplikacji stNewsletterPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stNewsletterPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 13778 2011-06-21 12:01:22Z bartek $
 * @author      Bartosz Alejski <bartosz.alejski@sote.pl>
 */

/**
 * Klasa stNewsletterFrontendActions.
 *
 * @package     stNewsletterPlugin
 * @subpackage  actions
 */
class stNewsletterBackendActions extends autoStNewsletterBackendActions
{

   protected function addNewsletterUserFiltersCriteria($c)
   {
      parent::addNewsletterUserFiltersCriteria($c);

      if (isset($this->filters['group']) && $this->filters['group'])
      {
         $c->addJoin(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, NewsletterUserPeer::ID);

         $c->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_GROUP_ID, $this->filters['group']);
      }
   }

   public function executeSaveAndSendConfirm()
   {
      $this->forward('stNewsletterBackend', 'edit');
   }

   /**
    * Obsługuje wysyłanie mail'i
    */
   function SendMailConfirm($user, $group, $hash)
   {
      $mail_error = $this->mailWithConfirmRegisterToUser($user, $group, $hash);
      return $mail_error;
   }

   /**
    * Wysyła mail z zamówieniem do administratora
    */
   protected function mailWithConfirmRegisterToUser($user, $group, $hash)
   {
      $sendConfirmRegisterToUserHtmlMailMessage = stMailTemplate::render('confirmUserHtml', array(
                  'user' => $user,
                  'group' => $group,
                  'hash' => $hash,
              ));

      $sendConfirmRegisterToUserPlainMailMessage = stMailTemplate::render('confirmUserPlain', array(
                  'user' => $user,
                  'group' => $group,
                  'hash' => $hash,
              ));

      $mail = stMailer::getInstance();
      return $mail->setSubject($this->getRequest()->getHost().' - '.$this->getContext()->getI18N()->__('Rejestracja na liście subskrypcji.'))->setHtmlMessage($sendConfirmRegisterToUserHtmlMailMessage)->setPlainMessage($sendConfirmRegisterToUserPlainMailMessage)->setTo($user->getEmail())->sendToClient();
   }

   public function executeNewsletterSend()
   {
      $newsletter = NewsletterMessagePeer::retrieveByPK($this->getRequestParameter('id'));

      $this->count = $newsletter->countUsers(new Criteria());

      stNewsletterProgressBar::setParam('id', $newsletter->getId());
   }

   public function executeSaveAndSend()
   {
      return $this->forward('stNewsletterBackend', 'edit');
   }

   protected function savesfGuardUser($sf_guard_user)
   {
      if (!$sf_guard_user->getId())
      {
         $sf_guard_user->addGroupByName('user');
         $sf_guard_user->setHashCode(md5(microtime()));
      }

      parent::savesfGuardUser($sf_guard_user);
   }

   protected function saveNewsletterMessage($newsletter_message)
   {
      parent::saveNewsletterMessage($newsletter_message);

      $c = new Criteria();

      $c->add(NewsletterMessageHasNewsletterGroupPeer::NEWSLETTER_MESSAGE_ID, $newsletter_message->getId());

      BasePeer::doDelete($c, Propel::getConnection());

      $newsletter_group = $this->getRequestParameter('newsletter_message[newsletter_group]');

      foreach ($newsletter_group as $id)
      {
         $ng = new NewsletterMessageHasNewsletterGroup();

         $ng->setNewsletterGroupId($id);

         $ng->setNewsletterMessageId($newsletter_message->getId());

         $ng->save();
      }

      if ($this->hasRequestParameter('save_and_send'))
      {
         return $this->redirect('stNewsletterBackend/newsletterSend?id='.$newsletter_message->getId());
      }
   }

   protected function saveNewsletterUserNewsletterUser($newsletter_user)
   {
      parent::saveNewsletterUserNewsletterUser($newsletter_user);

      $c = new Criteria();

      $c->add(NewsletterUserHasNewsletterGroupPeer::NEWSLETTER_USER_ID, $newsletter_user->getId());

      BasePeer::doDelete($c, Propel::getConnection());

      $newsletter_group = $this->getRequestParameter('newsletter_user[newsletter_group]');

      foreach ($newsletter_group as $id)
      {
         $ng = new NewsletterUserHasNewsletterGroup();

         $ng->setNewsletterGroupId($id);

         $ng->setNewsletterUserId($newsletter_user->getId());

         $ng->save();
      }

      if ($this->hasRequestParameter('save_and_send_confirm'))
      {
         return ($this->sendMailConfirm($newsletter_user, $ng, $newsletter_user->getHash()));
      }

   }

}