<?php
use_helper('Validation', 'stCaptchaGD');
st_theme_use_stylesheet('stNewsletterPlugin.css');

$smarty->assign("form_start", form_tag('stNewsletterFrontend/addToList', array('class' => 'st_form')));
$smarty->assign("label_email", label_for('newsletter[email]',__('E-mail')));
$smarty->assign("error_email", form_error('newsletter[email]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign("input_email", input_tag('newsletter[email]',$sf_params->get('newsletter[email]'), array('id'=>'st_form-user-password2','class'=>form_has_error('newsletter{email}') ? 'st_form-error' : '')));

$smarty->assign("error_privacy", form_error('newsletter[privacy]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign("input_privacy",checkbox_tag('newsletter[privacy]', 1, false, array('id'=>'st_form-user-privacy','class'=>form_has_error('newsletter{privacy}') ? 'st_form-error' : '')));
$smarty->assign("accept_privacy",link_to(__('Akceptuje politykę prywatności'),'webpage/index?webpage_id=4'));
$smarty->assign("captcha_on", $config->get('captcha_on', stConfig::INT));

if($config->get("captcha_on", stConfig::INT)==1)
{
    $smarty->assign("error_captcha", form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
    $smarty->assign("view_captcha", get_captcha());
    $smarty->assign("label_captcha", label_for('captcha',__('Cyfry z obrazka')));
    $smarty->assign("input_captcha", input_tag('captcha', '', array('id'=>'st_form-user-password2','class'=>form_has_error('captcha') ? 'st_form-error' : '')));
}

$smarty->assign("newsletterGroup", $newsletterGroup);
if ($newsletterGroup)
{
    $results=array();
    foreach ($newsletterGroup as $group)
    {
        $checked = 0;
        if($group->getIsDefault()==1)
        {
            $checked = 1;
        }
        $row['input']=checkbox_tag('newsletter[group]['.$group->getId().']', 1, $checked);
        $row['name']=$group->getName();
        $row['description']=$group->getDescription();
        $results[]=$row;
    }
    $smarty->assign('results',$results);
}
$smarty->assign("submit_button", submit_tag(__('Dodaj')));
$smarty->display("newsletter_index.html");
?>