<?php
use_helper('Validation');
st_theme_use_stylesheet('stUser.css');
st_theme_use_stylesheet('stNewsletterPlugin.css');

$smarty->assign('user_panel_icon', st_theme_image_tag('user_panel_icon.png'));
$smarty->assign('my_account', link_to(__('Moje konto', array(), 'stUser'), 'stUserData/userPanel'));
$smarty->assign('user_panel_menu',  st_get_component('stUserData', 'userPanelMenu'));

$smarty->assign("form_start", form_tag('stNewsletterFrontend/addLoginUserToNewsletter', array('class' => 'st_form')));

$smarty->assign("label_email", label_for('newsletter[email]',__('E-mail')));
$smarty->assign("error_email", form_error('newsletter[email]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign("input_email", input_tag('newsletter[email]', $newsletterUserEmail, array('id'=>'st_form-user-password2','class'=>form_has_error('newsletter{email}') ? 'st_form-error' : '')));

$smarty->assign("error_privacy", form_error('newsletter[privacy]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign("input_privacy",checkbox_tag('newsletter[privacy]', 1, false, array('id'=>'st_form-user-privacy','class'=>form_has_error('newsletter{privacy}') ? 'st_form-error' : '')));
$smarty->assign("accept_privacy",link_to(__('Akceptuje politykę prywatności'),'webpage/index?webpage_id=4'));

$smarty->assign("newsletterGroup", $newsletterGroup);

if ($newsletterGroup)
{
    $results=array();
    foreach ($newsletterGroup as $group)
    {
        $checked = 0;
        if($group->getIsDefault()==1)
        {
            $checked = 1;
        }
        $row['input']=checkbox_tag('newsletter[group]['.$group->getId().']', 1, $checked);
        $row['name']=$group->getName();
        $row['description']=$group->getDescription();
        $results[]=$row;
    }
    $smarty->assign('results',$results);
}

$smarty->assign('new_user', $newUser);
$smarty->assign('update', $update);

$smarty->assign('hidden_new_user', input_hidden_tag('newsletter[new_user]', $newUser));

if($newUser==1)
{
    $smarty->assign("submit_button", submit_tag(__('Zapisz mnie na newsletter')));
}
else
{
    $smarty->assign('user_email', $userEmail);
    $smarty->assign('newsletter_user', link_to(__('Usuń mnie z listy'), '@stNewsletterRemove?id=' . $newsletterUser->getId() . '&hash_code=' . $newsletterUser->getHash(), 'absolute=true'));
    $smarty->assign("submit_button", submit_tag(__('Aktualizuj')));
}

$smarty->display('newsletter_list.html')
?>