<?php


abstract class BasePartner extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $countries_id;


	
	protected $sf_guard_user_id;


	
	protected $company;


	
	protected $vat_number;


	
	protected $bank_number;


	
	protected $name;


	
	protected $surname;


	
	protected $street;


	
	protected $house;


	
	protected $flat;


	
	protected $code;


	
	protected $town;


	
	protected $phone;


	
	protected $description;


	
	protected $provision;


	
	protected $amount;


	
	protected $system_value;


	
	protected $is_active = true;


	
	protected $is_system = false;


	
	protected $is_confirm = false;

	
	protected $aCountries;

	
	protected $asfGuardUser;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $collPartnerHashs;

	
	protected $lastPartnerHashCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCountriesId()
    {

            return $this->countries_id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getCompany()
    {

            return $this->company;
    }

    
    public function getVatNumber()
    {

            return $this->vat_number;
    }

    
    public function getBankNumber()
    {

            return $this->bank_number;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getSurname()
    {

            return $this->surname;
    }

    
    public function getStreet()
    {

            return $this->street;
    }

    
    public function getHouse()
    {

            return $this->house;
    }

    
    public function getFlat()
    {

            return $this->flat;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getTown()
    {

            return $this->town;
    }

    
    public function getPhone()
    {

            return $this->phone;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getProvision()
    {

            return $this->provision;
    }

    
    public function getAmount()
    {

            return $this->amount;
    }

    
    public function getSystemValue()
    {

            return $this->system_value;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getIsSystem()
    {

            return $this->is_system;
    }

    
    public function getIsConfirm()
    {

            return $this->is_confirm;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = PartnerPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = PartnerPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = PartnerPeer::ID;
        }

	} 
	
	public function setCountriesId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->countries_id !== $v) {
          $this->countries_id = $v;
          $this->modifiedColumns[] = PartnerPeer::COUNTRIES_ID;
        }

		if ($this->aCountries !== null && $this->aCountries->getId() !== $v) {
			$this->aCountries = null;
		}

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = PartnerPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setCompany($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->company !== $v) {
          $this->company = $v;
          $this->modifiedColumns[] = PartnerPeer::COMPANY;
        }

	} 
	
	public function setVatNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->vat_number !== $v) {
          $this->vat_number = $v;
          $this->modifiedColumns[] = PartnerPeer::VAT_NUMBER;
        }

	} 
	
	public function setBankNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->bank_number !== $v) {
          $this->bank_number = $v;
          $this->modifiedColumns[] = PartnerPeer::BANK_NUMBER;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = PartnerPeer::NAME;
        }

	} 
	
	public function setSurname($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->surname !== $v) {
          $this->surname = $v;
          $this->modifiedColumns[] = PartnerPeer::SURNAME;
        }

	} 
	
	public function setStreet($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->street !== $v) {
          $this->street = $v;
          $this->modifiedColumns[] = PartnerPeer::STREET;
        }

	} 
	
	public function setHouse($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->house !== $v) {
          $this->house = $v;
          $this->modifiedColumns[] = PartnerPeer::HOUSE;
        }

	} 
	
	public function setFlat($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->flat !== $v) {
          $this->flat = $v;
          $this->modifiedColumns[] = PartnerPeer::FLAT;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = PartnerPeer::CODE;
        }

	} 
	
	public function setTown($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->town !== $v) {
          $this->town = $v;
          $this->modifiedColumns[] = PartnerPeer::TOWN;
        }

	} 
	
	public function setPhone($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->phone !== $v) {
          $this->phone = $v;
          $this->modifiedColumns[] = PartnerPeer::PHONE;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = PartnerPeer::DESCRIPTION;
        }

	} 
	
	public function setProvision($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->provision !== $v) {
          $this->provision = $v;
          $this->modifiedColumns[] = PartnerPeer::PROVISION;
        }

	} 
	
	public function setAmount($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->amount !== $v) {
          $this->amount = $v;
          $this->modifiedColumns[] = PartnerPeer::AMOUNT;
        }

	} 
	
	public function setSystemValue($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->system_value !== $v) {
          $this->system_value = $v;
          $this->modifiedColumns[] = PartnerPeer::SYSTEM_VALUE;
        }

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === true) {
          $this->is_active = $v;
          $this->modifiedColumns[] = PartnerPeer::IS_ACTIVE;
        }

	} 
	
	public function setIsSystem($v)
	{

        if ($this->is_system !== $v || $v === false) {
          $this->is_system = $v;
          $this->modifiedColumns[] = PartnerPeer::IS_SYSTEM;
        }

	} 
	
	public function setIsConfirm($v)
	{

        if ($this->is_confirm !== $v || $v === false) {
          $this->is_confirm = $v;
          $this->modifiedColumns[] = PartnerPeer::IS_CONFIRM;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Partner.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->countries_id = $rs->getInt($startcol + 3);

      $this->sf_guard_user_id = $rs->getInt($startcol + 4);

      $this->company = $rs->getString($startcol + 5);

      $this->vat_number = $rs->getString($startcol + 6);

      $this->bank_number = $rs->getString($startcol + 7);

      $this->name = $rs->getString($startcol + 8);

      $this->surname = $rs->getString($startcol + 9);

      $this->street = $rs->getString($startcol + 10);

      $this->house = $rs->getString($startcol + 11);

      $this->flat = $rs->getString($startcol + 12);

      $this->code = $rs->getString($startcol + 13);

      $this->town = $rs->getString($startcol + 14);

      $this->phone = $rs->getString($startcol + 15);

      $this->description = $rs->getString($startcol + 16);

      $this->provision = $rs->getString($startcol + 17);

      $this->amount = $rs->getString($startcol + 18);

      $this->system_value = $rs->getInt($startcol + 19);

      $this->is_active = $rs->getBoolean($startcol + 20);

      $this->is_system = $rs->getBoolean($startcol + 21);

      $this->is_confirm = $rs->getBoolean($startcol + 22);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Partner.postHydrate', array('resultset' => $rs, 'startcol' => 23)));

            return $startcol + 23; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Partner object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BasePartner:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PartnerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			PartnerPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasePartner:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Partner.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BasePartner:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(PartnerPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(PartnerPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PartnerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Partner.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BasePartner:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCountries !== null) {
				if ($this->aCountries->isModified() || $this->aCountries->getCurrentCountriesI18n()->isModified()) {
					$affectedRows += $this->aCountries->save($con);
				}
				$this->setCountries($this->aCountries);
			}

			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PartnerPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += PartnerPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPartnerHashs !== null) {
				foreach($this->collPartnerHashs as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCountries !== null) {
				if (!$this->aCountries->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCountries->getValidationFailures());
				}
			}

			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}


			if (($retval = PartnerPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPartnerHashs !== null) {
					foreach($this->collPartnerHashs as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PartnerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCountriesId();
				break;
			case 4:
				return $this->getSfGuardUserId();
				break;
			case 5:
				return $this->getCompany();
				break;
			case 6:
				return $this->getVatNumber();
				break;
			case 7:
				return $this->getBankNumber();
				break;
			case 8:
				return $this->getName();
				break;
			case 9:
				return $this->getSurname();
				break;
			case 10:
				return $this->getStreet();
				break;
			case 11:
				return $this->getHouse();
				break;
			case 12:
				return $this->getFlat();
				break;
			case 13:
				return $this->getCode();
				break;
			case 14:
				return $this->getTown();
				break;
			case 15:
				return $this->getPhone();
				break;
			case 16:
				return $this->getDescription();
				break;
			case 17:
				return $this->getProvision();
				break;
			case 18:
				return $this->getAmount();
				break;
			case 19:
				return $this->getSystemValue();
				break;
			case 20:
				return $this->getIsActive();
				break;
			case 21:
				return $this->getIsSystem();
				break;
			case 22:
				return $this->getIsConfirm();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PartnerPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCountriesId(),
			$keys[4] => $this->getSfGuardUserId(),
			$keys[5] => $this->getCompany(),
			$keys[6] => $this->getVatNumber(),
			$keys[7] => $this->getBankNumber(),
			$keys[8] => $this->getName(),
			$keys[9] => $this->getSurname(),
			$keys[10] => $this->getStreet(),
			$keys[11] => $this->getHouse(),
			$keys[12] => $this->getFlat(),
			$keys[13] => $this->getCode(),
			$keys[14] => $this->getTown(),
			$keys[15] => $this->getPhone(),
			$keys[16] => $this->getDescription(),
			$keys[17] => $this->getProvision(),
			$keys[18] => $this->getAmount(),
			$keys[19] => $this->getSystemValue(),
			$keys[20] => $this->getIsActive(),
			$keys[21] => $this->getIsSystem(),
			$keys[22] => $this->getIsConfirm(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PartnerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCountriesId($value);
				break;
			case 4:
				$this->setSfGuardUserId($value);
				break;
			case 5:
				$this->setCompany($value);
				break;
			case 6:
				$this->setVatNumber($value);
				break;
			case 7:
				$this->setBankNumber($value);
				break;
			case 8:
				$this->setName($value);
				break;
			case 9:
				$this->setSurname($value);
				break;
			case 10:
				$this->setStreet($value);
				break;
			case 11:
				$this->setHouse($value);
				break;
			case 12:
				$this->setFlat($value);
				break;
			case 13:
				$this->setCode($value);
				break;
			case 14:
				$this->setTown($value);
				break;
			case 15:
				$this->setPhone($value);
				break;
			case 16:
				$this->setDescription($value);
				break;
			case 17:
				$this->setProvision($value);
				break;
			case 18:
				$this->setAmount($value);
				break;
			case 19:
				$this->setSystemValue($value);
				break;
			case 20:
				$this->setIsActive($value);
				break;
			case 21:
				$this->setIsSystem($value);
				break;
			case 22:
				$this->setIsConfirm($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PartnerPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCountriesId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSfGuardUserId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setCompany($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setVatNumber($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setBankNumber($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setName($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setSurname($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setStreet($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setHouse($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setFlat($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setCode($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setTown($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setPhone($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setDescription($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setProvision($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setAmount($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setSystemValue($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setIsActive($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setIsSystem($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setIsConfirm($arr[$keys[22]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(PartnerPeer::DATABASE_NAME);

		if ($this->isColumnModified(PartnerPeer::CREATED_AT)) $criteria->add(PartnerPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(PartnerPeer::UPDATED_AT)) $criteria->add(PartnerPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(PartnerPeer::ID)) $criteria->add(PartnerPeer::ID, $this->id);
		if ($this->isColumnModified(PartnerPeer::COUNTRIES_ID)) $criteria->add(PartnerPeer::COUNTRIES_ID, $this->countries_id);
		if ($this->isColumnModified(PartnerPeer::SF_GUARD_USER_ID)) $criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(PartnerPeer::COMPANY)) $criteria->add(PartnerPeer::COMPANY, $this->company);
		if ($this->isColumnModified(PartnerPeer::VAT_NUMBER)) $criteria->add(PartnerPeer::VAT_NUMBER, $this->vat_number);
		if ($this->isColumnModified(PartnerPeer::BANK_NUMBER)) $criteria->add(PartnerPeer::BANK_NUMBER, $this->bank_number);
		if ($this->isColumnModified(PartnerPeer::NAME)) $criteria->add(PartnerPeer::NAME, $this->name);
		if ($this->isColumnModified(PartnerPeer::SURNAME)) $criteria->add(PartnerPeer::SURNAME, $this->surname);
		if ($this->isColumnModified(PartnerPeer::STREET)) $criteria->add(PartnerPeer::STREET, $this->street);
		if ($this->isColumnModified(PartnerPeer::HOUSE)) $criteria->add(PartnerPeer::HOUSE, $this->house);
		if ($this->isColumnModified(PartnerPeer::FLAT)) $criteria->add(PartnerPeer::FLAT, $this->flat);
		if ($this->isColumnModified(PartnerPeer::CODE)) $criteria->add(PartnerPeer::CODE, $this->code);
		if ($this->isColumnModified(PartnerPeer::TOWN)) $criteria->add(PartnerPeer::TOWN, $this->town);
		if ($this->isColumnModified(PartnerPeer::PHONE)) $criteria->add(PartnerPeer::PHONE, $this->phone);
		if ($this->isColumnModified(PartnerPeer::DESCRIPTION)) $criteria->add(PartnerPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(PartnerPeer::PROVISION)) $criteria->add(PartnerPeer::PROVISION, $this->provision);
		if ($this->isColumnModified(PartnerPeer::AMOUNT)) $criteria->add(PartnerPeer::AMOUNT, $this->amount);
		if ($this->isColumnModified(PartnerPeer::SYSTEM_VALUE)) $criteria->add(PartnerPeer::SYSTEM_VALUE, $this->system_value);
		if ($this->isColumnModified(PartnerPeer::IS_ACTIVE)) $criteria->add(PartnerPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(PartnerPeer::IS_SYSTEM)) $criteria->add(PartnerPeer::IS_SYSTEM, $this->is_system);
		if ($this->isColumnModified(PartnerPeer::IS_CONFIRM)) $criteria->add(PartnerPeer::IS_CONFIRM, $this->is_confirm);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PartnerPeer::DATABASE_NAME);

		$criteria->add(PartnerPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCountriesId($this->countries_id);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setCompany($this->company);

		$copyObj->setVatNumber($this->vat_number);

		$copyObj->setBankNumber($this->bank_number);

		$copyObj->setName($this->name);

		$copyObj->setSurname($this->surname);

		$copyObj->setStreet($this->street);

		$copyObj->setHouse($this->house);

		$copyObj->setFlat($this->flat);

		$copyObj->setCode($this->code);

		$copyObj->setTown($this->town);

		$copyObj->setPhone($this->phone);

		$copyObj->setDescription($this->description);

		$copyObj->setProvision($this->provision);

		$copyObj->setAmount($this->amount);

		$copyObj->setSystemValue($this->system_value);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsSystem($this->is_system);

		$copyObj->setIsConfirm($this->is_confirm);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

			foreach($this->getPartnerHashs() as $relObj) {
				$copyObj->addPartnerHash($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PartnerPeer();
		}
		return self::$peer;
	}

	
	public function setCountries($v)
	{


		if ($v === null) {
			$this->setCountriesId(NULL);
		} else {
			$this->setCountriesId($v->getId());
		}


		$this->aCountries = $v;
	}


	
	public function getCountries($con = null)
	{
		if ($this->aCountries === null && ($this->countries_id !== null)) {
						$this->aCountries = CountriesPeer::retrieveByPK($this->countries_id, $con);

			
		}
		return $this->aCountries;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setPartner($this);
	}


	
	public function getOrdersJoinOrderDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataBilling($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::PARTNER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}

	
	public function initPartnerHashs()
	{
		if ($this->collPartnerHashs === null) {
			$this->collPartnerHashs = array();
		}
	}

	
	public function getPartnerHashs($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartnerHashs === null) {
			if ($this->isNew()) {
			   $this->collPartnerHashs = array();
			} else {

				$criteria->add(PartnerHashPeer::PARTNER_ID, $this->getId());

				PartnerHashPeer::addSelectColumns($criteria);
				$this->collPartnerHashs = PartnerHashPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PartnerHashPeer::PARTNER_ID, $this->getId());

				PartnerHashPeer::addSelectColumns($criteria);
				if (!isset($this->lastPartnerHashCriteria) || !$this->lastPartnerHashCriteria->equals($criteria)) {
					$this->collPartnerHashs = PartnerHashPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPartnerHashCriteria = $criteria;
		return $this->collPartnerHashs;
	}

	
	public function countPartnerHashs($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PartnerHashPeer::PARTNER_ID, $this->getId());

		return PartnerHashPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPartnerHash(PartnerHash $l)
	{
		$this->collPartnerHashs[] = $l;
		$l->setPartner($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Partner.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BasePartner:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BasePartner::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 