<?php use_helper('Object', 'Validation', 'ObjectAdmin', 'I18N', 'Date', 'VisualEffect', 'stAdminGenerator') ?>

<script type="text/javascript">
    function st_enable_all(dom)
    {
        var elements = $A($$(dom));

        elements.each(function(e) { e.enable() });
    }

    function st_disable_all(dom)
    {
        var elements = $A($$(dom));

        elements.each(function(e) { e.disable() });
    }
    document.observe("dom:loaded", function()
    {

        $('config_test_mode').observe('change', function(event)
        {
            if (this.checked)
            {
                st_enable_all('.st_paypal-sandbox-field');
                st_disable_all('.st_paypal-live-field');
            }
            else
            {
                st_disable_all('.st_paypal-sandbox-field');
                st_enable_all('.st_paypal-live-field');
            }
        });

        new Ajax.PeriodicalUpdater('st_paypal-account-balance', '<?php echo url_for('stPaypalBackend/ajaxPaypalAccountBalance') ?>',
        {
            method: 'get', frequency: 300, decay: 1
        });
        
        new Ajax.PeriodicalUpdater('st_paypal-pending-payments', '<?php echo url_for('stPaypalBackend/ajaxPaypalPendingPayments') ?>',
        {
            method: 'get', frequency: 300, decay: 1
        });
    });
</script>

<?php echo st_get_admin_head('stPaypalPlugin', __('Konfiguracja płatności Paypal'), null,array('stPayment', 'stConfigurationPlugin')) ?>
<div id="sf_admin_content">
    <div id="sf_admin_content_config">
        <?php if ($sf_request->hasErrors()): ?>
        <div class="form-errors">
            <h2><?php echo __('Popraw dane w formularzu.', array(), 'stAdminGeneratorPlugin') ?></h2>
            <dl>
                    <?php foreach ($sf_request->getErrorNames() as $name): ?>
                <dt></dt>
                <dd><?php echo $sf_request->getError($name) ?></dd>
                    <?php endforeach; ?>
            </dl>
        </div>
        <?php elseif ($sf_flash->has('notice')): ?>
        <div class="save-ok">
            <h2><?php echo __($sf_flash->get('notice')) ?></h2>
        </div>
        <?php endif; ?>
        <?php echo form_tag('stPaypalBackend/save', array('id' => 'sf_admin_config_form')) ?>
        <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"') ?>
        <?php echo st_get_admin_action('save', __('Zapisz', null, 'stAdminGeneratorPlugin'), null, array ('name' => 'save')) ?>
        <?php echo st_get_admin_actions_foot() ?>
        <fieldset id="sf_fieldset-paypal-live">
            <div class="st_header">
                <div>
                    <h2><?php echo __('Konfiguracja ogólna') ?></h2>
                </div>
            </div>
            <div class="st_fieldset-content">
                <div class="form-row">
                    <?php echo label_for('config_test_mode', __('Tryb testowy')) ?>
                    <div class="content">
                        <?php echo checkbox_tag('config[test_mode]', true,  $config->get('test_mode')) ?>

                        <br class="st_clear_all"/>
                    </div>
                </div>
            </div>
        </fieldset>
        <fieldset id="sf_fieldset-paypal-live">
            <div class="st_header">
                <div>
                    <h2><?php echo __('Dane dostępowe do API - Tryb produkcyjny') ?></h2>
                </div>
            </div>
            <div class="st_fieldset-content">
                <div class="form-row">
                    <?php echo label_for('config_live_api_username', __('Nazwa użytkownika API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{live_api_username}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{live_api_username}')): ?>
                            <?php echo form_error('config{live_api_username}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_tag('config[live_api_username]', $config->get('live_api_username'), array('disabled' => $config->get('test_mode'), 'class' => 'st_paypal-live-field', 'size' => 30)) ?>

                        <br class="st_clear_all"/>
                    </div>
                </div>
                <div class="form-row">
                    <?php echo label_for('config_live_api_password', __('Hasło API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{live_api_password}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{live_api_password}')): ?>
                            <?php echo form_error('config{live_api_password}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_password_tag('config[live_api_password]', $config->get('live_api_password'), array('disabled' => $config->get('test_mode'), 'class' => 'st_paypal-live-field')) ?>
                        <br class="st_clear_all"/>
                    </div>
                </div>
                <div class="form-row">
                    <?php echo label_for('config_live_api_signature', __('Podpis API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{live_api_signature}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{live_api_signature}')): ?>
                            <?php echo form_error('config{live_api_signature}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_password_tag('config[live_api_signature]', $config->get('live_api_signature'), array('disabled' => $config->get('test_mode'), 'class' => 'st_paypal-live-field', 'size' => 55)) ?>
                        <br class="st_clear_all"/>
                    </div>
                </div>
            </div>
        </fieldset>
        <fieldset id="sf_fieldset-paypal-sandbox">
            <div class="st_header">
                <div>
                    <h2><?php echo __('Dane dostępowe do API - Tryb testowy') ?></h2>
                </div>
            </div>
            <div class="st_fieldset-content">
                <div class="form-row">
                    <?php echo label_for('config_sandbox_api_username', __('Nazwa użytkownika API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{sandbox_api_username}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{sandbox_api_username}')): ?>
                            <?php echo form_error('config{sandbox_api_username}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_tag('config[sandbox_api_username]', $config->get('sandbox_api_username'), array('disabled' => !$config->get('test_mode'), 'class' => 'st_paypal-sandbox-field', 'size' => 30)) ?>
                        <br class="st_clear_all"/>
                    </div>
                </div>
                <div class="form-row">
                    <?php echo label_for('config_sandbox_api_password', __('Hasło API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{sandbox_api_password}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{sandbox_api_password}')): ?>
                            <?php echo form_error('config{sandbox_api_password}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_password_tag('config[sandbox_api_password]', $config->get('sandbox_api_password'), array('disabled' => !$config->get('test_mode'), 'class' => 'st_paypal-sandbox-field')) ?>
                        <br class="st_clear_all"/>
                    </div>
                </div>
                <div class="form-row">
                    <?php echo label_for('config_sandbox_api_signature', __('Podpis API'), array('class' => 'required')) ?>

                    <div class="content<?php if ($sf_request->hasError('config{sandbox_api_signature}')): ?> form-error<?php endif; ?>">
                        <?php if ($sf_request->hasError('config{sandbox_api_signature}')): ?>
                            <?php echo form_error('config{sandbox_api_signature}', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <?php echo input_password_tag('config[sandbox_api_signature]', $config->get('sandbox_api_signature'), array('disabled' => !$config->get('test_mode'), 'class' => 'st_paypal-sandbox-field', 'size' => 55)) ?>
                        <br class="st_clear_all"/>
                    </div>
                </div>
            </div>
        </fieldset>
        <?php if ($config->get('configuration_verified')): ?>
        <fieldset id="sf_fieldset-paypal-account">
            <div class="st_header">
                <div>
                    <h2><?php echo __('Informacje o koncie') ?></h2>
                </div>
            </div>
            <div class="st_fieldset-content">
                <div class="form-row">
                    <div style="float: left; width: 250px"><?php echo __('Bilans konta') ?></div>

                    <div class="content" id="st_paypal-account-balance">
                        <?php echo image_tag('backend/stPaypalPlugin/ajax-loader.gif') ?>
                    </div>
                </div>
                <div class="form-row">
                    <div style="float: left; width: 250px"><?php echo __('Oczekujące płatności') ?></div>

                    <div class="content" id="st_paypal-pending-payments">
                        <?php echo image_tag('backend/stPaypalPlugin/ajax-loader.gif') ?>
                    </div>
                </div>

            </div>
        </fieldset>
        <?php endif; ?>
        <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"') ?>
        <?php echo st_get_admin_action('save', __('Zapisz', null, 'stAdminGeneratorPlugin'), null, array ('name' => 'save')) ?>
        <?php echo st_get_admin_actions_foot() ?>
        </form>
    </div>
</div>
<br class="st_clear_all" />
<?php echo st_get_admin_foot() ?>